/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(nameTemplate="ConditionAnchor(!={p#negated})", allowedUsageTypes={InputType.Guard}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class ConditionAnchorNode
extends FixedWithNextNode
implements Canonicalizable.Unary<Node>,
Lowerable,
GuardingNode {
    public static final NodeClass<ConditionAnchorNode> TYPE = NodeClass.create(ConditionAnchorNode.class);
    @Node.Input(value=InputType.Condition)
    LogicNode condition;
    protected boolean negated;

    public ConditionAnchorNode(LogicNode condition) {
        this(condition, false);
    }

    public ConditionAnchorNode(LogicNode condition, boolean negated) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.negated = negated;
        this.condition = condition;
    }

    public LogicNode condition() {
        return this.condition;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name && this.negated) {
            return "!" + super.toString(verbosity);
        }
        return super.toString(verbosity);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, Node forValue) {
        if (forValue instanceof LogicNegationNode) {
            LogicNegationNode negation = (LogicNegationNode)forValue;
            return new ConditionAnchorNode(negation.getValue(), !this.negated);
        }
        if (forValue instanceof LogicConstantNode) {
            LogicConstantNode c = (LogicConstantNode)forValue;
            if (c.getValue() == this.negated || this.hasUsages()) {
                return new ValueAnchorNode();
            }
            return null;
        }
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage() == GraphState.GuardsStage.FIXED_DEOPTS) {
            ValueAnchorNode newAnchor = this.graph().add(new ValueAnchorNode());
            this.graph().replaceFixedWithFixed(this, newAnchor);
        }
    }

    @Override
    public Node getValue() {
        return this.condition;
    }
}

