/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ProfileData;

@NodeInfo
public abstract class ControlSplitNode
extends FixedNode {
    public static final NodeClass<ControlSplitNode> TYPE = NodeClass.create(ControlSplitNode.class);

    protected ControlSplitNode(NodeClass<? extends ControlSplitNode> c, Stamp stamp) {
        super((NodeClass<? extends FixedNode>)c, stamp);
    }

    public abstract double probability(AbstractBeginNode var1);

    public abstract boolean setProbability(AbstractBeginNode var1, ProfileData.BranchProbabilityData var2);

    public double[] successorProbabilities() {
        double[] probabilities = new double[this.getSuccessorCount()];
        int index = 0;
        for (Node succ : this.successors()) {
            probabilities[index++] = this.probability((AbstractBeginNode)succ);
        }
        assert (index == this.getSuccessorCount());
        return probabilities;
    }

    public abstract AbstractBeginNode getPrimarySuccessor();

    public abstract int getSuccessorCount();

    public abstract ProfileData getProfileData();
}

