/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, cyclesRationale="read", size=NodeSize.SIZE_1)
public final class SafepointNode
extends DeoptimizingFixedWithNextNode
implements Lowerable,
LIRLowerable,
Simplifiable {
    public static final NodeClass<SafepointNode> TYPE = NodeClass.create(SafepointNode.class);
    @Node.OptionalInput(value=InputType.Association)
    protected AbstractBeginNode loop;

    public SafepointNode() {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)TYPE, StampFactory.forVoid());
    }

    public SafepointNode(LoopBeginNode loop) {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.loop = loop;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.visitSafepointNode(this);
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.next() instanceof SafepointNode) {
            this.graph().removeFixed(this);
        }
        if (this.loop != null && !(this.loop instanceof LoopBeginNode)) {
            this.graph().removeFixed(this);
        }
    }

    public void setLoop(AbstractBeginNode loop) {
        this.updateUsagesInterface(this.loop, loop);
        this.loop = loop;
    }

    public AbstractBeginNode getLoop() {
        return this.loop;
    }
}

