/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Map;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeFlood;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.util.CollectionsUtil;

@NodeInfo(nameTemplate="Phi({i#values}, {p#valueDescription})")
public class ValuePhiNode
extends PhiNode {
    public static final NodeClass<ValuePhiNode> TYPE = NodeClass.create(ValuePhiNode.class);
    @Node.Input(value=InputType.Value)
    protected NodeInputList<ValueNode> values;

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge) {
        this((NodeClass<? extends ValuePhiNode>)TYPE, stamp, merge);
    }

    protected ValuePhiNode(NodeClass<? extends ValuePhiNode> c, Stamp stamp, AbstractMergeNode merge) {
        super(c, stamp, merge);
        assert (stamp != StampFactory.forVoid());
        this.values = new NodeInputList(this);
    }

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge, ValueNode ... values) {
        this(TYPE, stamp, merge, values);
    }

    public ValuePhiNode(NodeClass<? extends ValuePhiNode> c, Stamp stamp, AbstractMergeNode merge, ValueNode ... values) {
        super(c, stamp, merge);
        assert (stamp != StampFactory.forVoid());
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    @Override
    public InputType valueInputType() {
        return InputType.Value;
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    public boolean inferStamp() {
        Stamp valuesStamp = StampTool.meetOrNull(this.values(), this);
        if (valuesStamp == null) {
            valuesStamp = this.stamp;
        }
        if (this.stamp.isCompatible(valuesStamp = this.tryInferLoopPhiStamp(valuesStamp))) {
            valuesStamp = this.stamp.join(valuesStamp);
        }
        return this.updateStamp(valuesStamp);
    }

    private Stamp tryInferLoopPhiStamp(Stamp valuesStamp) {
        if (this.isAlive() && this.isLoopPhi() && valuesStamp.isPointerStamp()) {
            Stamp firstValueStamp = this.firstValue().stamp(NodeView.DEFAULT);
            if (firstValueStamp.meet(valuesStamp).equals(firstValueStamp)) {
                return valuesStamp;
            }
            boolean hasDirectPhiInput = false;
            for (ValueNode value : this.values()) {
                if (!(value instanceof ValuePhiNode)) continue;
                hasDirectPhiInput = true;
                break;
            }
            if (!hasDirectPhiInput) {
                return valuesStamp;
            }
            Stamp currentStamp = firstValueStamp;
            NodeFlood flood = new NodeFlood(this.graph());
            flood.addAll(this.values());
            for (Node node : flood) {
                ValueNode value;
                if (node == this) continue;
                if (node instanceof ValuePhiNode) {
                    ValuePhiNode phi = (ValuePhiNode)node;
                    flood.addAll(phi.values());
                    continue;
                }
                if (!(node instanceof ValueNode) || !(currentStamp = currentStamp.meet((value = (ValueNode)node).stamp(NodeView.DEFAULT))).equals(valuesStamp)) continue;
                return valuesStamp;
            }
            if (!currentStamp.equals(valuesStamp) && currentStamp.meet(valuesStamp).equals(valuesStamp)) {
                return currentStamp;
            }
        }
        return valuesStamp;
    }

    @Override
    public boolean verify() {
        Stamp s = null;
        for (ValueNode input : this.values()) {
            assert (input != null);
            if (s == null) {
                s = input.stamp(NodeView.DEFAULT);
                continue;
            }
            if (s.isCompatible(input.stamp(NodeView.DEFAULT))) continue;
            this.fail("Phi Input Stamps are not compatible. Phi:%s inputs:%s", this, CollectionsUtil.mapAndJoin(this.values(), x -> x.toString() + ":" + x.stamp(NodeView.DEFAULT), ", "));
        }
        return super.verify();
    }

    @Override
    protected String valueDescription() {
        return this.stamp(NodeView.DEFAULT).unrestricted().toString();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> properties = super.getDebugProperties(map);
        properties.put("valueDescription", this.valueDescription());
        return properties;
    }

    @Override
    public PhiNode duplicateOn(AbstractMergeNode newMerge) {
        return this.graph().addWithoutUnique(new ValuePhiNode(this.stamp(NodeView.DEFAULT), newMerge));
    }

    @Override
    public ValuePhiNode duplicateWithValues(AbstractMergeNode newMerge, ValueNode ... newValues) {
        return new ValuePhiNode(this.stamp(NodeView.DEFAULT), newMerge, newValues);
    }

    @Override
    public ProxyNode createProxyFor(LoopExitNode lex) {
        return this.graph().addWithoutUnique(new ValueProxyNode(this, lex));
    }
}

