/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.UnaryArithmeticNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class AbsNode
extends UnaryArithmeticNode<ArithmeticOpTable.UnaryOp.Abs>
implements ArithmeticLIRLowerable,
NarrowableArithmeticNode {
    public static final NodeClass<AbsNode> TYPE = NodeClass.create(AbsNode.class);

    public AbsNode(ValueNode x) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getAbs(), x);
    }

    public static ValueNode create(ValueNode value, NodeView view) {
        ValueNode synonym = AbsNode.findSynonym(value, view);
        if (synonym != null) {
            return synonym;
        }
        return new AbsNode(value);
    }

    protected static ValueNode findSynonym(ValueNode forValue, NodeView view) {
        ArithmeticOpTable.UnaryOp<ArithmeticOpTable.UnaryOp.Abs> absOp = ArithmeticOpTable.forStamp(forValue.stamp(view)).getAbs();
        ValueNode synonym = UnaryArithmeticNode.findSynonym(forValue, absOp);
        if (synonym != null) {
            return synonym;
        }
        if (forValue instanceof AbsNode) {
            return forValue;
        }
        if (forValue.stamp(view) instanceof IntegerStamp && ((IntegerStamp)forValue.stamp(view)).isPositive()) {
            return forValue;
        }
        if (forValue instanceof NegateNode) {
            NegateNode negate = (NegateNode)forValue;
            return AbsNode.create(negate.getValue(), view);
        }
        return null;
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.UnaryOp.Abs> getOp(ArithmeticOpTable table) {
        return table.getAbs();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        ValueNode synonym = AbsNode.findSynonym(forValue, NodeView.from(tool));
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (NarrowableArithmeticNode.super.isNarrowable(resultBits)) {
            IntegerStamp inputStamp = (IntegerStamp)this.getValue().stamp(NodeView.DEFAULT);
            return CodeUtil.minValue((int)resultBits) <= inputStamp.lowerBound() && inputStamp.upperBound() <= CodeUtil.maxValue((int)resultBits);
        }
        return false;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitMathAbs(nodeValueMap.operand(this.getValue())));
    }
}

