/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.ExpandBitsNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class CompressBitsNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Compress> {
    public static final NodeClass<CompressBitsNode> TYPE = NodeClass.create(CompressBitsNode.class);

    public CompressBitsNode(ValueNode value, ValueNode mask) {
        super(TYPE, CompressBitsNode.getArithmeticOpTable(value).getCompress(), value, mask);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Compress> getOp(ArithmeticOpTable table) {
        return table.getCompress();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode value, ValueNode mask) {
        ValueNode ret = super.canonical(tool, value, mask);
        if (ret != this) {
            return ret;
        }
        JavaKind kind = value.getStackKind();
        GraalError.guarantee(kind == JavaKind.Int || kind == JavaKind.Long, "unexpected Java kind %s", (Object)kind);
        if (mask.isConstant()) {
            JavaConstant maskAsConstant = mask.asJavaConstant();
            GraalError.guarantee(!value.isConstant(), "should have been folded in super.canonical");
            if (kind == JavaKind.Int) {
                int maskValue = maskAsConstant.asInt();
                if (maskValue == 0) {
                    return ConstantNode.forInt(0);
                }
                if (maskValue == -1) {
                    return value;
                }
            } else {
                long maskValue = maskAsConstant.asLong();
                if (maskValue == 0L) {
                    return ConstantNode.forLong(0L);
                }
                if (maskValue == -1L) {
                    return value;
                }
            }
        }
        if (mask instanceof LeftShiftNode && ((LeftShiftNode)mask).getX().isConstant()) {
            if (kind == JavaKind.Int) {
                int maskX = ((LeftShiftNode)mask).getX().asJavaConstant().asInt();
                if (maskX == 1) {
                    return AndNode.create(RightShiftNode.create(value, ((LeftShiftNode)mask).getY(), NodeView.DEFAULT), ConstantNode.forInt(1), NodeView.DEFAULT);
                }
                if (maskX == -1) {
                    return UnsignedRightShiftNode.create(value, ((LeftShiftNode)mask).getY(), NodeView.DEFAULT);
                }
            } else {
                long maskX = ((LeftShiftNode)mask).getX().asJavaConstant().asLong();
                if (maskX == 1L) {
                    return AndNode.create(RightShiftNode.create(value, ((LeftShiftNode)mask).getY(), NodeView.DEFAULT), ConstantNode.forLong(1L), NodeView.DEFAULT);
                }
                if (maskX == -1L) {
                    return UnsignedRightShiftNode.create(value, ((LeftShiftNode)mask).getY(), NodeView.DEFAULT);
                }
            }
        }
        if (value instanceof ExpandBitsNode && ((ExpandBitsNode)value).getY() == mask) {
            return AndNode.create(new CompressBitsNode(mask, mask), ((ExpandBitsNode)value).getX(), NodeView.DEFAULT);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitIntegerCompress(builder.operand(this.getX()), builder.operand(this.getY())));
    }
}

