/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.MaxNode;
import org.graalvm.compiler.nodes.calc.MinNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.UnsignedMaxNode;
import org.graalvm.compiler.nodes.calc.UnsignedMinNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="MinMax")
public abstract class MinMaxNode<OP>
extends BinaryArithmeticNode<OP>
implements NarrowableArithmeticNode,
Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<MinMaxNode> TYPE = NodeClass.create(MinMaxNode.class);

    protected MinMaxNode(NodeClass<? extends BinaryArithmeticNode<OP>> c, ArithmeticOpTable.BinaryOp<OP> opForStampComputation, ValueNode x, ValueNode y) {
        super(c, opForStampComputation, x, y);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode result;
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        NodeView view = NodeView.from(tool);
        if (forX.isConstant()) {
            ValueNode result2 = this.tryCanonicalizeWithConstantInput(forX, forY);
            if (result2 != this) {
                return result2;
            }
        } else if (forY.isConstant() && (result = this.tryCanonicalizeWithConstantInput(forY, forX)) != this) {
            return result;
        }
        return MinMaxNode.reassociateMatchedValues(this, ValueNode.isConstantPredicate(), forX, forY, view);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value op1 = nodeValueMap.operand(this.getX());
        assert (op1 != null) : this.getX() + ", this=" + this;
        Value op2 = nodeValueMap.operand(this.getY());
        if (this.shouldSwapInputs(nodeValueMap)) {
            Value tmp = op1;
            op1 = op2;
            op2 = tmp;
        }
        if (this instanceof MaxNode) {
            nodeValueMap.setResult(this, gen.emitMathMax(op1, op2));
        } else if (this instanceof MinNode) {
            nodeValueMap.setResult(this, gen.emitMathMin(op1, op2));
        } else if (this instanceof UnsignedMaxNode) {
            nodeValueMap.setResult(this, gen.emitMathUnsignedMax(op1, op2));
        } else if (this instanceof UnsignedMinNode) {
            nodeValueMap.setResult(this, gen.emitMathUnsignedMin(op1, op2));
        } else {
            throw GraalError.shouldNotReachHereUnexpectedValue(this);
        }
    }

    private ValueNode tryCanonicalizeWithConstantInput(ValueNode constantValue, ValueNode otherValue) {
        if (constantValue.isJavaConstant() && constantValue.asJavaConstant().getJavaKind().isNumericFloat()) {
            JavaConstant constant = constantValue.asJavaConstant();
            JavaKind kind = constant.getJavaKind();
            assert (kind == JavaKind.Float || kind == JavaKind.Double);
            if (kind == JavaKind.Float && Float.isNaN(constant.asFloat()) || kind == JavaKind.Double && Double.isNaN(constant.asDouble())) {
                return constantValue;
            }
            if (this instanceof MaxNode ? kind == JavaKind.Float && constant.asFloat() == Float.NEGATIVE_INFINITY || kind == JavaKind.Double && constant.asDouble() == Double.NEGATIVE_INFINITY : this instanceof MinNode && (kind == JavaKind.Float && constant.asFloat() == Float.POSITIVE_INFINITY || kind == JavaKind.Double && constant.asDouble() == Double.POSITIVE_INFINITY)) {
                return otherValue;
            }
        }
        return this;
    }

    protected boolean isNarrowable(int resultBits, NumUtil.Signedness signedness) {
        if (signedness == NumUtil.Signedness.SIGNED) {
            IntegerStamp xStamp = (IntegerStamp)this.getX().stamp(NodeView.DEFAULT);
            IntegerStamp yStamp = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
            long lower = Math.min(xStamp.lowerBound(), yStamp.lowerBound());
            long upper = Math.max(xStamp.upperBound(), yStamp.upperBound());
            return NumUtil.minValue(resultBits) <= lower && upper <= NumUtil.maxValue(resultBits);
        }
        if (signedness == NumUtil.Signedness.UNSIGNED) {
            IntegerStamp xStamp = (IntegerStamp)this.getX().stamp(NodeView.DEFAULT);
            IntegerStamp yStamp = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
            long upper = NumUtil.maxUnsigned(xStamp.unsignedUpperBound(), yStamp.unsignedUpperBound());
            return Long.compareUnsigned(upper, NumUtil.maxValueUnsigned(resultBits)) <= 0;
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)signedness);
    }

    public static ValueNode fromConditional(ConditionalNode conditional) {
        return MinMaxNode.fromConditional(conditional.condition(), conditional.trueValue(), conditional.falseValue(), NodeView.DEFAULT);
    }

    public static ValueNode fromConditional(LogicNode condition, ValueNode trueValue, ValueNode falseValue, NodeView view) {
        ValueNode otherValue;
        boolean flipped;
        if (!trueValue.stamp(view).isIntegerStamp()) {
            return null;
        }
        if (!(condition instanceof IntegerLessThanNode) && !(condition instanceof IntegerBelowNode)) {
            return null;
        }
        NumUtil.Signedness signedness = condition instanceof IntegerBelowNode ? NumUtil.Signedness.UNSIGNED : NumUtil.Signedness.SIGNED;
        CompareNode compare = (CompareNode)condition;
        ValueNode x = compare.getX();
        ValueNode y = compare.getY();
        ValueNode minMax = null;
        ValueNode yValue = null;
        if (MinMaxNode.equalOrOffBy1(signedness, y, falseValue)) {
            flipped = false;
            yValue = falseValue;
        } else if (MinMaxNode.equalOrOffBy1(signedness, y, trueValue)) {
            flipped = true;
            yValue = trueValue;
        } else {
            return null;
        }
        IntegerConvertNode extension = null;
        ValueNode valueNode = otherValue = flipped ? falseValue : trueValue;
        if (x != otherValue) {
            if ((otherValue instanceof SignExtendNode || otherValue instanceof ZeroExtendNode) && ((IntegerConvertNode)otherValue).getValue() == x) {
                extension = (IntegerConvertNode)otherValue;
            } else if ((x instanceof SignExtendNode || x instanceof ZeroExtendNode) && ((IntegerConvertNode)x).getValue() == otherValue) {
                x = otherValue;
                y = yValue;
            } else {
                return null;
            }
        }
        if (y.isJavaConstant() && yValue.isJavaConstant() && y.asJavaConstant().asLong() != yValue.asJavaConstant().asLong()) {
            JavaKind kind = y.asJavaConstant().getJavaKind();
            long value = yValue.asJavaConstant().asLong();
            PrimitiveConstant newConstant = JavaConstant.forIntegerKind((JavaKind)kind, (long)value);
            y = new ConstantNode((Constant)newConstant, (Stamp)StampFactory.forInteger(kind, value, value));
        }
        if (flipped) {
            minMax = signedness == NumUtil.Signedness.SIGNED ? MaxNode.create(x, y, view) : UnsignedMaxNode.create(x, y, view);
        } else {
            ValueNode valueNode2 = minMax = signedness == NumUtil.Signedness.SIGNED ? MinNode.create(x, y, view) : UnsignedMinNode.create(x, y, view);
        }
        if (extension != null) {
            boolean zeroExtend = extension instanceof ZeroExtendNode;
            Stamp toStamp = trueValue.stamp(view).unrestricted();
            minMax = IntegerConvertNode.convert(minMax, toStamp, zeroExtend, view);
        }
        return minMax;
    }

    private static boolean equalOrOffBy1(NumUtil.Signedness signedness, ValueNode a, ValueNode b) {
        if (a == b) {
            return true;
        }
        if (a.isJavaConstant() && b.isJavaConstant()) {
            long y;
            long x = a.asJavaConstant().asLong();
            if (x == (y = b.asJavaConstant().asLong())) {
                return true;
            }
            if (x == y + 1L) {
                long upperLimit;
                long l = upperLimit = signedness == NumUtil.Signedness.SIGNED ? NumUtil.maxValue(64) : NumUtil.maxValueUnsigned(64);
                return y != upperLimit;
            }
        }
        return false;
    }

    public abstract ValueNode asConditional(LoweringProvider var1);

    protected static ValueNode maybeExtendForCompare(ValueNode value, LoweringProvider lowerer, NumUtil.Signedness signedness) {
        Stamp fromStamp = value.stamp(NodeView.DEFAULT);
        if (fromStamp instanceof PrimitiveStamp && PrimitiveStamp.getBits(fromStamp) < lowerer.smallestCompareWidth()) {
            IntegerStamp toStamp = IntegerStamp.create(lowerer.smallestCompareWidth());
            boolean zeroExtend = signedness == NumUtil.Signedness.UNSIGNED;
            return IntegerConvertNode.convert(value, (Stamp)toStamp, zeroExtend, NodeView.DEFAULT);
        }
        return value;
    }
}

