/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.PointerEqualsNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.VirtualBoxingNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(shortName="==")
public final class ObjectEqualsNode
extends PointerEqualsNode
implements Virtualizable {
    public static final NodeClass<ObjectEqualsNode> TYPE = NodeClass.create(ObjectEqualsNode.class);
    private static final ObjectEqualsOp OP = new ObjectEqualsOp();

    public ObjectEqualsNode(ValueNode x, ValueNode y) {
        super((NodeClass<? extends PointerEqualsNode>)TYPE, x, y);
        assert (x.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp);
        assert (y.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp);
    }

    public static LogicNode create(ValueNode x, ValueNode y, ConstantReflectionProvider constantReflection, NodeView view) {
        LogicNode result = CompareNode.tryConstantFold(CanonicalCondition.EQ, x, y, constantReflection, false);
        if (result != null) {
            return result;
        }
        result = ObjectEqualsNode.findSynonym(x, y, view);
        if (result != null) {
            return result;
        }
        return new ObjectEqualsNode(x, y);
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = OP.canonical(constantReflection, metaAccess, options, null, CanonicalCondition.EQ, false, x, y, view);
        if (result != null) {
            return result;
        }
        return ObjectEqualsNode.create(x, y, constantReflection, view);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), CanonicalCondition.EQ, false, forX, forY, view);
        if (value != null) {
            return value;
        }
        return this;
    }

    private static LogicNode virtualizeNonVirtualComparison(VirtualObjectNode virtual, ValueNode other, StructuredGraph graph, VirtualizerTool tool) {
        VirtualBoxingNode virtualBoxingNode;
        if (virtual instanceof VirtualBoxingNode && other.isConstant() && (virtualBoxingNode = (VirtualBoxingNode)virtual).getBoxingKind() == JavaKind.Boolean) {
            JavaConstant otherUnboxed = tool.getConstantReflection().unboxPrimitive(other.asJavaConstant());
            if (otherUnboxed != null && otherUnboxed.getJavaKind() == JavaKind.Boolean) {
                int expectedValue = otherUnboxed.asBoolean() ? 1 : 0;
                return new IntegerEqualsNode(virtualBoxingNode.getBoxedValue(tool), ConstantNode.forInt(expectedValue, graph));
            }
            return LogicConstantNode.contradiction(graph);
        }
        if (virtual.hasIdentity()) {
            return LogicConstantNode.contradiction(graph);
        }
        return null;
    }

    public static LogicNode virtualizeComparison(ValueNode x, ValueNode y, StructuredGraph graph, VirtualizerTool tool) {
        VirtualObjectNode yVirtual;
        ValueNode xAlias = tool.getAlias(x);
        ValueNode yAlias = tool.getAlias(y);
        VirtualObjectNode xVirtual = xAlias instanceof VirtualObjectNode ? (VirtualObjectNode)xAlias : null;
        VirtualObjectNode virtualObjectNode = yVirtual = yAlias instanceof VirtualObjectNode ? (VirtualObjectNode)yAlias : null;
        if (xVirtual != null && yVirtual == null) {
            return ObjectEqualsNode.virtualizeNonVirtualComparison(xVirtual, yAlias, graph, tool);
        }
        if (xVirtual == null && yVirtual != null) {
            return ObjectEqualsNode.virtualizeNonVirtualComparison(yVirtual, xAlias, graph, tool);
        }
        if (xVirtual != null && yVirtual != null) {
            if (xVirtual.hasIdentity() ^ yVirtual.hasIdentity()) {
                return LogicConstantNode.contradiction(graph);
            }
            if (!xVirtual.hasIdentity() && !yVirtual.hasIdentity()) {
                MetaAccessProvider metaAccess;
                ResolvedJavaType type = xVirtual.type();
                if (type.equals(yVirtual.type()) && (type.equals((metaAccess = tool.getMetaAccess()).lookupJavaType(Integer.class)) || type.equals(metaAccess.lookupJavaType(Long.class)))) {
                    assert (xVirtual.entryCount() == 1 && yVirtual.entryCount() == 1);
                    assert (xVirtual.entryKind(tool.getMetaAccessExtensionProvider(), 0).getStackKind() == JavaKind.Int || xVirtual.entryKind(tool.getMetaAccessExtensionProvider(), 0) == JavaKind.Long);
                    return new IntegerEqualsNode(tool.getEntry(xVirtual, 0), tool.getEntry(yVirtual, 0));
                }
            } else {
                return LogicConstantNode.forBoolean(xVirtual == yVirtual, graph);
            }
        }
        return null;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        LogicNode node = ObjectEqualsNode.virtualizeComparison(this.getX(), this.getY(), this.graph(), tool);
        if (node == null) {
            return;
        }
        tool.ensureAdded(node);
        tool.replaceWithValue(node);
    }

    public static class ObjectEqualsOp
    extends PointerEqualsNode.PointerEqualsOp {
        @Override
        protected LogicNode canonicalizeSymmetricConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, Constant constant, ValueNode nonConstant, boolean mirrored, boolean unorderedIsTrue, NodeView view) {
            ResolvedJavaType type = constantReflection.asJavaType(constant);
            if (type != null && nonConstant instanceof GetClassNode) {
                GetClassNode getClassNode = (GetClassNode)nonConstant;
                ValueNode object = getClassNode.getObject();
                assert (((ObjectStamp)object.stamp(view)).nonNull());
                if (!type.isPrimitive() && (type.isConcrete() || type.isArray())) {
                    return InstanceOfNode.create(TypeReference.createExactTrusted(type), object);
                }
                return LogicConstantNode.forBoolean(false);
            }
            if (nonConstant instanceof AbstractNewObjectNode || nonConstant instanceof AllocatedObjectNode) {
                assert (!(nonConstant instanceof BoxNode));
                return LogicConstantNode.forBoolean(false);
            }
            return super.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, constant, nonConstant, mirrored, unorderedIsTrue, view);
        }

        @Override
        protected CompareNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            if (newX.stamp(view) instanceof ObjectStamp && newY.stamp(view) instanceof ObjectStamp) {
                return new ObjectEqualsNode(newX, newY);
            }
            if (newX.stamp(view) instanceof AbstractPointerStamp && newY.stamp(view) instanceof AbstractPointerStamp) {
                return new PointerEqualsNode(newX, newY);
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(newX.stamp(view) + " " + newY.stamp(view));
        }
    }
}

