/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import java.util.Set;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ArithmeticOperation;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public abstract class ShiftNode<OP>
extends BinaryNode
implements ArithmeticOperation,
ArithmeticLIRLowerable,
NarrowableArithmeticNode {
    public static final NodeClass<ShiftNode> TYPE = NodeClass.create(ShiftNode.class);

    protected ShiftNode(NodeClass<? extends ShiftNode<OP>> c, ArithmeticOpTable.ShiftOp<OP> opForStampComputation, ValueNode x, ValueNode s) {
        super(c, opForStampComputation.foldStamp(x.stamp(NodeView.DEFAULT), (IntegerStamp)s.stamp(NodeView.DEFAULT)), x, s);
        assert (((IntegerStamp)s.stamp(NodeView.DEFAULT)).getBits() == 32);
    }

    protected abstract ArithmeticOpTable.ShiftOp<OP> getOp(ArithmeticOpTable var1);

    protected final ArithmeticOpTable.ShiftOp<OP> getOp(ValueNode forValue) {
        return this.getOp(BinaryArithmeticNode.getArithmeticOpTable(forValue));
    }

    @Override
    public final ArithmeticOpTable.ShiftOp<OP> getArithmeticOp() {
        return this.getOp(this.getX());
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return ((ArithmeticOpTable.ShiftOp)this.getArithmeticOp()).foldStamp(stampX, (IntegerStamp)stampY);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode valueNode = ShiftNode.canonical(this.getOp(forX), this.stamp(NodeView.DEFAULT), forX, forY, view);
        if (valueNode != null) {
            return valueNode;
        }
        return this;
    }

    public static <OP> ValueNode canonical(ArithmeticOpTable.ShiftOp<OP> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        if (forX.isConstant() && forY.isConstant()) {
            JavaConstant amount = forY.asJavaConstant();
            assert (amount.getJavaKind() == JavaKind.Int);
            return ConstantNode.forPrimitive(stamp, op.foldConstant(forX.asConstant(), amount.asInt()));
        }
        return null;
    }

    public static ValueNode shiftOp(ValueNode x, ValueNode y, NodeView view, ArithmeticOpTable.ShiftOp<?> op) {
        if (IntegerStamp.OPS.getShl().equals(op)) {
            return LeftShiftNode.create(x, y, view);
        }
        if (IntegerStamp.OPS.getShr().equals(op)) {
            return RightShiftNode.create(x, y, view);
        }
        if (IntegerStamp.OPS.getUShr().equals(op)) {
            return UnsignedRightShiftNode.create(x, y, view);
        }
        if (Set.of(IntegerStamp.OPS.getShiftOps()).contains(op)) {
            GraalError.unimplemented(String.format("creating %s via ShiftNode#shiftOp is not implemented yet", op));
        } else {
            GraalError.shouldNotReachHere(String.format("%s is not a shift operation!", op));
        }
        return null;
    }

    public int getShiftAmountMask() {
        return ((ArithmeticOpTable.ShiftOp)this.getArithmeticOp()).getShiftAmountMask(this.stamp(NodeView.DEFAULT));
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        assert (CodeUtil.isPowerOf2((int)resultBits));
        int narrowMask = resultBits <= 32 ? 31 : 63;
        int wideMask = this.getShiftAmountMask();
        assert ((wideMask & narrowMask) == narrowMask) : String.format("wideMask %x should be wider than narrowMask %x", wideMask, narrowMask);
        IntegerStamp yStamp = (IntegerStamp)this.getY().stamp(NodeView.DEFAULT);
        return (yStamp.mayBeSet() & (long)(wideMask & ~narrowMask)) == 0L;
    }
}

