/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class SignumNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<SignumNode> TYPE = NodeClass.create(SignumNode.class);

    public SignumNode(ValueNode x) {
        super(TYPE, SignumNode.computeStamp(x.stamp(NodeView.DEFAULT)), x);
    }

    private static Stamp computeStamp(Stamp stamp) {
        FloatStamp floatStamp = (FloatStamp)stamp;
        if (floatStamp.isNaN()) {
            return floatStamp;
        }
        if (floatStamp.isNonNaN()) {
            if (floatStamp.lowerBound() > 0.0) {
                return new FloatStamp(floatStamp.getBits(), 1.0, 1.0, true);
            }
            if (floatStamp.upperBound() < 0.0) {
                return new FloatStamp(floatStamp.getBits(), -1.0, -1.0, true);
            }
        }
        FloatStamp result = new FloatStamp(floatStamp.getBits(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, floatStamp.isNonNaN());
        if (floatStamp.contains(0.0)) {
            result = (FloatStamp)result.meet(new FloatStamp(floatStamp.getBits(), 0.0, 0.0, true));
        }
        if (floatStamp.upperBound() > 0.0) {
            result = (FloatStamp)result.meet(new FloatStamp(floatStamp.getBits(), 1.0, 1.0, true));
        }
        if (floatStamp.lowerBound() < 0.0) {
            result = (FloatStamp)result.meet(new FloatStamp(floatStamp.getBits(), -1.0, -1.0, true));
        }
        return result;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        return SignumNode.computeStamp(newStamp);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isJavaConstant()) {
            JavaConstant c = forValue.asJavaConstant();
            switch (c.getJavaKind()) {
                case Float: {
                    return ConstantNode.forFloat(Math.signum(c.asFloat()));
                }
                case Double: {
                    return ConstantNode.forDouble(Math.signum(c.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(c.getJavaKind());
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitMathSignum(nodeValueMap.operand(this.getValue())));
    }
}

