/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(shortName="-")
public class SubNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Sub>
implements NarrowableArithmeticNode {
    public static final NodeClass<SubNode> TYPE = NodeClass.create(SubNode.class);

    public SubNode(ValueNode x, ValueNode y) {
        this(TYPE, x, y);
    }

    protected SubNode(NodeClass<? extends SubNode> c, ValueNode x, ValueNode y) {
        super(c, SubNode.getArithmeticOpTable(x).getSub(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Sub> op = ArithmeticOpTable.forStamp(x.stamp(view)).getSub();
        ConstantNode tryConstantFold = SubNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return SubNode.canonical(null, op, stamp, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Sub> getOp(ArithmeticOpTable table) {
        return table.getSub();
    }

    private static ValueNode canonical(SubNode subNode, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Sub> op, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view) {
        Constant zero;
        SubNode self = subNode;
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY) && (zero = op.getZero(forX.stamp(view))) != null) {
            return ConstantNode.forPrimitive(stamp, zero);
        }
        boolean mayReassociate = BinaryArithmeticNode.mayReassociate(op, stamp);
        if (mayReassociate) {
            BinaryArithmeticNode y;
            BinaryArithmeticNode x;
            if (forX instanceof AddNode) {
                x = (AddNode)forX;
                if (x.getY() == forY) {
                    return x.getX();
                }
                if (x.getX() == forY) {
                    return x.getY();
                }
            } else if (forX instanceof SubNode && (x = (SubNode)forX).getX() == forY) {
                return NegateNode.create(x.getY(), view);
            }
            if (forY instanceof AddNode) {
                y = (AddNode)forY;
                if (y.getX() == forX) {
                    return NegateNode.create(y.getY(), view);
                }
                if (y.getY() == forX) {
                    return NegateNode.create(y.getX(), view);
                }
            } else if (forY instanceof SubNode && (y = (SubNode)forY).getX() == forX) {
                return y.getY();
            }
            if (forX instanceof OrNode && forY instanceof XorNode) {
                OrNode or = (OrNode)forX;
                XorNode xor = (XorNode)forY;
                if (or.getX() == xor.getX() && or.getY() == xor.getY() || or.getX() == xor.getY() && or.getY() == xor.getX()) {
                    return AndNode.create(or.getX(), or.getY(), view);
                }
            }
        }
        if (forY.isConstant()) {
            long i;
            ValueNode reassociated;
            c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            if (mayReassociate && self != null && (reassociated = SubNode.reassociateMatchedValues(self, ValueNode.isConstantPredicate(), forX, forY, view)) != self) {
                return reassociated;
            }
            if (c instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger() && ((i = ((PrimitiveConstant)c).asLong()) < 0L || ((IntegerStamp)StampFactory.forKind(forY.getStackKind())).contains(-i))) {
                return BinaryArithmeticNode.add(forX, ConstantNode.forIntegerStamp(stamp, -i), view);
            }
        } else if (forX.isConstant()) {
            c = forX.asConstant();
            if (ArithmeticOpTable.forStamp(stamp).getAdd().isNeutral(c)) {
                return NegateNode.create(forY, view);
            }
            if (mayReassociate && self != null) {
                return SubNode.reassociateMatchedValues(self, ValueNode.isConstantPredicate(), forX, forY, view);
            }
        }
        if (forY instanceof NegateNode) {
            return BinaryArithmeticNode.add(forX, ((NegateNode)forY).getValue(), view);
        }
        return self != null ? self : new SubNode(forX, forY);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Sub> op = this.getOp(forX, forY);
        return SubNode.canonical(this, op, this.stamp, forX, forY, view);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitSub(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY()), false));
    }

    protected boolean isExact() {
        return false;
    }
}

