/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodePredicates;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BeginStateSplitNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MemoryProxyNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public class CaptureStateBeginNode
extends BeginStateSplitNode
implements Canonicalizable {
    public static final NodeClass<CaptureStateBeginNode> TYPE = NodeClass.create(CaptureStateBeginNode.class);

    public CaptureStateBeginNode() {
        super((NodeClass<? extends BeginStateSplitNode>)TYPE);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.stateAfter() == null) {
            return new BeginNode();
        }
        return this;
    }

    @Override
    public boolean verify() {
        Node node = this.predecessor();
        if (node instanceof LoopExitNode) {
            LoopExitNode loopExit = (LoopExitNode)node;
            assert (loopExit.usages().stream().allMatch(NodePredicates.isA(ValueProxyNode.class).or(MemoryProxyNode.class))) : String.format("LoopExit has disallowed usages %s", loopExit);
        }
        return super.verify();
    }
}

