/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.spi.SwitchFoldable;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo
public final class IntegerSwitchNode
extends SwitchNode
implements LIRLowerable,
Simplifiable,
SwitchFoldable {
    public static final NodeClass<IntegerSwitchNode> TYPE = NodeClass.create(IntegerSwitchNode.class);
    protected final int[] keys;
    protected final boolean areKeysContiguous;

    public IntegerSwitchNode(ValueNode value, AbstractBeginNode[] successors, int[] keys, int[] keySuccessors, ProfileData.SwitchProbabilityData profileData) {
        super(TYPE, value, successors, keySuccessors, profileData);
        assert (keySuccessors.length == keys.length + 1);
        assert (keySuccessors.length == profileData.getKeyProbabilities().length);
        this.keys = keys;
        boolean bl = this.areKeysContiguous = keys.length > 0 && keys[keys.length - 1] - keys[0] + 1 == keys.length;
        assert (value.stamp(NodeView.DEFAULT) instanceof PrimitiveStamp && value.stamp(NodeView.DEFAULT).getStackKind().isNumericInteger());
        assert (this.assertSorted());
        assert (this.assertNoUntargettedSuccessor());
    }

    private boolean assertSorted() {
        for (int i = 1; i < this.keys.length; ++i) {
            assert (this.keys[i - 1] < this.keys[i]);
        }
        return true;
    }

    private boolean assertNoUntargettedSuccessor() {
        boolean[] checker = new boolean[this.successors.size()];
        for (int successorIndex : this.keySuccessors) {
            checker[successorIndex] = true;
        }
        checker[this.defaultSuccessorIndex()] = true;
        for (boolean b : checker) {
            assert (b);
        }
        return true;
    }

    public IntegerSwitchNode(ValueNode value, int successorCount, int[] keys, int[] keySuccessors, ProfileData.SwitchProbabilityData profileData) {
        this(value, new AbstractBeginNode[successorCount], keys, keySuccessors, profileData);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    public JavaConstant keyAt(int i) {
        return JavaConstant.forInt((int)this.keys[i]);
    }

    @Override
    public int intKeyAt(int i) {
        return this.keys[i];
    }

    @Override
    public int keyCount() {
        return this.keys == null ? 0 : this.keys.length;
    }

    @Override
    public boolean equalKeys(SwitchNode switchNode) {
        if (!(switchNode instanceof IntegerSwitchNode)) {
            return false;
        }
        IntegerSwitchNode other = (IntegerSwitchNode)switchNode;
        return Arrays.equals(this.keys, other.keys);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.emitSwitch(this);
    }

    public AbstractBeginNode successorAtKey(int key) {
        return this.blockSuccessor(this.successorIndexAtKey(key));
    }

    public int successorIndexAtKey(int key) {
        if (this.areKeysContiguous && this.keys[0] <= key && key <= this.keys[this.keys.length - 1]) {
            return this.keySuccessorIndex(key - this.keys[0]);
        }
        int index = Arrays.binarySearch(this.keys, key);
        if (index >= 0) {
            return this.keySuccessorIndex(index);
        }
        return this.keySuccessorIndex(this.keyCount());
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.shouldInjectBranchProbabilities()) {
            this.injectBranchProbabilities();
        }
        NodeView view = NodeView.from(tool);
        if (this.blockSuccessorCount() == 1) {
            tool.addToWorkList(this.defaultSuccessor());
            this.graph().removeSplitPropagate(this, this.defaultSuccessor());
        } else if (this.value() instanceof ConstantNode) {
            this.killOtherSuccessors(tool, this.successorIndexAtKey(this.value().asJavaConstant().asInt()));
        } else {
            if (this.tryOptimizeEnumSwitch(tool)) {
                return;
            }
            if (this.tryRemoveUnreachableKeys(tool, this.value().stamp(view))) {
                return;
            }
            if (this.switchTransformationOptimization(tool)) {
                return;
            }
            if (this.tryMergeCommonSuccessors()) {
                return;
            }
        }
    }

    private void addSuccessorForDeletion(AbstractBeginNode defaultNode) {
        this.successors.add((Object)defaultNode);
    }

    @Override
    public Node getNextSwitchFoldableBranch() {
        return this.defaultSuccessor();
    }

    @Override
    public boolean isInSwitch(ValueNode switchValue) {
        return this.value == switchValue;
    }

    @Override
    public void cutOffCascadeNode() {
        AbstractBeginNode toKill = this.defaultSuccessor();
        this.clearSuccessors();
        this.addSuccessorForDeletion(toKill);
    }

    @Override
    public void cutOffLowestCascadeNode() {
        this.clearSuccessors();
    }

    @Override
    public AbstractBeginNode getDefault() {
        return this.defaultSuccessor();
    }

    @Override
    public ValueNode switchValue() {
        return this.value();
    }

    @Override
    public boolean isNonInitializedProfile() {
        return !ProfileData.ProfileSource.isTrusted(this.profileData.getProfileSource());
    }

    @Override
    public ProfileData.ProfileSource profileSource() {
        return this.profileData.getProfileSource();
    }

    public boolean tryMergeCommonSuccessors() {
        MergeCoalesceBuilder builder = new MergeCoalesceBuilder(this);
        for (int i = 0; i < this.keyCount(); ++i) {
            builder.tryMergeBranch(this.keySuccessor(i), i);
        }
        builder.tryMergeDefault(this.defaultSuccessor());
        if (!builder.canRewire()) {
            return false;
        }
        builder.prepareMerge();
        if (!builder.canRewire()) {
            return false;
        }
        builder.commit();
        return true;
    }

    public boolean tryRemoveUnreachableKeys(SimplifierTool tool, Stamp valueStamp) {
        if (!(valueStamp instanceof IntegerStamp)) {
            return false;
        }
        IntegerStamp integerStamp = (IntegerStamp)valueStamp;
        if (integerStamp.isUnrestricted()) {
            return false;
        }
        ArrayList<KeyData> newKeyDatas = new ArrayList<KeyData>(this.keys.length);
        ArrayList<AbstractBeginNode> newSuccessors = new ArrayList<AbstractBeginNode>(this.blockSuccessorCount());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!integerStamp.contains(this.keys[i]) || this.keySuccessor(i) == this.defaultSuccessor()) continue;
            newKeyDatas.add(new KeyData(this.keys[i], this.getKeyProbabilities()[i], IntegerSwitchNode.addNewSuccessor(this.keySuccessor(i), newSuccessors)));
        }
        if (newKeyDatas.size() == this.keys.length) {
            return false;
        }
        if (newKeyDatas.size() == 0) {
            if (tool != null) {
                tool.addToWorkList(this.defaultSuccessor());
            }
            this.graph().removeSplitPropagate(this, this.defaultSuccessor());
            return true;
        }
        int newDefaultSuccessor = IntegerSwitchNode.addNewSuccessor(this.defaultSuccessor(), newSuccessors);
        double newDefaultProbability = this.getKeyProbabilities()[this.getKeyProbabilities().length - 1];
        this.doReplace(this.value(), newKeyDatas, newSuccessors, newDefaultSuccessor, newDefaultProbability);
        return true;
    }

    private boolean tryOptimizeEnumSwitch(SimplifierTool tool) {
        if (!(this.value() instanceof LoadIndexedNode)) {
            return false;
        }
        LoadIndexedNode loadIndexed = (LoadIndexedNode)this.value();
        if (loadIndexed.hasMoreThanOneUsage()) {
            return false;
        }
        assert (loadIndexed.usages().first() == this);
        ValueNode newValue = loadIndexed.index();
        JavaConstant arrayConstant = loadIndexed.array().asJavaConstant();
        if (arrayConstant == null || ((ConstantNode)loadIndexed.array()).getStableDimension() != 1 || !((ConstantNode)loadIndexed.array()).isDefaultStable()) {
            return false;
        }
        Integer optionalArrayLength = tool.getConstantReflection().readArrayLength(arrayConstant);
        if (optionalArrayLength == null) {
            return false;
        }
        int arrayLength = optionalArrayLength;
        HashMap<Integer, List> reverseArrayMapping = new HashMap<Integer, List>();
        for (int i = 0; i < arrayLength; ++i) {
            JavaConstant elementConstant = tool.getConstantReflection().readArrayElement(arrayConstant, i);
            if (elementConstant == null || elementConstant.getJavaKind() != JavaKind.Int) {
                return false;
            }
            int element = elementConstant.asInt();
            reverseArrayMapping.computeIfAbsent(element, e -> new ArrayList()).add(i);
        }
        ArrayList<KeyData> newKeyDatas = new ArrayList<KeyData>(arrayLength);
        ArrayList<AbstractBeginNode> newSuccessors = new ArrayList<AbstractBeginNode>(this.blockSuccessorCount());
        for (int i = 0; i < this.keys.length; ++i) {
            List newKeys = (List)reverseArrayMapping.get(this.keys[i]);
            if (newKeys == null || newKeys.size() == 0) continue;
            double newKeyProbability = this.getKeyProbabilities()[i] / (double)newKeys.size();
            int newKeySuccessor = IntegerSwitchNode.addNewSuccessor(this.keySuccessor(i), newSuccessors);
            Iterator iterator = newKeys.iterator();
            while (iterator.hasNext()) {
                int newKey = (Integer)iterator.next();
                newKeyDatas.add(new KeyData(newKey, newKeyProbability, newKeySuccessor));
            }
        }
        int newDefaultSuccessor = IntegerSwitchNode.addNewSuccessor(this.defaultSuccessor(), newSuccessors);
        double newDefaultProbability = this.getKeyProbabilities()[this.getKeyProbabilities().length - 1];
        if (loadIndexed.getBoundsCheck() == null) {
            LogicNode boundsCheck = this.graph().unique(new IntegerBelowNode(newValue, ConstantNode.forInt(arrayLength, this.graph())));
            this.graph().addBeforeFixed(this, this.graph().add(new FixedGuardNode(boundsCheck, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateReprofile)));
        }
        this.doReplace(newValue, newKeyDatas, newSuccessors, newDefaultSuccessor, newDefaultProbability);
        assert (loadIndexed.hasNoUsages());
        GraphUtil.removeFixedWithUnusedInputs(loadIndexed);
        return true;
    }

    private static int addNewSuccessor(AbstractBeginNode newSuccessor, ArrayList<AbstractBeginNode> newSuccessors) {
        int index = newSuccessors.indexOf(newSuccessor);
        if (index == -1) {
            index = newSuccessors.size();
            newSuccessors.add(newSuccessor);
        }
        return index;
    }

    private void doReplace(ValueNode newValue, List<KeyData> newKeyDatas, ArrayList<AbstractBeginNode> newSuccessors, int newDefaultSuccessor, double newDefaultProbability) {
        int i;
        newKeyDatas.sort(Comparator.comparingInt(k -> k.key));
        int newKeyCount = newKeyDatas.size();
        int[] newKeys = new int[newKeyCount];
        double[] newKeyProbabilities = new double[newKeyCount + 1];
        int[] newKeySuccessors = new int[newKeyCount + 1];
        for (int i2 = 0; i2 < newKeyCount; ++i2) {
            KeyData keyData = newKeyDatas.get(i2);
            newKeys[i2] = keyData.key;
            newKeyProbabilities[i2] = keyData.keyProbability;
            newKeySuccessors[i2] = keyData.keySuccessor;
        }
        newKeySuccessors[newKeyCount] = newDefaultSuccessor;
        newKeyProbabilities[newKeyCount] = newDefaultProbability;
        double totalProbability = 0.0;
        for (double probability : newKeyProbabilities) {
            totalProbability += probability;
        }
        if (totalProbability > 0.0) {
            i = 0;
            while (i < newKeyProbabilities.length) {
                int n = i++;
                newKeyProbabilities[n] = newKeyProbabilities[n] / totalProbability;
            }
        } else {
            for (i = 0; i < newKeyProbabilities.length; ++i) {
                newKeyProbabilities[i] = 1.0 / (double)newKeyProbabilities.length;
            }
        }
        for (i = 0; i < this.successors.size(); ++i) {
            if (!newSuccessors.contains(this.successors.get(i))) continue;
            this.successors.set(i, (Object)null);
        }
        AbstractBeginNode[] successorsArray = newSuccessors.toArray(new AbstractBeginNode[newSuccessors.size()]);
        SwitchNode newSwitch = this.graph().add(new IntegerSwitchNode(newValue, successorsArray, newKeys, newKeySuccessors, this.profileData.copy(newKeyProbabilities)));
        ((FixedWithNextNode)this.predecessor()).setNext(newSwitch);
        GraphUtil.killCFG(this);
    }

    @Override
    public Stamp getValueStampForSuccessor(AbstractBeginNode beginNode) {
        Stamp result = null;
        if (beginNode != this.defaultSuccessor()) {
            for (int i = 0; i < this.keyCount(); ++i) {
                if (this.keySuccessor(i) != beginNode) continue;
                result = result == null ? StampFactory.forConstant(this.keyAt(i)) : result.meet(StampFactory.forConstant(this.keyAt(i)));
            }
        }
        return result;
    }

    private static final class MergeCoalesceBuilder {
        private final List<KeyData> newKeyData = new ArrayList<KeyData>();
        private final ArrayList<AbstractBeginNode> newSuccessors = new ArrayList();
        private final EconomicMap<AbstractMergeNode, MergeMarker> mergeKeys = EconomicMap.create();
        private final IntegerSwitchNode switchNode;
        private int newDefaultSuccessor = -1;
        private double newDefaultProbability;
        private boolean canRewire;

        MergeCoalesceBuilder(IntegerSwitchNode switchNode) {
            this.switchNode = switchNode;
        }

        boolean canRewire() {
            return this.canRewire;
        }

        void tryMergeBranch(AbstractBeginNode begin, int i) {
            this.tryMergeCommon(begin, false, i);
        }

        void tryMergeDefault(AbstractBeginNode begin) {
            this.tryMergeCommon(begin, true, -1);
        }

        private void tryMergeCommon(AbstractBeginNode begin, boolean isDefault, int i) {
            EndNode endNode;
            AbstractMergeNode merge;
            FixedNode next;
            if (begin instanceof BeginNode && begin.hasNoUsages() && (next = begin.next()) instanceof EndNode && (merge = (endNode = (EndNode)next).merge()) instanceof MergeNode && merge.phis().isEmpty()) {
                if (this.mergeKeys.containsKey((Object)merge)) {
                    ((MergeMarker)this.mergeKeys.get((Object)merge)).update(i, endNode);
                    this.canRewire = true;
                } else {
                    MergeMarker indexes = new MergeMarker();
                    indexes.update(i, endNode);
                    this.mergeKeys.put((Object)merge, (Object)indexes);
                }
                return;
            }
            if (!isDefault) {
                assert (i >= 0 && i < this.switchNode.keyCount());
                this.addKeyData(IntegerSwitchNode.addNewSuccessor(begin, this.newSuccessors), i);
            }
        }

        void prepareMerge() {
            this.canRewire = false;
            MapCursor cursor = this.mergeKeys.getEntries();
            this.newDefaultProbability = this.switchNode.defaultProbability();
            while (cursor.advance()) {
                AbstractMergeNode merge = (AbstractMergeNode)cursor.getKey();
                MergeMarker marker = (MergeMarker)cursor.getValue();
                if (marker.visitedEnds() > 1) {
                    AbstractBeginNode begin;
                    boolean partialCoalesce;
                    this.canRewire = true;
                    boolean bl = partialCoalesce = merge.forwardEndCount() != marker.visitedEnds();
                    if (partialCoalesce) {
                        for (EndNode end : marker.ends()) {
                            merge.removeEnd(end);
                        }
                        EndNode newEnd = this.switchNode.graph().add(new EndNode());
                        merge.addForwardEnd(newEnd);
                        begin = BeginNode.begin(newEnd);
                    } else {
                        FixedNode next = merge.next();
                        merge.setNext(null);
                        begin = BeginNode.begin(next);
                        merge.replaceAtUsages((Node)begin, InputType.Anchor);
                        merge.replaceAtUsages((Node)begin, InputType.Guard);
                        assert (merge.hasNoUsages());
                    }
                    int successorIndex = IntegerSwitchNode.addNewSuccessor(begin, this.newSuccessors);
                    if (marker.hasDefault()) {
                        assert (this.newDefaultSuccessor == -1) : "Multiple default keys ?";
                        this.newDefaultSuccessor = successorIndex;
                        for (int index : marker) {
                            if (index == -1) continue;
                            this.newDefaultProbability += this.switchNode.keyProbability(index);
                        }
                        continue;
                    }
                    for (int index : marker) {
                        AbstractBeginNode successorBegin = this.switchNode.keySuccessor(index);
                        assert (successorBegin.next() instanceof EndNode);
                        this.addKeyData(successorIndex, index);
                    }
                    continue;
                }
                for (int i : marker) {
                    if (i == -1) continue;
                    this.addKeyData(IntegerSwitchNode.addNewSuccessor(this.switchNode.keySuccessor(i), this.newSuccessors), i);
                }
            }
            if (this.newDefaultSuccessor == -1) {
                this.newDefaultSuccessor = IntegerSwitchNode.addNewSuccessor(this.switchNode.defaultSuccessor(), this.newSuccessors);
            }
        }

        private boolean addKeyData(int successorIndex, int index) {
            return this.newKeyData.add(new KeyData(this.switchNode.intKeyAt(index), this.switchNode.keyProbability(index), successorIndex));
        }

        public void commit() {
            this.switchNode.doReplace(this.switchNode.value(), this.newKeyData, this.newSuccessors, this.newDefaultSuccessor, this.newDefaultProbability);
        }

        private static final class MergeMarker
        implements Iterable<Integer> {
            private final ArrayList<Integer> indexes = new ArrayList();
            private final EconomicSet<EndNode> ends = EconomicSet.create();
            private boolean hasDefault = false;
            private static final int DEFAULT_KEY = -1;

            private MergeMarker() {
            }

            void update(int index, EndNode end) {
                if (index == -1) {
                    this.hasDefault = true;
                }
                this.indexes.add(index);
                this.ends.add((Object)end);
            }

            int visitedEnds() {
                return this.ends.size();
            }

            boolean hasDefault() {
                return this.hasDefault;
            }

            Iterable<EndNode> ends() {
                return this.ends;
            }

            @Override
            public Iterator<Integer> iterator() {
                return this.indexes.iterator();
            }
        }
    }

    static final class KeyData {
        final int key;
        final double keyProbability;
        final int keySuccessor;

        KeyData(int key, double keyProbability, int keySuccessor) {
            this.key = key;
            this.keyProbability = keyProbability;
            this.keySuccessor = keySuccessor;
        }
    }
}

