/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import java.util.Map;
import jdk.vm.ci.code.MemoryBarriers;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Membar#{p#location/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class MembarNode
extends FixedWithNextNode
implements LIRLowerable,
SingleMemoryKill {
    public static final NodeClass<MembarNode> TYPE = NodeClass.create(MembarNode.class);
    protected final FenceKind fence;
    protected final LocationIdentity location;

    public MembarNode(FenceKind fence) {
        this(fence, LocationIdentity.any());
    }

    public MembarNode(FenceKind fence, LocationIdentity location) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.fence = fence;
        this.location = location;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.location;
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        map.put("barriersString", MemoryBarriers.barriersString((int)this.fence.barriers));
        return super.getDebugProperties(map);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.getLIRGeneratorTool().emitMembar(this.fence.barriers);
    }

    @Node.NodeIntrinsic
    public static native void memoryBarrier(@Node.ConstantNodeParameter FenceKind var0);

    @Node.NodeIntrinsic
    public static native void memoryBarrier(@Node.ConstantNodeParameter FenceKind var0, @Node.ConstantNodeParameter LocationIdentity var1);

    public static enum FenceKind {
        NONE(0),
        STORE_LOAD(4),
        STORE_STORE(8),
        LOAD_ACQUIRE(3),
        STORE_RELEASE(10),
        ALLOCATION_INIT(8),
        CONSTRUCTOR_FREEZE(8),
        FULL(15);

        private final int barriers;

        private FenceKind(int barriers) {
            this.barriers = barriers;
        }
    }
}

