/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, cyclesRationale="Artificial Node", size=NodeSize.SIZE_0)
public final class SwitchCaseProbabilityNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<SwitchCaseProbabilityNode> TYPE = NodeClass.create(SwitchCaseProbabilityNode.class);
    @Node.Input
    ValueNode probability;

    public SwitchCaseProbabilityNode(ValueNode probability) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Void));
        this.probability = probability;
    }

    public ValueNode getProbability() {
        return this.probability;
    }

    public void setProbability(ValueNode probability) {
        this.updateUsages(this.probability, probability);
        this.probability = probability;
    }

    @Override
    public void lower(LoweringTool tool) {
        throw new GraalError("Switch case probability could not be injected, because the probability value did not reduce to a constant value.");
    }
}

