/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.gc;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.ObjectWriteBarrier;
import org.graalvm.compiler.nodes.gc.WriteBarrier;
import org.graalvm.compiler.nodes.memory.address.AddressNode;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class G1PreWriteBarrier
extends ObjectWriteBarrier
implements DeoptimizingNode.DeoptBefore {
    public static final NodeClass<G1PreWriteBarrier> TYPE = NodeClass.create(G1PreWriteBarrier.class);
    @Node.OptionalInput(value=InputType.State)
    private FrameState stateBefore;
    private final boolean nullCheck;
    private final boolean doLoad;

    public G1PreWriteBarrier(AddressNode address, ValueNode expectedObject, boolean doLoad, boolean nullCheck) {
        super(TYPE, address, expectedObject, true);
        assert (doLoad == (expectedObject == null));
        this.doLoad = doLoad;
        this.nullCheck = nullCheck;
    }

    public ValueNode getExpectedObject() {
        return this.getValue();
    }

    public boolean doLoad() {
        return this.doLoad;
    }

    public boolean getNullCheck() {
        return this.nullCheck;
    }

    @Override
    public boolean canDeoptimize() {
        return this.nullCheck;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState state) {
        this.updateUsages(this.stateBefore, state);
        this.stateBefore = state;
    }

    @Override
    public WriteBarrier.Kind getKind() {
        return WriteBarrier.Kind.PRE_BARRIER;
    }
}

