/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.ValidateNewInstanceClassNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.CoreProviders;

@NodeInfo
public final class DynamicNewInstanceNode
extends AbstractNewObjectNode
implements Canonicalizable {
    public static final NodeClass<DynamicNewInstanceNode> TYPE = NodeClass.create(DynamicNewInstanceNode.class);
    @Node.Input
    ValueNode clazz;

    public static void createAndPush(GraphBuilderContext b, ValueNode clazz) {
        ResolvedJavaType constantType = DynamicNewInstanceNode.tryConvertToNonDynamic(clazz, b);
        if (constantType != null) {
            b.addPush(JavaKind.Object, new NewInstanceNode(constantType, true));
        } else {
            ValueNode clazzLegal = b.add(new ValidateNewInstanceClassNode(clazz));
            b.addPush(JavaKind.Object, new DynamicNewInstanceNode(clazzLegal, true));
        }
    }

    protected DynamicNewInstanceNode(ValueNode clazz, boolean fillContents) {
        super(TYPE, StampFactory.objectNonNull(), fillContents, null);
        this.clazz = clazz;
        assert (((ObjectStamp)clazz.stamp(NodeView.DEFAULT)).nonNull());
    }

    public ValueNode getInstanceType() {
        return this.clazz;
    }

    static ResolvedJavaType tryConvertToNonDynamic(ValueNode clazz, CoreProviders tool) {
        ResolvedJavaType type;
        if (clazz.isConstant() && (type = tool.getConstantReflection().asJavaType(clazz.asConstant())) != null && !DynamicNewInstanceNode.throwsInstantiationException(type, tool.getMetaAccess()) && tool.getMetaAccessExtensionProvider().canConstantFoldDynamicAllocation(type)) {
            return type;
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType type = DynamicNewInstanceNode.tryConvertToNonDynamic(this.clazz, tool);
        if (type != null) {
            return new NewInstanceNode(type, this.fillContents(), this.stateBefore());
        }
        return this;
    }

    public static boolean throwsInstantiationExceptionInjectedProbability(double probability, Class<?> type, Class<?> classClass) {
        return BranchProbabilityNode.probability(probability, type.isPrimitive()) || BranchProbabilityNode.probability(probability, type.isArray()) || BranchProbabilityNode.probability(probability, type.isInterface()) || BranchProbabilityNode.probability(probability, Modifier.isAbstract(type.getModifiers())) || BranchProbabilityNode.probability(probability, type == classClass);
    }

    public static boolean throwsInstantiationException(ResolvedJavaType type, MetaAccessProvider metaAccess) {
        return type.isPrimitive() || type.isArray() || type.isInterface() || Modifier.isAbstract(type.getModifiers()) || type.equals(metaAccess.lookupJavaType(Class.class));
    }
}

