/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;

public interface LoopPolicies {
    public boolean shouldPeel(LoopEx var1, ControlFlowGraph var2, CoreProviders var3, int var4);

    public boolean shouldFullUnroll(LoopEx var1);

    public boolean shouldPartiallyUnroll(LoopEx var1, CoreProviders var2);

    public boolean shouldTryUnswitch(LoopEx var1);

    public UnswitchingDecision shouldUnswitch(LoopEx var1, EconomicMap<ValueNode, List<ControlSplitNode>> var2);

    public static final class UnswitchingDecision {
        public static final UnswitchingDecision NO = new UnswitchingDecision(null, false);
        private final List<ControlSplitNode> controlSplits;
        private final boolean isTrivial;

        public static UnswitchingDecision trivial(List<ControlSplitNode> controlSplits) {
            return new UnswitchingDecision(controlSplits, true);
        }

        public static UnswitchingDecision yes(List<ControlSplitNode> controlSplits) {
            assert (controlSplits != null);
            return new UnswitchingDecision(controlSplits, false);
        }

        private UnswitchingDecision(List<ControlSplitNode> controlSplits, boolean isTrivial) {
            assert (!isTrivial || controlSplits != null) : "An unswitching desision cannot be trivial but have not control split node";
            this.controlSplits = controlSplits;
            this.isTrivial = isTrivial;
        }

        public boolean shouldUnswitch() {
            return this.controlSplits != null;
        }

        public boolean isTrivial() {
            return this.isTrivial;
        }

        public List<ControlSplitNode> getControlSplits() {
            return this.controlSplits;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> PeelALot = new OptionKey<Boolean>(false);
        public static final OptionKey<Integer> PeelOnlyLoopWithNodeID = new OptionKey<Integer>(-1);
    }
}

