/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.spi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.ProfileProvider;

public class StableProfileProvider
implements ProfileProvider {
    private static final JavaTypeProfile NULL_PROFILE = new JavaTypeProfile(TriState.UNKNOWN, 1.0, new JavaTypeProfile.ProfiledType[0]);
    private static final double[] NULL_SWITCH_PROBABILITIES = new double[0];
    public static final String METHOD_FORMAT = "%H.%n(%P)%R";
    private final EconomicMap<ProfileKey, CachingProfilingInfo> profiles = EconomicMap.create();
    private EconomicMap<String, CachingProfilingInfo> loaded;
    private boolean frozen;
    private boolean warnNonCachedLoadAccess;
    private LambdaNameFormatter loadingLambdaNameFormatter;

    @Override
    public ProfilingInfo getProfilingInfo(ResolvedJavaMethod method) {
        return this.getProfilingInfo(method, true, true);
    }

    @Override
    public ProfilingInfo getProfilingInfo(ResolvedJavaMethod method, boolean includeNormal, boolean includeOSR) {
        ProfileKey key = new ProfileKey(method, includeNormal, includeOSR);
        CachingProfilingInfo profile = (CachingProfilingInfo)this.profiles.get((Object)key);
        if (profile == null && this.loaded != null) {
            profile = (CachingProfilingInfo)this.loaded.get((Object)method.format(METHOD_FORMAT));
            if (profile != null) {
                profile.materialize(method);
            } else if (this.loadingLambdaNameFormatter != null && (profile = (CachingProfilingInfo)this.loaded.get((Object)this.loadingLambdaNameFormatter.formatLamdaName(method))) != null) {
                profile.materialize(method);
            }
        }
        if (profile == null) {
            if (this.frozen) {
                throw new InternalError("frozen - cannot get method " + method.format(METHOD_FORMAT));
            }
            if (this.loaded != null && this.warnNonCachedLoadAccess) {
                TTY.printf("Requesting not cached profile for %s%n", method.format(METHOD_FORMAT));
            }
            profile = new CachingProfilingInfo(method, includeNormal, includeOSR);
            this.profiles.put((Object)key, (Object)profile);
        }
        return profile;
    }

    public StableProfileProvider load(Object parser, ResolvedJavaType loadingIssuingType, boolean warnNonCachedLoadAccess1, LambdaNameFormatter lambdaFormatter) {
        EconomicMap map = (EconomicMap)parser;
        this.loaded = EconomicMap.create();
        List methods = (List)map.get((Object)"profiles");
        for (Object m : methods) {
            EconomicMap methodMap = (EconomicMap)m;
            String signature = (String)methodMap.get((Object)"method");
            CachingProfilingInfo info = new CachingProfilingInfo((EconomicMap<String, Object>)methodMap);
            info.loadingIssuingType = loadingIssuingType;
            this.loaded.put((Object)signature, (Object)info);
            if (!methodMap.containsKey((Object)"stableLambdaName")) continue;
            String signatureStableLambda = (String)methodMap.get((Object)"stableLambdaName");
            this.loaded.put((Object)signatureStableLambda, (Object)info);
        }
        this.loadingLambdaNameFormatter = lambdaFormatter;
        this.warnNonCachedLoadAccess = warnNonCachedLoadAccess1;
        return this;
    }

    public void freeze() {
        this.frozen = true;
    }

    private static TriState parseTriState(String exceptionSeen) {
        if (exceptionSeen == null) {
            return null;
        }
        return TriState.valueOf((String)exceptionSeen);
    }

    public EconomicMap<String, Object> recordProfiles(EconomicMap<String, Object> map, TypeFilter typeFilter, LambdaNameFormatter lambdaFormatter) {
        ArrayList<EconomicMap<String, Object>> methods = new ArrayList<EconomicMap<String, Object>>();
        map.put((Object)"profiles", methods);
        if (this.loaded != null) {
            MapCursor entries = this.loaded.getEntries();
            while (entries.advance()) {
                ResolvedJavaMethod method = ((CachingProfilingInfo)entries.getValue()).method;
                ResolvedJavaType declaringType = method.getDeclaringClass();
                if (typeFilter != null && (lambdaFormatter == null || !lambdaFormatter.isLambda(method)) && !typeFilter.includeType(declaringType)) continue;
                methods.add(((CachingProfilingInfo)entries.getValue()).asMap(entries.getKey(), typeFilter, lambdaFormatter));
            }
        } else {
            MapCursor entries = this.profiles.getEntries();
            while (entries.advance()) {
                ResolvedJavaMethod method = ((ProfileKey)entries.getKey()).method;
                ResolvedJavaType declaringType = method.getDeclaringClass();
                if (typeFilter != null && (lambdaFormatter == null || !lambdaFormatter.isLambda(method)) && !typeFilter.includeType(declaringType)) continue;
                methods.add(((CachingProfilingInfo)entries.getValue()).asMap(entries.getKey(), typeFilter, lambdaFormatter));
            }
        }
        return map;
    }

    static class ProfileKey {
        final ResolvedJavaMethod method;
        final boolean includeNormal;
        final boolean includeOSR;

        ProfileKey(ResolvedJavaMethod method, boolean includeNormal, boolean includeOSR) {
            this.method = method;
            this.includeNormal = includeNormal;
            this.includeOSR = includeOSR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfileKey that = (ProfileKey)o;
            return this.includeNormal == that.includeNormal && this.includeOSR == that.includeOSR && this.method.equals(that.method);
        }

        public int hashCode() {
            return this.method.hashCode() + (this.includeNormal ? 1 : 0) + (this.includeOSR ? 2 : 0);
        }
    }

    public class CachingProfilingInfo
    implements ProfilingInfo {
        private ResolvedJavaMethod method;
        private ProfilingInfo realProfile;
        private Boolean isMature;
        private Integer compilerIRSize;
        private final EconomicMap<Integer, BytecodeProfile> bytecodeProfiles;
        private ResolvedJavaType loadingIssuingType;
        private boolean materialized;

        CachingProfilingInfo(ResolvedJavaMethod method, boolean includeNormal, boolean includeOSR) {
            this.method = method;
            this.realProfile = method.getProfilingInfo(includeNormal, includeOSR);
            this.bytecodeProfiles = EconomicMap.create();
        }

        CachingProfilingInfo(EconomicMap<String, Object> map) {
            this.isMature = (Boolean)map.get((Object)"isMature");
            this.compilerIRSize = (Integer)map.get((Object)"compilerIRSize");
            this.bytecodeProfiles = EconomicMap.create();
            List data = (List)map.get((Object)"data");
            if (data != null) {
                for (Object d : data) {
                    BytecodeProfile b = new BytecodeProfile((EconomicMap<String, Object>)((EconomicMap)d));
                    this.bytecodeProfiles.put((Object)b.bci, (Object)b);
                }
            }
        }

        private void checkFrozen(int bci, String caller) {
            if (StableProfileProvider.this.frozen) {
                throw new InternalError("Profile is frozen and profiling information was requested for " + this.method + "@" + bci);
            }
            if (StableProfileProvider.this.loaded != null && StableProfileProvider.this.warnNonCachedLoadAccess) {
                TTY.printf("Requesting uncached profile for bci %d in %s method %s%n", bci, this.method.format(StableProfileProvider.METHOD_FORMAT), caller);
            }
        }

        public int getCodeSize() {
            return this.realProfile.getCodeSize();
        }

        public double getBranchTakenProbability(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.branchTakenProbability == null) {
                this.checkFrozen(bci, "getBranchTakenProbability");
                cached.branchTakenProbability = this.realProfile.getBranchTakenProbability(bci);
            }
            return cached.branchTakenProbability;
        }

        public double[] getSwitchProbabilities(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.switchProbabilities == null) {
                this.checkFrozen(bci, "getSwitchProbabilities");
                cached.switchProbabilities = this.realProfile.getSwitchProbabilities(bci);
                if (cached.switchProbabilities == null) {
                    cached.switchProbabilities = NULL_SWITCH_PROBABILITIES;
                }
            }
            double[] ret = cached.switchProbabilities == NULL_SWITCH_PROBABILITIES ? null : cached.switchProbabilities;
            return ret;
        }

        public JavaTypeProfile getTypeProfile(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.symbolicTypeProfile != null) {
                cached.materializeProfile();
            }
            if (cached.typeProfile == null) {
                this.checkFrozen(bci, "getTypeProfile");
                cached.typeProfile = this.realProfile.getTypeProfile(bci);
                if (cached.typeProfile == null) {
                    cached.typeProfile = NULL_PROFILE;
                }
            }
            JavaTypeProfile ret = cached.typeProfile == NULL_PROFILE ? null : cached.typeProfile;
            GraalError.guarantee(ret != NULL_PROFILE, "Must never return null profile");
            return ret;
        }

        public JavaMethodProfile getMethodProfile(int bci) {
            return null;
        }

        public TriState getExceptionSeen(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.exceptionSeen == null) {
                this.checkFrozen(bci, "getExceptionSeen");
                cached.exceptionSeen = this.realProfile.getExceptionSeen(bci);
            }
            return cached.exceptionSeen;
        }

        private BytecodeProfile getBytecodeProfile(int bci) {
            BytecodeProfile cached = (BytecodeProfile)this.bytecodeProfiles.get((Object)bci);
            if (cached == null) {
                this.checkFrozen(bci, "getBytecodeProfile");
                cached = new BytecodeProfile(bci);
                this.bytecodeProfiles.put((Object)bci, (Object)cached);
            }
            return cached;
        }

        public TriState getNullSeen(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.nullSeen == null) {
                this.checkFrozen(bci, "getNullSeen");
                cached.nullSeen = this.realProfile.getNullSeen(bci);
            }
            return cached.nullSeen;
        }

        public int getExecutionCount(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.executionCount == null) {
                this.checkFrozen(bci, "getExceutionCount");
                cached.executionCount = this.realProfile.getExecutionCount(bci);
            }
            return cached.executionCount;
        }

        public int getDeoptimizationCount(DeoptimizationReason reason) {
            return this.realProfile.getDeoptimizationCount(reason);
        }

        public boolean setCompilerIRSize(Class<?> irType, int irSize) {
            return this.realProfile.setCompilerIRSize(irType, irSize);
        }

        public int getCompilerIRSize(Class<?> irType) {
            assert (irType == StructuredGraph.class);
            if (this.compilerIRSize == null) {
                if (StableProfileProvider.this.frozen) {
                    throw new InternalError("Profile is frozen and profiling information was requested for " + this.method);
                }
                this.compilerIRSize = this.realProfile.getCompilerIRSize(irType);
            }
            return this.compilerIRSize;
        }

        public boolean isMature() {
            if (this.isMature == null) {
                if (StableProfileProvider.this.frozen) {
                    throw new InternalError("Profile is frozen and profiling information was requested for " + this.method);
                }
                this.isMature = this.realProfile.isMature();
            }
            return this.isMature;
        }

        public void setMature() {
            throw new UnsupportedOperationException();
        }

        private EconomicMap<String, Object> asMap(Object signature, TypeFilter filter, LambdaNameFormatter lambdaFormatter) {
            EconomicMap profileRecord = EconomicMap.create();
            if (signature instanceof String) {
                profileRecord.put((Object)"method", signature);
            } else {
                ProfileKey key = (ProfileKey)signature;
                ResolvedJavaMethod m = key.method;
                if (lambdaFormatter.isLambda(m)) {
                    profileRecord.put((Object)"stableLambdaName", (Object)lambdaFormatter.formatLamdaName(m));
                }
                profileRecord.put((Object)"method", (Object)m.format(StableProfileProvider.METHOD_FORMAT));
            }
            profileRecord.put((Object)"isMature", (Object)(this.isMature == null ? false : this.isMature));
            profileRecord.put((Object)"compilerIRSize", (Object)(this.compilerIRSize == null ? -1 : this.compilerIRSize));
            ArrayList<EconomicMap> bciData = new ArrayList<EconomicMap>();
            for (BytecodeProfile data : this.bytecodeProfiles.getValues()) {
                EconomicMap v = EconomicMap.create();
                v.put((Object)"bci", (Object)data.bci);
                if (data.exceptionSeen != null) {
                    v.put((Object)"exceptionSeen", (Object)data.exceptionSeen);
                }
                if (data.nullSeen != null) {
                    v.put((Object)"nullSeen", (Object)data.nullSeen);
                }
                if (data.executionCount != null) {
                    v.put((Object)"executionCount", (Object)data.executionCount);
                }
                if (data.switchProbabilities != null) {
                    ArrayList<Double> s = new ArrayList<Double>();
                    for (double p : data.switchProbabilities) {
                        s.add(p);
                    }
                    v.put((Object)"switchProbabilities", s);
                }
                if (data.branchTakenProbability != null) {
                    v.put((Object)"branchTakenProbability", (Object)data.branchTakenProbability);
                }
                if (data.symbolicTypeProfile != null) {
                    v.put((Object)"typeProfile", data.symbolicTypeProfile);
                }
                if (data.typeProfile != null) {
                    EconomicMap typeProfile = EconomicMap.create();
                    typeProfile.put((Object)"nullSeen", (Object)data.typeProfile.getNullSeen());
                    ArrayList<EconomicMap> types = new ArrayList<EconomicMap>();
                    typeProfile.put((Object)"types", types);
                    double effectiveNotRecorded = data.typeProfile.getNotRecordedProbability();
                    for (JavaTypeProfile.ProfiledType ptype : data.typeProfile.getTypes()) {
                        if (filter == null || lambdaFormatter.isLambda(this.method) || filter.includeType(ptype.getType())) {
                            EconomicMap ptypeMap = EconomicMap.create();
                            ptypeMap.put((Object)"type", (Object)ptype.getType().getName());
                            ptypeMap.put((Object)"probability", (Object)ptype.getProbability());
                            types.add(ptypeMap);
                            continue;
                        }
                        effectiveNotRecorded += ptype.getProbability();
                    }
                    typeProfile.put((Object)"notRecordedProbability", (Object)effectiveNotRecorded);
                    v.put((Object)"typeProfile", (Object)typeProfile);
                }
                bciData.add(v);
            }
            bciData.sort(Comparator.comparingInt(a -> (Integer)a.get((Object)"bci")));
            profileRecord.put((Object)"data", bciData);
            return profileRecord;
        }

        public void materialize(ResolvedJavaMethod realMethod) {
            if (this.materialized) {
                return;
            }
            assert (this.method == null);
            this.method = realMethod;
            this.realProfile = realMethod.getProfilingInfo();
            for (BytecodeProfile bytecodeProfile : this.bytecodeProfiles.getValues()) {
                bytecodeProfile.materializeProfile();
            }
            this.materialized = true;
        }

        class BytecodeProfile {
            final int bci;
            TriState exceptionSeen;
            TriState nullSeen;
            Double branchTakenProbability;
            double[] switchProbabilities;
            Integer executionCount;
            JavaTypeProfile typeProfile;
            EconomicMap<String, Object> symbolicTypeProfile;

            BytecodeProfile(int bci) {
                this.bci = bci;
            }

            BytecodeProfile(EconomicMap<String, Object> bciData) {
                EconomicMap profileData;
                this.bci = (Integer)bciData.get((Object)"bci");
                this.exceptionSeen = StableProfileProvider.parseTriState((String)bciData.get((Object)"exceptionSeen"));
                this.nullSeen = StableProfileProvider.parseTriState((String)bciData.get((Object)"nullSeen"));
                this.executionCount = (Integer)bciData.get((Object)"executionCount");
                this.branchTakenProbability = (Double)bciData.get((Object)"branchTakenProbability");
                List probs = (List)bciData.get((Object)"switchProbabilities");
                if (probs != null) {
                    this.switchProbabilities = new double[probs.size()];
                    for (int i = 0; i < probs.size(); ++i) {
                        this.switchProbabilities[i] = (Double)probs.get(i);
                    }
                }
                if ((profileData = (EconomicMap)bciData.get((Object)"typeProfile")) != null) {
                    this.symbolicTypeProfile = profileData;
                }
            }

            void materializeProfile() {
                if (this.symbolicTypeProfile == null) {
                    return;
                }
                TriState theNullSeen = StableProfileProvider.parseTriState((String)this.symbolicTypeProfile.get((Object)"nullSeen"));
                double notRecordedProbabilty = (Double)this.symbolicTypeProfile.get((Object)"notRecordedProbability");
                List types = (List)this.symbolicTypeProfile.get((Object)"types");
                JavaTypeProfile.ProfiledType[] pitems = new JavaTypeProfile.ProfiledType[types.size()];
                int i = 0;
                for (Object e : types) {
                    EconomicMap entry = (EconomicMap)e;
                    String typeName = (String)entry.get((Object)"type");
                    ResolvedJavaType actualType = null;
                    double probability = (Double)entry.get((Object)"probability");
                    JavaTypeProfile actualProfile = CachingProfilingInfo.this.realProfile.getTypeProfile(this.bci);
                    if (actualProfile != null) {
                        for (JavaTypeProfile.ProfiledType actual : actualProfile.getTypes()) {
                            if (!actual.getType().getName().equals(typeName)) continue;
                            actualType = actual.getType();
                            break;
                        }
                    }
                    if (actualType == null) {
                        try {
                            actualType = UnresolvedJavaType.create((String)typeName).resolve(CachingProfilingInfo.this.method.getDeclaringClass());
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            // empty catch block
                        }
                    }
                    if (actualType == null) {
                        try {
                            actualType = UnresolvedJavaType.create((String)typeName).resolve(CachingProfilingInfo.this.loadingIssuingType);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            // empty catch block
                        }
                    }
                    if (actualType == null && actualProfile != null) {
                        for (JavaTypeProfile.ProfiledType actual : actualProfile.getTypes()) {
                            try {
                                actualType = UnresolvedJavaType.create((String)typeName).resolve(actual.getType());
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                // empty catch block
                            }
                            if (actualType != null) break;
                        }
                    }
                    if (actualType == null) {
                        if (StableProfileProvider.this.frozen) {
                            throw new InternalError("Unable to load " + typeName + " for profile");
                        }
                        TTY.println("Unable to load " + typeName + " for profile");
                    }
                    pitems[i++] = new JavaTypeProfile.ProfiledType(actualType, probability);
                }
                this.typeProfile = new JavaTypeProfile(theNullSeen, notRecordedProbabilty, pitems);
            }
        }
    }

    public static interface LambdaNameFormatter {
        public boolean isLambda(ResolvedJavaMethod var1);

        public String formatLamdaName(ResolvedJavaMethod var1);
    }

    public static interface TypeFilter {
        public boolean includeType(ResolvedJavaType var1);
    }
}

