/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.EnumSet;
import java.util.Optional;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;

public class FinalCanonicalizerPhase
extends CanonicalizerPhase {
    protected FinalCanonicalizerPhase(CanonicalizerPhase.CustomSimplification customSimplification, EnumSet<CanonicalizerPhase.CanonicalizerFeature> features) {
        super(customSimplification, features);
    }

    @Override
    protected boolean isFinalCanonicalizationPhase() {
        return true;
    }

    @Override
    public FinalCanonicalizerPhase copyWithCustomSimplification(CanonicalizerPhase.CustomSimplification newSimplification) {
        return new FinalCanonicalizerPhase(newSimplification, this.features);
    }

    @Override
    public FinalCanonicalizerPhase copyWithoutGVN() {
        EnumSet<CanonicalizerPhase.CanonicalizerFeature> newFeatures = EnumSet.copyOf(this.features);
        newFeatures.remove((Object)CanonicalizerPhase.CanonicalizerFeature.GVN);
        return new FinalCanonicalizerPhase(this.customSimplification, newFeatures);
    }

    @Override
    public FinalCanonicalizerPhase copyWithoutSimplification() {
        EnumSet<CanonicalizerPhase.CanonicalizerFeature> newFeatures = EnumSet.copyOf(this.features);
        newFeatures.remove((Object)CanonicalizerPhase.CanonicalizerFeature.CFG_SIMPLIFICATION);
        return new FinalCanonicalizerPhase(this.customSimplification, newFeatures);
    }

    public static FinalCanonicalizerPhase createFromCanonicalizer(CanonicalizerPhase canonicalizer) {
        return new FinalCanonicalizerPhase(canonicalizer.customSimplification, canonicalizer.features);
    }

    @Override
    public boolean mustApply(GraphState graphState) {
        return graphState.requiresFutureStage(GraphState.StageFlag.FINAL_CANONICALIZATION);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.LOW_TIER_LOWERING, graphState));
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.FINAL_CANONICALIZATION);
        graphState.removeRequirementToStage(GraphState.StageFlag.FINAL_CANONICALIZATION);
    }
}

