/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.Optional;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.OpaqueValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class RemoveOpaqueValuePhase
extends BasePhase<CoreProviders> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    public boolean shouldApply(StructuredGraph graph) {
        return graph.hasNode(OpaqueValueNode.TYPE);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (OpaqueValueNode opaque : graph.getNodes(OpaqueValueNode.TYPE)) {
            opaque.replaceAtUsagesAndDelete(opaque.getValue());
        }
    }
}

