/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.info;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.common.inlining.info.ExactInlineInfo;
import org.graalvm.compiler.phases.util.Providers;

public class AssumptionInlineInfo
extends ExactInlineInfo {
    private final Assumptions.AssumptionResult<?> takenAssumption;

    public AssumptionInlineInfo(Invoke invoke, ResolvedJavaMethod concrete, Assumptions.AssumptionResult<?> takenAssumption) {
        super(invoke, concrete);
        this.takenAssumption = takenAssumption;
    }

    @Override
    public EconomicSet<Node> inline(CoreProviders providers, String reason) {
        this.takenAssumption.recordTo(this.invoke.asNode().graph().getAssumptions());
        return super.inline(providers, reason);
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
        this.takenAssumption.recordTo(this.invoke.asNode().graph().getAssumptions());
        InliningUtil.replaceInvokeCallTarget(this.invoke, this.graph(), CallTargetNode.InvokeKind.Special, this.concrete);
    }

    @Override
    public String toString() {
        return "assumption " + this.concrete.format("%H.%n(%p):%r");
    }
}

