/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.util;

import java.util.EnumSet;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.loop.BasicInductionVariable;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public class LoopUtility {
    public static long addExact(int bits, long a, long b) {
        if (bits == 32) {
            int ia = (int)a;
            int ib = (int)b;
            assert ((long)ia == a && (long)ib == b) : String.format("Conversions must be lossless, [bits]=%d; [a]=%d; [b]=%d; [ia]=%d; [ib]=%d;", bits, a, b, ia, ib);
            return Math.addExact(ia, ib);
        }
        if (bits == 64) {
            return Math.addExact(a, b);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes int/long but is " + bits);
    }

    public static long subtractExact(int bits, long a, long b) {
        if (bits == 32) {
            int ia = (int)a;
            int ib = (int)b;
            assert ((long)ia == a && (long)ib == b) : String.format("Conversions must be lossless, [bits]=%d; [a]=%d; [b]=%d; [ia]=%d; [ib]=%d;", bits, a, b, ia, ib);
            return Math.subtractExact(ia, ib);
        }
        if (bits == 64) {
            return Math.subtractExact(a, b);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes int/long but is " + bits);
    }

    public static long multiplyExact(int bits, long a, long b) {
        if (bits == 32) {
            int ia = (int)a;
            int ib = (int)b;
            assert ((long)ia == a && (long)ib == b) : String.format("Conversions must be lossless, [bits]=%d; [a]=%d; [b]=%d; [ia]=%d; [ib]=%d;", bits, a, b, ia, ib);
            return Math.multiplyExact(ia, ib);
        }
        if (bits == 64) {
            return Math.multiplyExact(a, b);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes int/long but is " + bits);
    }

    public static boolean canTakeAbs(long l, int bits) {
        try {
            LoopUtility.abs(l, bits);
            return true;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public static long abs(long l, int bits) throws ArithmeticException {
        if (bits == 32) {
            if (l == Integer.MIN_VALUE) {
                throw new ArithmeticException("Abs on Integer.MIN_VALUE would cause an overflow because abs(Integer.MIN_VALUE) = Integer.MAX_VALUE + 1 which does not fit in int (32 bits)");
            }
            int i = (int)l;
            return Math.abs(i);
        }
        if (bits == 64) {
            if (l == Long.MIN_VALUE) {
                throw new ArithmeticException("Abs on Long.MIN_VALUE would cause an overflow because abs(Long.MIN_VALUE) = Long.MAX_VALUE + 1 which does not fit in long (64 bits)");
            }
            return Math.abs(l);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes int/long but is " + bits);
    }

    public static boolean canUseWithoutProxy(ControlFlowGraph cfg, Node def, Node use) {
        StructuredGraph g;
        Graph graph = def.graph();
        if (graph instanceof StructuredGraph && (g = (StructuredGraph)graph).isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            return true;
        }
        if (!LoopUtility.isFixedNode(def) || !LoopUtility.isFixedNode(use)) {
            return false;
        }
        HIRBlock useBlock = cfg.blockFor(use);
        HIRBlock defBlock = cfg.blockFor(def);
        Loop<HIRBlock> defLoop = defBlock.getLoop();
        Loop<HIRBlock> useLoop = useBlock.getLoop();
        if (defLoop != null) {
            if (useLoop != null) {
                return useLoop.isAncestorOrSelf(defLoop);
            }
            return false;
        }
        return true;
    }

    private static boolean isFixedNode(Node n) {
        return n instanceof FixedNode;
    }

    public static boolean isNumericInteger(ValueNode v) {
        Stamp s = v.stamp(NodeView.DEFAULT);
        return s instanceof IntegerStamp;
    }

    public static boolean isLong(ValueNode v) {
        Stamp s = v.stamp(NodeView.DEFAULT);
        return s instanceof IntegerStamp && IntegerStamp.getBits(s) == 64;
    }

    public static boolean isInt(ValueNode v) {
        Stamp s = v.stamp(NodeView.DEFAULT);
        return s instanceof IntegerStamp && IntegerStamp.getBits(s) == 32;
    }

    public static void removeObsoleteProxies(StructuredGraph graph, CoreProviders context, CanonicalizerPhase canonicalizer) {
        LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
        EconomicSetNodeEventListener inputChanges = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.INPUT_CHANGED));
        try (Graph.NodeEventScope s = graph.trackNodeEvents(inputChanges);){
            for (LoopEx loop : loopsData.loops()) {
                LoopUtility.removeObsoleteProxiesForLoop(loop);
            }
        }
        canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)inputChanges.getNodes());
    }

    public static void removeObsoleteProxiesForLoop(LoopEx loop) {
        for (LoopExitNode lex : loop.loopBegin().loopExits()) {
            for (ProxyNode proxy : lex.proxies().snapshot()) {
                if (!loop.isOutsideLoop(proxy.value())) continue;
                proxy.replaceAtUsagesAndDelete(proxy.getOriginalNode());
            }
        }
    }

    public static void stepLoopIVs(StructuredGraph graph, LoopEx loop, ValueNode iterations) {
        for (InductionVariable iv : loop.getInductionVariables().getValues()) {
            if (!(iv instanceof BasicInductionVariable)) continue;
            ValuePhiNode phi = ((BasicInductionVariable)iv).valueNode();
            ValueNode convertedIterations = IntegerConvertNode.convert(iterations, iv.strideNode().stamp(NodeView.DEFAULT), NodeView.DEFAULT);
            ValueNode steppedInit = AddNode.create(phi.valueAt(0), MulNode.create(convertedIterations, iv.strideNode(), NodeView.DEFAULT), NodeView.DEFAULT);
            phi.setValueAt(0, graph.addOrUniqueWithInputs(steppedInit));
        }
    }
}

