/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.util;

import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.spi.WordVerification;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.compiler.word.WordVerificationImpl;

public class Providers
implements CoreProviders,
CodeGenProviders {
    protected final MetaAccessProvider metaAccess;
    protected final ConstantReflectionProvider constantReflection;
    protected final ConstantFieldProvider constantFieldProvider;
    protected final LoweringProvider lowerer;
    protected final Replacements replacements;
    protected final StampProvider stampProvider;
    protected final ForeignCallsProvider foreignCalls;
    protected final PlatformConfigurationProvider platformConfigurationProvider;
    protected final MetaAccessExtensionProvider metaAccessExtensionProvider;
    protected final LoopsDataProvider loopsDataProvider;
    protected final WordVerification wordVerification;
    protected final CodeCacheProvider codeCache;
    protected final SnippetReflectionProvider snippetReflection;
    protected final WordTypes wordTypes;

    public Providers(MetaAccessProvider metaAccess, CodeCacheProvider codeCache, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, ForeignCallsProvider foreignCalls, LoweringProvider lowerer, Replacements replacements, StampProvider stampProvider, PlatformConfigurationProvider platformConfigurationProvider, MetaAccessExtensionProvider metaAccessExtensionProvider, SnippetReflectionProvider snippetReflection, WordTypes wordTypes, LoopsDataProvider loopsDataProvider) {
        this.metaAccess = metaAccess;
        this.constantReflection = constantReflection;
        this.constantFieldProvider = constantFieldProvider;
        this.lowerer = lowerer;
        this.replacements = replacements;
        this.stampProvider = stampProvider;
        this.foreignCalls = foreignCalls;
        this.platformConfigurationProvider = platformConfigurationProvider;
        this.metaAccessExtensionProvider = metaAccessExtensionProvider;
        this.loopsDataProvider = loopsDataProvider;
        this.wordVerification = new WordVerificationImpl(wordTypes);
        this.codeCache = codeCache;
        this.snippetReflection = snippetReflection;
        this.wordTypes = wordTypes;
    }

    public Providers(Providers copyFrom) {
        this(copyFrom.getMetaAccess(), copyFrom.getCodeCache(), copyFrom.getConstantReflection(), copyFrom.getConstantFieldProvider(), copyFrom.getForeignCalls(), copyFrom.getLowerer(), copyFrom.getReplacements(), copyFrom.getStampProvider(), copyFrom.getPlatformConfigurationProvider(), copyFrom.getMetaAccessExtensionProvider(), copyFrom.getSnippetReflection(), copyFrom.getWordTypes(), copyFrom.getLoopsDataProvider());
    }

    @Override
    public MetaAccessProvider getMetaAccess() {
        return this.metaAccess;
    }

    @Override
    public ConstantReflectionProvider getConstantReflection() {
        return this.constantReflection;
    }

    @Override
    public ConstantFieldProvider getConstantFieldProvider() {
        return this.constantFieldProvider;
    }

    @Override
    public LoweringProvider getLowerer() {
        return this.lowerer;
    }

    @Override
    public Replacements getReplacements() {
        return this.replacements;
    }

    @Override
    public StampProvider getStampProvider() {
        return this.stampProvider;
    }

    @Override
    public ForeignCallsProvider getForeignCalls() {
        return this.foreignCalls;
    }

    @Override
    public PlatformConfigurationProvider getPlatformConfigurationProvider() {
        return this.platformConfigurationProvider;
    }

    @Override
    public MetaAccessExtensionProvider getMetaAccessExtensionProvider() {
        return this.metaAccessExtensionProvider;
    }

    @Override
    public LoopsDataProvider getLoopsDataProvider() {
        return this.loopsDataProvider;
    }

    @Override
    public WordVerification getWordVerification() {
        return this.wordVerification;
    }

    @Override
    public CodeCacheProvider getCodeCache() {
        return this.codeCache;
    }

    @Override
    public SnippetReflectionProvider getSnippetReflection() {
        return this.snippetReflection;
    }

    public WordTypes getWordTypes() {
        return this.wordTypes;
    }

    public Providers copyWith(ConstantReflectionProvider substitution) {
        assert (this.getClass() == Providers.class) : "must override";
        return new Providers(this.metaAccess, this.codeCache, substitution, this.constantFieldProvider, this.foreignCalls, this.lowerer, this.replacements, this.stampProvider, this.platformConfigurationProvider, this.metaAccessExtensionProvider, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }

    public Providers copyWith(ConstantFieldProvider substitution) {
        assert (this.getClass() == Providers.class) : "must override";
        return new Providers(this.metaAccess, this.codeCache, this.constantReflection, substitution, this.foreignCalls, this.lowerer, this.replacements, this.stampProvider, this.platformConfigurationProvider, this.metaAccessExtensionProvider, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }

    public Providers copyWith(Replacements substitution) {
        assert (this.getClass() == Providers.class) : "must override in " + this.getClass();
        return new Providers(this.metaAccess, this.codeCache, this.constantReflection, this.constantFieldProvider, this.foreignCalls, this.lowerer, substitution, this.stampProvider, this.platformConfigurationProvider, this.metaAccessExtensionProvider, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }

    public Providers copyWith(MetaAccessExtensionProvider substitution) {
        assert (this.getClass() == Providers.class) : this.getClass() + " must override";
        return new Providers(this.metaAccess, this.codeCache, this.constantReflection, this.constantFieldProvider, this.foreignCalls, this.lowerer, this.replacements, this.stampProvider, this.platformConfigurationProvider, substitution, this.snippetReflection, this.wordTypes, this.loopsDataProvider);
    }
}

