/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.ArrayList;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.type.StampTool;

public class InvocationPluginHelper
implements DebugCloseable {
    protected final GraphBuilderContext b;
    private final JavaKind wordKind;
    private final JavaKind returnKind;
    private final ArrayList<ReturnData> returns = new ArrayList();
    private boolean emittedReturn;
    private FixedWithNextNode fallbackEntry;

    public ValueNode arraylength(ValueNode receiverValue) {
        assert (StampTool.isPointerNonNull(receiverValue));
        return this.b.add(ArrayLengthNode.create(receiverValue, this.b.getConstantReflection()));
    }

    @Override
    public void close() {
        if (this.returns.size() != 0 && !this.emittedReturn) {
            throw new InternalError("must call emitReturn before plugin returns");
        }
    }

    public JavaKind getWordKind() {
        return this.wordKind;
    }

    public PiNode piCast(ValueNode value, GuardingNode nonnullGuard, Stamp stamp) {
        return this.b.add(new PiNode(value, stamp, nonnullGuard.asNode()));
    }

    public InvocationPluginHelper(GraphBuilderContext b, ResolvedJavaMethod targetMethod) {
        this.b = b;
        this.wordKind = b.getReplacements().getWordKind();
        this.returnKind = targetMethod.getSignature().getReturnKind();
    }

    public ValueNode shl(ValueNode node, int shiftAmount) {
        if (shiftAmount == 0) {
            return node;
        }
        return this.b.add(new LeftShiftNode(node, ConstantNode.forInt(shiftAmount)));
    }

    public ValueNode shr(ValueNode node, int shiftAmount) {
        if (shiftAmount == 0) {
            return node;
        }
        return this.b.add(new RightShiftNode(node, ConstantNode.forInt(shiftAmount)));
    }

    public ValueNode ushr(ValueNode node, int shiftAmount) {
        if (shiftAmount == 0) {
            return node;
        }
        return this.b.add(new UnsignedRightShiftNode(node, ConstantNode.forInt(shiftAmount)));
    }

    public ValueNode xor(ValueNode x, ValueNode y) {
        return this.b.add(new XorNode(x, y));
    }

    public ValueNode or(ValueNode x, ValueNode y) {
        return this.b.add(new OrNode(x, y));
    }

    public ValueNode add(ValueNode x, ValueNode y) {
        return this.b.add(new AddNode(x, y));
    }

    public ValueNode sub(ValueNode x, ValueNode y) {
        return this.b.add(new SubNode(x, y));
    }

    public ValueNode length(ValueNode x) {
        ResolvedJavaType type = StampTool.typeOrNull(x);
        assert (type == null || type.isArray() || type.isJavaLangObject()) : x.stamp(NodeView.DEFAULT);
        return this.b.add(new ArrayLengthNode(x));
    }

    public ValueNode arrayElementPointerScaled(ValueNode array, JavaKind kind, ValueNode index) {
        return this.arrayElementPointer(array, kind, index, true, false);
    }

    public ValueNode arrayElementPointer(ValueNode array, JavaKind kind, ValueNode index) {
        return this.arrayElementPointer(array, kind, index, false, false);
    }

    public ValueNode arrayElementPointer(ValueNode array, JavaKind kind, ValueNode index, boolean skipComponentTypeCheck) {
        return this.arrayElementPointer(array, kind, index, false, skipComponentTypeCheck);
    }

    private ValueNode arrayElementPointer(ValueNode array, JavaKind kind, ValueNode index, boolean scaled, boolean skipComponentTypeCheck) {
        JavaKind actualKind = scaled ? JavaKind.Byte : kind;
        ResolvedJavaType type = StampTool.typeOrNull(array);
        assert (skipComponentTypeCheck || type == null || type.isArray() && type.getComponentType().getJavaKind() == actualKind || type.isJavaLangObject()) : array.stamp(NodeView.DEFAULT);
        int arrayBaseOffset = this.b.getMetaAccess().getArrayBaseOffset(kind);
        ValueNode offset = ConstantNode.forIntegerKind(this.wordKind, arrayBaseOffset);
        if (index != null) {
            ValueNode scaledIndex = this.shl(this.asWord(index), CodeUtil.log2((int)this.b.getMetaAccess().getArrayIndexScale(kind)));
            offset = this.add(offset, scaledIndex);
        }
        GraalError.guarantee(offset.getStackKind() == this.wordKind, "should have been promoted to word: %s", (Object)index);
        return this.b.add(new ComputeObjectAddressNode(array, offset));
    }

    public ValueNode arrayStart(ValueNode array, JavaKind kind) {
        return this.arrayElementPointer(array, kind, null);
    }

    public AddressNode makeOffsetAddress(ValueNode base, ValueNode offset) {
        return this.b.add(new OffsetAddressNode(base, this.asWord(offset)));
    }

    public ValueNode asWord(ValueNode index) {
        assert (index.getStackKind().isPrimitive());
        if (index.getStackKind() != this.wordKind) {
            return SignExtendNode.create(index, this.wordKind.getBitCount(), NodeView.DEFAULT);
        }
        return index;
    }

    public ValueNode asWord(long index) {
        return ConstantNode.forIntegerKind(this.wordKind, index);
    }

    private LogicNode createCompare(ValueNode origX, Condition condition, ValueNode origY) {
        Condition.CanonicalizedCondition canonicalizedCondition = condition.canonicalize();
        ValueNode x = origX;
        ValueNode y = origY;
        if (canonicalizedCondition.mustMirror()) {
            x = origY;
            y = origX;
        }
        LogicNode compare = this.createCompare(x, canonicalizedCondition.getCanonicalCondition(), y);
        if (canonicalizedCondition.mustNegate()) {
            compare = LogicNegationNode.create(compare);
        }
        return compare;
    }

    public LogicNode createCompare(ValueNode x, CanonicalCondition cond, ValueNode y) {
        assert (!x.getStackKind().isNumericFloat());
        switch (cond) {
            case EQ: {
                if (x.getStackKind() == JavaKind.Object) {
                    return ObjectEqualsNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), x, y, NodeView.DEFAULT);
                }
                return IntegerEqualsNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), null, x, y, NodeView.DEFAULT);
            }
            case LT: {
                GraalError.guarantee(x.getStackKind() != JavaKind.Object, "object not allowed");
                return IntegerLessThanNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), null, x, y, NodeView.DEFAULT);
            }
            case BT: {
                GraalError.guarantee(x.getStackKind() != JavaKind.Object, "object not allowed");
                return IntegerBelowNode.create(this.b.getConstantReflection(), this.b.getMetaAccess(), y.getOptions(), null, x, y, NodeView.DEFAULT);
            }
        }
        throw GraalError.shouldNotReachHere("Unexpected condition: " + cond);
    }

    public ValueNode loadField(ValueNode value, ResolvedJavaField field) {
        return this.b.add(LoadFieldNode.create(this.b.getConstantFieldProvider(), this.b.getConstantReflection(), this.b.getMetaAccess(), this.b.getOptions(), this.b.getAssumptions(), value, field, false, false, this.b.getGraph().currentNodeSourcePosition()));
    }

    public ResolvedJavaField getField(ResolvedJavaType type, String fieldName) {
        for (ResolvedJavaField field : type.getInstanceFields(true)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new GraalError("missing field " + fieldName + " in type " + type);
    }

    public ValueNode getFieldOffset(ResolvedJavaType type, String fieldName) {
        GraalError.guarantee(!Services.IS_BUILDING_NATIVE_IMAGE || !this.b.parsingIntrinsic(), "these values must be deferred in substitutions and snippets");
        return ConstantNode.forInt(this.getField(type, fieldName).getOffset());
    }

    public GuardingNode intrinsicRangeCheck(ValueNode x, Condition condition, ValueNode y) {
        return this.b.intrinsicRangeCheck(this.createCompare(x, condition, y), false);
    }

    public void intrinsicArrayRangeCheck(ValueNode array, ValueNode index, ValueNode offset) {
        this.intrinsicRangeCheck(index, Condition.LT, ConstantNode.forInt(0));
        ValueNode length = this.length(this.b.nullCheckedValue(array));
        this.intrinsicRangeCheck(this.add(index, offset), Condition.AT, length);
    }

    public void intrinsicArrayRangeCheckScaled(ValueNode array, ValueNode index, ValueNode offset) {
        this.intrinsicRangeCheck(index, Condition.LT, ConstantNode.forInt(0));
        ValueNode length = this.length(this.b.nullCheckedValue(array));
        ValueNode shiftedLength = this.shr(length, 1);
        this.intrinsicRangeCheck(this.add(index, offset), Condition.AT, shiftedLength);
    }

    public AbstractBeginNode emitReturnIf(LogicNode condition, ValueNode returnValue, double returnProbability) {
        return this.emitReturnIf(condition, false, returnValue, returnProbability);
    }

    public AbstractBeginNode emitReturnIf(ValueNode x, Condition condition, ValueNode y, ValueNode returnValue, double returnProbability) {
        return this.emitReturnIf(this.createCompare(x, condition, y), false, returnValue, returnProbability);
    }

    public AbstractBeginNode emitReturnIfNot(LogicNode condition, ValueNode returnValue, double returnProbability) {
        return this.emitReturnIf(condition, true, returnValue, returnProbability);
    }

    private AbstractBeginNode emitReturnIf(LogicNode condition, boolean negated, ValueNode returnValue, double returnProbability) {
        BeginNode trueSuccessor = this.b.getGraph().add(new BeginNode());
        EndNode end = this.b.getGraph().add(new EndNode());
        trueSuccessor.setNext(end);
        this.addReturnValue(end, this.returnKind, returnValue);
        ProfileData.BranchProbabilityData probability = ProfileData.BranchProbabilityData.injected(returnProbability, negated);
        IfNode node = new IfNode(condition, negated ? null : trueSuccessor, negated ? trueSuccessor : null, probability);
        IfNode ifNode = this.b.append(node);
        BeginNode otherSuccessor = this.b.append(new BeginNode());
        if (negated) {
            ifNode.setTrueSuccessor(otherSuccessor);
        } else {
            ifNode.setFalseSuccessor(otherSuccessor);
        }
        return otherSuccessor;
    }

    public void emitFinalReturn(JavaKind kind, ValueNode returnValue) {
        GraalError.guarantee(!this.emittedReturn, "must only have one final return");
        GraalError.guarantee(kind == this.returnKind, "mismatch in return kind");
        if (kind != JavaKind.Void) {
            this.b.addPush(kind, returnValue);
        }
        if (this.returns.size() > 0) {
            if (kind != JavaKind.Void) {
                this.b.pop(this.returnKind);
            }
            EndNode end = this.b.append(new EndNode());
            this.addReturnValue(end, kind, returnValue);
            MergeNode returnMerge = this.b.append(new MergeNode());
            ValuePhiNode returnPhi = null;
            if (this.returnKind != JavaKind.Void) {
                returnPhi = this.b.add(new ValuePhiNode(StampFactory.forKind(this.returnKind), returnMerge));
            }
            returnMerge.setStateAfter(this.b.getInvocationPluginReturnState(kind, returnPhi));
            for (ReturnData r : this.returns) {
                returnMerge.addForwardEnd(r.end);
                if (returnPhi != null) {
                    returnPhi.addInput(r.returnValue);
                    continue;
                }
                assert (r.returnValue == null);
            }
            if (kind != JavaKind.Void) {
                this.b.addPush(this.returnKind, returnPhi.singleValueOrThis());
            }
        }
        this.emittedReturn = true;
    }

    protected void addReturnValue(EndNode end, JavaKind kind, ValueNode returnValueInput) {
        assert (this.b.canMergeIntrinsicReturns());
        GraalError.guarantee(kind == this.returnKind, "mismatch in return kind");
        ValueNode returnValue = returnValueInput;
        if (kind != JavaKind.Void && returnValue.isUnregistered()) {
            GraalError.guarantee(!(returnValue instanceof FixedNode), "unexpected FixedNode");
            returnValue = this.b.add(returnValue);
        }
        this.returns.add(new ReturnData(end, returnValue));
    }

    private BeginNode branchToFallback() {
        EndNode end;
        if (this.fallbackEntry == null) {
            EndNode end2;
            BeginNode fallbackSuccessor = this.b.getGraph().add(new BeginNode());
            Invoke invoke = this.b.invokeFallback(fallbackSuccessor, end2 = this.b.getGraph().add(new EndNode()));
            if (invoke != null) {
                this.fallbackEntry = fallbackSuccessor;
                this.addReturnValue(end2, this.returnKind, this.returnKind == JavaKind.Void ? null : invoke.asNode());
            } else {
                assert (end2.predecessor() == null);
                end2.safeDelete();
            }
            return fallbackSuccessor;
        }
        if (!(this.fallbackEntry instanceof MergeNode)) {
            assert (this.fallbackEntry instanceof BeginNode);
            BeginNode begin = (BeginNode)this.fallbackEntry;
            FixedNode next = begin.next();
            end = this.b.getGraph().add(new EndNode());
            begin.setNext(end);
            MergeNode merge = this.b.getGraph().add(new MergeNode());
            merge.addForwardEnd(end);
            merge.setNext(next);
            this.fallbackEntry = merge;
            merge.setStateAfter(this.b.getInvocationPluginBeforeState());
        }
        MergeNode fallbackMerge = (MergeNode)this.fallbackEntry;
        BeginNode fallbackSuccessor = this.b.getGraph().add(new BeginNode());
        end = this.b.getGraph().add(new EndNode());
        fallbackSuccessor.setNext(end);
        fallbackMerge.addForwardEnd(end);
        return fallbackSuccessor;
    }

    public GuardingNode doFallbackIf(ValueNode x, Condition condition, ValueNode y, double returnProbability) {
        return this.doFallbackIf(this.createCompare(x, condition, y), false, returnProbability);
    }

    public GuardingNode doFallbackIfNot(LogicNode condition, double probability) {
        return this.doFallbackIf(condition, true, probability);
    }

    public GuardingNode doFallbackIf(LogicNode condition, double probability) {
        return this.doFallbackIf(condition, false, probability);
    }

    private GuardingNode doFallbackIf(LogicNode origCondition, boolean origNegated, double origProbability) {
        boolean negated = origNegated;
        LogicNode condition = origCondition;
        double probability = origProbability;
        while (condition instanceof LogicNegationNode) {
            LogicNegationNode negation = (LogicNegationNode)condition;
            negated = !negated;
            condition = negation.getValue();
            probability = 1.0 - probability;
        }
        BeginNode fallbackSuccessor = this.branchToFallback();
        ProfileData.BranchProbabilityData probabilityData = ProfileData.BranchProbabilityData.injected(probability, negated);
        IfNode node = new IfNode(condition, negated ? null : fallbackSuccessor, negated ? fallbackSuccessor : null, probabilityData);
        IfNode ifNode = this.b.append(node);
        BeginNode fallThroughSuccessor = this.b.append(new BeginNode());
        if (negated) {
            ifNode.setTrueSuccessor(fallThroughSuccessor);
        } else {
            ifNode.setFalseSuccessor(fallThroughSuccessor);
        }
        return fallThroughSuccessor;
    }

    static class ReturnData {
        final EndNode end;
        final ValueNode returnValue;

        ReturnData(EndNode end, ValueNode returnValue) {
            this.end = end;
            this.returnValue = returnValue;
        }
    }
}

