/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.MethodHandleNode;
import org.graalvm.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;

public class MethodHandlePlugin
implements NodePlugin {
    private final MethodHandleAccessProvider methodHandleAccess;
    private final boolean safeForDeoptimization;

    public MethodHandlePlugin(MethodHandleAccessProvider methodHandleAccess, boolean safeForDeoptimization) {
        this.methodHandleAccess = methodHandleAccess;
        this.safeForDeoptimization = safeForDeoptimization;
    }

    protected Invoke createInvoke(CallTargetNode callTarget, int bci, Stamp stamp) {
        return new InvokeNode(callTarget, bci, stamp);
    }

    protected MacroInvokable createMethodHandleNode(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, CallTargetNode.InvokeKind invokeKind, StampPair invokeReturnStamp) {
        return new MethodHandleNode(intrinsicMethod, MacroNode.MacroParams.of(invokeKind, b.getMethod(), method, b.bci(), invokeReturnStamp, args));
    }

    @Override
    public boolean handleInvoke(final GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod = this.methodHandleAccess.lookupMethodHandleIntrinsic(method);
        if (intrinsicMethod != null) {
            CallTargetNode.InvokeKind invokeKind = b.getInvokeKind();
            if (invokeKind != CallTargetNode.InvokeKind.Static) {
                args[0] = b.nullCheckedValue(args[0]);
            }
            StampPair invokeReturnStamp = b.getInvokeReturnStamp(b.getAssumptions());
            MethodHandleNode.GraphAdder adder = new MethodHandleNode.GraphAdder(b.getGraph()){

                @Override
                public <T extends ValueNode> T add(T node) {
                    return b.add(node);
                }
            };
            Invoke invoke = MethodHandleNode.tryResolveTargetInvoke(adder, this::createInvoke, this.methodHandleAccess, intrinsicMethod, method, b.bci(), invokeReturnStamp, args);
            if (invoke == null) {
                MacroInvokable methodHandleNode = this.createMethodHandleNode(b, method, args, intrinsicMethod, invokeKind, invokeReturnStamp);
                if (invokeReturnStamp.getTrustedStamp().getStackKind() == JavaKind.Void) {
                    b.add(methodHandleNode.asNode());
                } else {
                    b.addPush(invokeReturnStamp.getTrustedStamp().getStackKind(), methodHandleNode.asNode());
                }
            } else {
                JavaKind targetMethodReturnKind;
                JavaKind invokeReturnKind;
                int maxRecursionDepth;
                ResolvedMethodHandleCallTargetNode callTarget = (ResolvedMethodHandleCallTargetNode)invoke.callTarget();
                NodeInputList<ValueNode> argumentsList = callTarget.arguments();
                for (int i = 0; i < argumentsList.size(); ++i) {
                    argumentsList.initialize(i, b.append((ValueNode)argumentsList.get(i)));
                }
                boolean inlineEverything = false;
                if (this.safeForDeoptimization) {
                    inlineEverything = args.length != argumentsList.size();
                }
                ResolvedJavaMethod targetMethod = callTarget.targetMethod();
                if (inlineEverything && !targetMethod.hasBytecodes() && !b.getReplacements().hasSubstitution(targetMethod, b.getOptions())) {
                    return false;
                }
                int recursionDepth = b.recursiveInliningDepth(targetMethod);
                if (recursionDepth > (maxRecursionDepth = GraalOptions.MaximumRecursiveInlining.getValue(b.getOptions()).intValue())) {
                    return false;
                }
                Invokable newInvokable = b.handleReplacedInvoke(invoke.getInvokeKind(), targetMethod, argumentsList.toArray((A[])new ValueNode[argumentsList.size()]), inlineEverything);
                if (newInvokable != null) {
                    Invoke newInvoke;
                    if (newInvokable instanceof Invoke && !(newInvoke = (Invoke)newInvokable).callTarget().equals(callTarget) && newInvoke.asFixedNode().isAlive()) {
                        newInvoke.callTarget().replaceAndDelete(b.append(callTarget));
                        return true;
                    }
                    if (newInvokable instanceof MacroInvokable) {
                        MacroInvokable macroInvokable = (MacroInvokable)newInvokable;
                        macroInvokable.addMethodHandleInfo(callTarget);
                    } else {
                        throw GraalError.shouldNotReachHere("unexpected Invokable: " + newInvokable);
                    }
                }
                if ((invokeReturnKind = invokeReturnStamp.getTrustedStamp().getStackKind()) != (targetMethodReturnKind = targetMethod.getSignature().getReturnKind().getStackKind())) {
                    b.pop(targetMethodReturnKind);
                    if (invokeReturnKind != JavaKind.Void) {
                        throw b.bailout("Cannot do any type conversion when invoking method handle, so return value must remain popped");
                    }
                }
            }
            return true;
        }
        return false;
    }
}

