/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.cfg.CFGVerifier;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.SourceLanguagePosition;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PluginReplacementInterface;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SimplifyingGraphDecoder;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.AbstractNewArrayNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;

public abstract class PEGraphDecoder
extends SimplifyingGraphDecoder {
    private static final Object CACHED_NULL_VALUE = new Object();
    private static final TimerKey InvocationPluginTimer = DebugContext.timer("PartialEvaluation-InvocationPlugin").doc("Time spent in invocation plugins.");
    private static final TimerKey TryInlineTimer = DebugContext.timer("PartialEvaluation-TryInline").doc("Time spent in trying to inline an invoke.");
    private static final TimerKey TrySimplifyCallTarget = DebugContext.timer("PartialEvaluation-TrySimplifyCallTarget").doc("Time spent in trying to simplify a call target.");
    private final LoopExplosionPlugin loopExplosionPlugin;
    private final InvocationPlugins invocationPlugins;
    private final InlineInvokePlugin[] inlineInvokePlugins;
    private final ParameterPlugin parameterPlugin;
    private final NodePlugin[] nodePlugins;
    private final ConcurrentHashMap<SpecialCallTargetCacheKey, Object> specialCallTargetCache;
    private final ConcurrentHashMap<ResolvedJavaMethod, Object> invocationPluginCache;
    private final ResolvedJavaMethod peRootForInlining;
    protected final SourceLanguagePositionProvider sourceLanguagePositionProvider;
    protected final boolean needsExplicitException;
    private final boolean forceLink;

    protected IntrinsicContext getIntrinsic() {
        return null;
    }

    public PEGraphDecoder(Architecture architecture, StructuredGraph graph, CoreProviders providers, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, ResolvedJavaMethod peRootForInlining, SourceLanguagePositionProvider sourceLanguagePositionProvider, ConcurrentHashMap<SpecialCallTargetCacheKey, Object> specialCallTargetCache, ConcurrentHashMap<ResolvedJavaMethod, Object> invocationPluginCache, boolean needsExplicitException, boolean forceLink) {
        super(architecture, graph, providers, true);
        this.loopExplosionPlugin = loopExplosionPlugin;
        this.invocationPlugins = invocationPlugins;
        this.inlineInvokePlugins = inlineInvokePlugins;
        this.parameterPlugin = parameterPlugin;
        this.nodePlugins = nodePlugins;
        this.specialCallTargetCache = specialCallTargetCache;
        this.invocationPluginCache = invocationPluginCache;
        this.peRootForInlining = peRootForInlining;
        this.sourceLanguagePositionProvider = sourceLanguagePositionProvider;
        this.needsExplicitException = needsExplicitException;
        this.forceLink = forceLink;
    }

    protected static LoopExplosionPlugin.LoopExplosionKind loopExplosionKind(ResolvedJavaMethod method, LoopExplosionPlugin loopExplosionPlugin) {
        if (loopExplosionPlugin == null) {
            return LoopExplosionPlugin.LoopExplosionKind.NONE;
        }
        return loopExplosionPlugin.loopExplosionKind(method);
    }

    public void decode(ResolvedJavaMethod method) {
        try (DebugContext.Scope scope = this.debug.scope((Object)"PEGraphDecode", this.graph);){
            EncodedGraph encodedGraph = this.lookupEncodedGraph(method, null);
            this.recordGraphElements(encodedGraph);
            PEMethodScope methodScope = this.createMethodScope(this.graph, null, null, encodedGraph, method, null, 0, null);
            this.decode(this.createInitialLoopScope(methodScope, null));
            this.debug.dump(3, this.graph, "Before graph cleanup");
            this.cleanupGraph(methodScope);
            this.debug.dump(3, this.graph, "After graph cleanup");
            assert (this.graph.verify());
        }
        catch (Throwable t) {
            throw this.debug.handle(t);
        }
        try {
            assert (CFGVerifier.verify(ControlFlowGraph.compute(this.graph, true, true, true, true)));
        }
        catch (Throwable ex) {
            throw GraalError.shouldNotReachHere(ex, "Control flow graph not valid after partial evaluation");
        }
    }

    protected PEMethodScope createMethodScope(StructuredGraph targetGraph, PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
        return new PEMethodScope(targetGraph, caller, callerLoopScope, encodedGraph, method, invokeData, inliningDepth, arguments);
    }

    @Override
    protected void cleanupGraph(GraphDecoder.MethodScope methodScope) {
        super.cleanupGraph(methodScope);
        for (FrameState frameState : this.graph.getNodes(FrameState.TYPE)) {
            if (frameState.bci != -1) continue;
            PEMethodScope peMethodScope = (PEMethodScope)methodScope;
            Invoke invoke = peMethodScope.invokeData != null ? (Invoke)peMethodScope.invokeData.invoke : null;
            InliningUtil.handleMissingAfterExceptionFrameState(frameState, invoke, null, true);
            assert (frameState.isDeleted());
        }
        for (FixedAnchorNode anchor : this.graph.getNodes(FixedAnchorNode.TYPE).snapshot()) {
            AbstractBeginNode newAnchor = AbstractBeginNode.prevBegin(anchor);
            assert (newAnchor != null) : "Must find prev begin node";
            anchor.replaceAtUsages((Node)newAnchor, InputType.Guard, InputType.Anchor);
            anchor.replaceAtUsages(anchor.value);
            assert (anchor.hasNoUsages());
            GraphUtil.unlinkFixedNode(anchor);
            anchor.safeDelete();
        }
    }

    @Override
    protected void checkLoopExplosionIteration(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope) {
        PEMethodScope methodScope = (PEMethodScope)s;
        if (loopScope.loopIteration > Options.MaximumLoopExplosionCount.getValue(this.options)) {
            throw PEGraphDecoder.tooManyLoopExplosionIterations(methodScope, this.options);
        }
    }

    private static RuntimeException tooManyLoopExplosionIterations(PEMethodScope methodScope, OptionValues options) {
        String message = "too many loop explosion iterations - does the explosion not terminate for method " + methodScope.method + "?";
        Object bailout = Options.FailedLoopExplosionIsFatal.getValue(options) != false ? new RuntimeException(message) : new PermanentBailoutException(message);
        throw GraphUtil.createBailoutException(message, (Throwable)bailout, methodScope.getCallStack());
    }

    @Override
    protected GraphDecoder.LoopScope handleInvoke(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData) {
        assert (((Invoke)invokeData.invoke).callTarget() == null) : "callTarget edge is ignored during decoding of Invoke";
        invokeData.callTarget = (CallTargetNode)this.decodeFloatingNode(s, loopScope, invokeData.callTargetOrderId);
        return this.handleInvokeWithCallTarget((PEMethodScope)s, loopScope, invokeData);
    }

    protected GraphDecoder.LoopScope handleInvokeWithCallTarget(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData) {
        CallTargetNode callTarget = invokeData.callTarget;
        if (callTarget instanceof MethodCallTargetNode) {
            GraphDecoder.LoopScope inlineLoopScope;
            MethodCallTargetNode methodCall = (MethodCallTargetNode)callTarget;
            if (methodCall.invokeKind().hasReceiver()) {
                invokeData.constantReceiver = ((ValueNode)methodCall.arguments().get(0)).asJavaConstant();
            }
            callTarget = this.trySimplifyCallTarget(methodScope, invokeData, methodCall);
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            if (this.forceLink && targetMethod.hasBytecodes() && targetMethod.getCode() == null && !targetMethod.getDeclaringClass().isLinked()) {
                targetMethod.getDeclaringClass().link();
            }
            if ((inlineLoopScope = this.trySimplifyInvoke(methodScope, loopScope, invokeData, (MethodCallTargetNode)callTarget)) != null) {
                return inlineLoopScope;
            }
        }
        this.handleNonInlinedInvoke(methodScope, loopScope, invokeData);
        return loopScope;
    }

    protected void handleNonInlinedInvoke(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData) {
        CallTargetNode callTarget = invokeData.callTarget;
        this.graph.add(callTarget);
        if (invokeData.callTargetOrderId > 0) {
            this.registerNode(loopScope, invokeData.callTargetOrderId, callTarget, false, false);
        }
        this.appendInvoke(methodScope, loopScope, invokeData, callTarget);
    }

    protected MethodCallTargetNode trySimplifyCallTarget(PEMethodScope methodScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        try (DebugCloseable a = TrySimplifyCallTarget.start(this.debug);){
            ResolvedJavaMethod specialCallTarget = this.getSpecialCallTarget(invokeData, callTarget);
            if (specialCallTarget != null) {
                callTarget.setTargetMethod(specialCallTarget);
                callTarget.setInvokeKind(CallTargetNode.InvokeKind.Special);
                MethodCallTargetNode methodCallTargetNode = callTarget;
                return methodCallTargetNode;
            }
            if (callTarget.invokeKind().isInterface()) {
                Invoke invoke = (Invoke)invokeData.invoke;
                ResolvedJavaType contextType = methodScope.method.getDeclaringClass();
                MethodCallTargetNode methodCallTargetNode = MethodCallTargetNode.tryDevirtualizeInterfaceCall(callTarget.receiver(), callTarget.targetMethod(), null, this.graph.getAssumptions(), contextType, callTarget, invoke.asFixedNode());
                return methodCallTargetNode;
            }
            MethodCallTargetNode methodCallTargetNode = callTarget;
            return methodCallTargetNode;
        }
    }

    protected GraphDecoder.LoopScope trySimplifyInvoke(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        boolean invocationPluginTriggered = this.tryInvocationPlugin(methodScope, loopScope, invokeData, callTarget);
        if (invocationPluginTriggered) {
            return loopScope;
        }
        GraphDecoder.LoopScope inlineLoopScope = this.tryInline(methodScope, loopScope, invokeData, callTarget);
        if (inlineLoopScope != null) {
            return inlineLoopScope;
        }
        for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
            plugin.notifyNotInlined(new PENonAppendGraphBuilderContext(methodScope, (Invoke)invokeData.invoke), callTarget.targetMethod(), (Invoke)invokeData.invoke);
        }
        return null;
    }

    private ResolvedJavaMethod getSpecialCallTarget(GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        if (callTarget.invokeKind().isDirect()) {
            return null;
        }
        if (callTarget.targetMethod().canBeStaticallyBound()) {
            return callTarget.targetMethod();
        }
        SpecialCallTargetCacheKey key = new SpecialCallTargetCacheKey(callTarget.invokeKind(), callTarget.targetMethod(), invokeData.contextType, callTarget.receiver().stamp(NodeView.DEFAULT));
        Object specialCallTarget = this.specialCallTargetCache.computeIfAbsent(key, k -> {
            Object target = MethodCallTargetNode.devirtualizeCall(k.invokeKind, k.targetMethod, k.contextType, this.graph.getAssumptions(), k.receiverStamp);
            if (target == null) {
                target = CACHED_NULL_VALUE;
            }
            return target;
        });
        return specialCallTarget == CACHED_NULL_VALUE ? null : (ResolvedJavaMethod)specialCallTarget;
    }

    protected boolean tryInvocationPlugin(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        try (DebugCloseable a = InvocationPluginTimer.start(this.debug);){
            if (this.invocationPlugins == null || this.invocationPlugins.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (!callTarget.invokeKind().isDirect()) {
                boolean bl = false;
                return bl;
            }
            Invoke invoke = (Invoke)invokeData.invoke;
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            if (loopScope.methodScope.encodedGraph.isCallToOriginal(targetMethod)) {
                boolean bl = false;
                return bl;
            }
            InvocationPlugin invocationPlugin = this.getInvocationPlugin(targetMethod);
            if (invocationPlugin == null) {
                boolean bl = false;
                return bl;
            }
            ValueNode[] arguments = callTarget.arguments().toArray((A[])ValueNode.EMPTY_ARRAY);
            FixedWithNextNode invokePredecessor = (FixedWithNextNode)invoke.asNode().predecessor();
            invoke.asNode().replaceAtPredecessor(null);
            PEMethodScope inlineScope = this.createMethodScope(this.graph, methodScope, loopScope, null, targetMethod, invokeData, methodScope.inliningDepth + 1, arguments);
            JavaType returnType = targetMethod.getSignature().getReturnType(methodScope.method.getDeclaringClass());
            PEAppendGraphBuilderContext graphBuilderContext = new PEAppendGraphBuilderContext(inlineScope, invokePredecessor, callTarget.invokeKind(), returnType, true, false);
            InvocationPlugins.InvocationPluginReceiver invocationPluginReceiver = new InvocationPlugins.InvocationPluginReceiver(graphBuilderContext);
            if (invocationPlugin.execute(graphBuilderContext, targetMethod, invocationPluginReceiver.init(targetMethod, arguments), arguments)) {
                if (invocationPlugin.isDecorator()) {
                    graphBuilderContext.lastInstr.setNext(invoke.asFixedNode());
                    boolean bl = false;
                    return bl;
                }
                if (!graphBuilderContext.invokeConsumed) {
                    if (graphBuilderContext.lastInstr != null) {
                        if (graphBuilderContext.lastInstr instanceof DeoptBciSupplier && !BytecodeFrame.isPlaceholderBci((int)((Invoke)invokeData.invoke).bci()) && BytecodeFrame.isPlaceholderBci((int)((DeoptBciSupplier)((Object)graphBuilderContext.lastInstr)).bci())) {
                            ((DeoptBciSupplier)((Object)graphBuilderContext.lastInstr)).setBci(((Invoke)invokeData.invoke).bci());
                        }
                        this.registerNode(loopScope, invokeData.orderId, graphBuilderContext.pushedNode, true, true);
                        invoke.asNode().replaceAtUsages(graphBuilderContext.pushedNode);
                        BeginNode begin = graphBuilderContext.lastInstr instanceof BeginNode ? (BeginNode)graphBuilderContext.lastInstr : null;
                        FixedNode afterInvoke = this.nodeAfterInvoke(methodScope, loopScope, invokeData, begin);
                        if (afterInvoke != graphBuilderContext.lastInstr) {
                            graphBuilderContext.lastInstr.setNext(afterInvoke);
                        }
                        PEGraphDecoder.deleteInvoke(invoke);
                    } else {
                        assert (graphBuilderContext.pushedNode == null) : "Why push a node when the invoke does not return anyway?";
                        invoke.asNode().replaceAtUsages(null);
                        PEGraphDecoder.deleteInvoke(invoke);
                    }
                }
                boolean bl = true;
                return bl;
            }
            invokePredecessor.setNext(invoke.asFixedNode());
            boolean bl = false;
            return bl;
        }
    }

    protected InvocationPlugin getInvocationPlugin(ResolvedJavaMethod targetMethod) {
        Object invocationPlugin = this.invocationPluginCache.computeIfAbsent(targetMethod, method -> {
            Object plugin = this.invocationPlugins.lookupInvocation(targetMethod, true, true, this.options);
            if (plugin == null) {
                plugin = CACHED_NULL_VALUE;
            }
            return plugin;
        });
        return invocationPlugin == CACHED_NULL_VALUE ? null : (InvocationPlugin)invocationPlugin;
    }

    protected GraphDecoder.LoopScope tryInline(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        try (DebugCloseable a = TryInlineTimer.start(this.debug);){
            if (!callTarget.invokeKind().isDirect()) {
                GraphDecoder.LoopScope loopScope2 = null;
                return loopScope2;
            }
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            if (targetMethod.hasNeverInlineDirective()) {
                GraphDecoder.LoopScope loopScope3 = null;
                return loopScope3;
            }
            ValueNode[] arguments = callTarget.arguments().toArray((A[])ValueNode.EMPTY_ARRAY);
            PENonAppendGraphBuilderContext graphBuilderContext = new PENonAppendGraphBuilderContext(methodScope, (Invoke)invokeData.invoke);
            for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
                InlineInvokePlugin.InlineInfo inlineInfo = plugin.shouldInlineInvoke(graphBuilderContext, targetMethod, arguments);
                if (inlineInfo == null) continue;
                if (inlineInfo.allowsInlining()) {
                    GraphDecoder.LoopScope loopScope4 = this.doInline(methodScope, loopScope, invokeData, inlineInfo, arguments);
                    return loopScope4;
                }
                GraphDecoder.LoopScope loopScope5 = null;
                return loopScope5;
            }
            InlineInvokePlugin[] inlineInvokePluginArray = null;
            return inlineInvokePluginArray;
        }
    }

    protected GraphDecoder.LoopScope doInline(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, InlineInvokePlugin.InlineInfo inlineInfo, ValueNode[] arguments) {
        FixedWithNextNode predecessor;
        if (((Invoke)invokeData.invoke).getInlineControl() != Invoke.InlineControl.Normal) {
            return null;
        }
        ResolvedJavaMethod inlineMethod = inlineInfo.getMethodToInline();
        EncodedGraph graphToInline = this.lookupEncodedGraph(inlineMethod, inlineInfo.getIntrinsicBytecodeProvider());
        if (graphToInline == null) {
            return null;
        }
        assert (!this.graph.trackNodeSourcePosition() || graphToInline.trackNodeSourcePosition()) : this.graph + " " + graphToInline;
        if (methodScope.inliningDepth > Options.InliningDepthError.getValue(this.options)) {
            throw PEGraphDecoder.tooDeepInlining(methodScope);
        }
        for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
            plugin.notifyBeforeInline(inlineMethod);
        }
        Invoke invoke = (Invoke)invokeData.invoke;
        FixedNode invokeNode = invoke.asFixedNode();
        invokeData.invokePredecessor = predecessor = (FixedWithNextNode)invokeNode.predecessor();
        invokeNode.replaceAtPredecessor(null);
        PEMethodScope inlineScope = this.createMethodScope(this.graph, methodScope, loopScope, graphToInline, inlineMethod, invokeData, methodScope.inliningDepth + 1, arguments);
        if (!inlineMethod.isStatic()) {
            if (StampTool.isPointerAlwaysNull(arguments[0])) {
                DeoptimizeNode deoptimizeNode = this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.NullCheckException));
                predecessor.setNext(deoptimizeNode);
                this.finishInlining(inlineScope);
                return loopScope;
            }
            if (!StampTool.isPointerNonNull(arguments[0])) {
                PEAppendGraphBuilderContext graphBuilderContext = new PEAppendGraphBuilderContext(inlineScope, predecessor, true);
                arguments[0] = graphBuilderContext.nullCheckedValue(arguments[0]);
                predecessor = graphBuilderContext.lastInstr;
            }
        }
        predecessor = this.afterMethodScopeCreation(inlineScope, predecessor);
        GraphDecoder.LoopScope inlineLoopScope = this.createInitialLoopScope(inlineScope, predecessor);
        int firstArgumentNodeId = inlineScope.maxFixedNodeOrderId + 1;
        for (int i = 0; i < arguments.length; ++i) {
            inlineLoopScope.createdNodes[firstArgumentNodeId + i] = arguments[i];
        }
        this.recordGraphElements(graphToInline);
        return inlineLoopScope;
    }

    protected FixedWithNextNode afterMethodScopeCreation(PEMethodScope inlineScope, FixedWithNextNode predecessor) {
        return predecessor;
    }

    @Override
    protected void afterMethodScope(GraphDecoder.MethodScope methodScope) {
        if (this.debug.isDumpEnabled(5)) {
            this.debug.dump(5, (Object)this.graph, "After PE %s", ((PEMethodScope)methodScope).method.format("%H.%n"));
        }
    }

    @Override
    protected void finishInlining(GraphDecoder.MethodScope is) {
        ValueNode returnValue;
        PEMethodScope inlineScope = (PEMethodScope)is;
        ResolvedJavaMethod inlineMethod = inlineScope.method;
        PEMethodScope methodScope = inlineScope.caller;
        GraphDecoder.LoopScope loopScope = inlineScope.callerLoopScope;
        GraphDecoder.InvokeData invokeData = inlineScope.invokeData;
        Invoke invoke = (Invoke)invokeData.invoke;
        FixedNode invokeNode = invoke.asFixedNode();
        ValueNode exceptionValue = null;
        int returnNodeCount = 0;
        int unwindNodeCount = 0;
        List returnAndUnwindNodes = inlineScope.returnAndUnwindNodes;
        for (int i = 0; i < returnAndUnwindNodes.size(); ++i) {
            FixedNode fixedNode = (FixedNode)returnAndUnwindNodes.get(i);
            if (fixedNode instanceof ReturnNode) {
                ++returnNodeCount;
                continue;
            }
            if (!fixedNode.isAlive()) continue;
            assert (fixedNode instanceof UnwindNode);
            ++unwindNodeCount;
        }
        if (unwindNodeCount > 0) {
            FixedNode unwindReplacement = invoke instanceof InvokeWithExceptionNode ? this.makeStubNode(methodScope, loopScope, invokeData.exceptionNextOrderId) : (FixedNode)this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.NotCompiledExceptionHandler));
            if (unwindNodeCount == 1) {
                UnwindNode unwindNode2 = PEGraphDecoder.getSingleMatchingNode(returnAndUnwindNodes, returnNodeCount > 0, UnwindNode.class);
                exceptionValue = unwindNode2.exception();
                unwindNode2.replaceAndDelete(unwindReplacement);
            } else {
                MergeNode unwindMergeNode = this.graph.add(new MergeNode());
                exceptionValue = InliningUtil.mergeValueProducers(unwindMergeNode, PEGraphDecoder.getMatchingNodes(returnAndUnwindNodes, returnNodeCount > 0, UnwindNode.class, unwindNodeCount), null, unwindNode -> unwindNode.exception());
                unwindMergeNode.setNext(unwindReplacement);
                this.ensureExceptionStateDecoded(inlineScope);
                unwindMergeNode.setStateAfter(inlineScope.exceptionState.duplicateModified(JavaKind.Object, JavaKind.Object, exceptionValue, null));
            }
            if (invoke instanceof InvokeWithExceptionNode) {
                assert (unwindReplacement != exceptionValue) : "Unschedulable unwind replacement";
                FixedAnchorNode anchor = this.graph.add(new FixedAnchorNode(exceptionValue));
                this.graph.addBeforeFixed(unwindReplacement, anchor);
                exceptionValue = anchor;
                assert (anchor.predecessor() != null);
            }
        }
        assert (invoke.next() == null);
        assert (!(invoke instanceof InvokeWithExceptionNode) || ((InvokeWithExceptionNode)invoke).exceptionEdge() == null);
        if (returnNodeCount == 0) {
            returnValue = null;
            invokeNode.replaceAtUsages(null);
        } else if (returnNodeCount == 1) {
            ReturnNode returnNode = PEGraphDecoder.getSingleMatchingNode(returnAndUnwindNodes, unwindNodeCount > 0, ReturnNode.class);
            returnValue = returnNode.result();
            BeginNode prevBegin = null;
            if (returnNode.predecessor() instanceof BeginNode) {
                prevBegin = (BeginNode)returnNode.predecessor();
            }
            returnAnchorPair = InliningUtil.replaceInvokeAtUsages(invokeNode, returnValue, this.nodeAfterInvoke(methodScope, loopScope, invokeData, prevBegin));
            returnValue = (ValueNode)returnAnchorPair.getLeft();
            FixedNode next = (FixedNode)returnAnchorPair.getRight();
            if (next == prevBegin) {
                returnNode.replaceAtPredecessor(null);
                returnNode.safeDelete();
            } else {
                returnNode.replaceAndDelete(next);
            }
        } else {
            AbstractMergeNode merge = this.graph.add(new MergeNode());
            merge.setStateAfter((FrameState)this.ensureNodeCreated(methodScope, loopScope, invokeData.stateAfterOrderId));
            returnValue = InliningUtil.mergeReturns(merge, PEGraphDecoder.getMatchingNodes(returnAndUnwindNodes, unwindNodeCount > 0, ReturnNode.class, returnNodeCount));
            FixedNode next = this.nodeAfterInvoke(methodScope, loopScope, invokeData, null);
            returnAnchorPair = InliningUtil.replaceInvokeAtUsages(invokeNode, returnValue, merge);
            returnValue = (ValueNode)returnAnchorPair.getLeft();
            assert (returnAnchorPair.getRight() == merge);
            merge.setNext(next);
        }
        this.registerNode(loopScope, invokeData.orderId, returnValue, true, true);
        if (invoke instanceof InvokeWithExceptionNode) {
            this.registerNode(loopScope, invokeData.exceptionOrderId, exceptionValue, true, true);
        }
        if (inlineScope.exceptionPlaceholderNode != null) {
            inlineScope.exceptionPlaceholderNode.replaceAtUsagesAndDelete(exceptionValue);
        }
        PEGraphDecoder.deleteInvoke(invoke);
        assert (exceptionValue == null || exceptionValue instanceof FixedAnchorNode && exceptionValue.predecessor() != null);
        for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
            plugin.notifyAfterInline(inlineMethod);
        }
        if (methodScope.inliningLog != null) {
            assert (inlineScope.inliningLog != null) : "all inlinees should have an inlining log if the root requires it";
            methodScope.inliningLog.inlineByTransfer(invoke, invokeData.callTarget, inlineScope.inliningLog, "PEGraphDecoder", "inlined during decoding");
        }
        if (methodScope.optimizationLog != null) {
            assert (inlineScope.optimizationLog != null) : "all inlinees should have an optimization log if the root requires it";
            methodScope.optimizationLog.inline(inlineScope.optimizationLog, false, null);
        }
    }

    private static <T> T getSingleMatchingNode(List<ControlSinkNode> returnAndUnwindNodes, boolean hasNonMatchingEntries, Class<T> clazz) {
        if (!hasNonMatchingEntries) {
            assert (returnAndUnwindNodes.size() == 1);
            return (T)returnAndUnwindNodes.get(0);
        }
        for (int i = 0; i < returnAndUnwindNodes.size(); ++i) {
            ControlSinkNode node = returnAndUnwindNodes.get(i);
            if (!clazz.isInstance(node)) continue;
            return (T)node;
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(clazz);
    }

    private static <T> List<T> getMatchingNodes(List<ControlSinkNode> returnAndUnwindNodes, boolean hasNonMatchingEntries, Class<T> clazz, int resultCount) {
        if (!hasNonMatchingEntries) {
            return returnAndUnwindNodes;
        }
        ArrayList<ControlSinkNode> result = new ArrayList<ControlSinkNode>(resultCount);
        for (int i = 0; i < returnAndUnwindNodes.size(); ++i) {
            ControlSinkNode node = returnAndUnwindNodes.get(i);
            if (!clazz.isInstance(node)) continue;
            result.add(node);
        }
        assert (result.size() == resultCount);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static RuntimeException tooDeepInlining(PEMethodScope methodScope) {
        void var5_8;
        HashMap<ResolvedJavaMethod, Integer> methodCounts = new HashMap<ResolvedJavaMethod, Integer>();
        PEMethodScope cur = methodScope;
        while (cur != null) {
            Integer oldCount = (Integer)methodCounts.get(cur.method);
            methodCounts.put(cur.method, oldCount == null ? 1 : oldCount + 1);
            cur = cur.caller;
        }
        ArrayList methods = new ArrayList(methodCounts.entrySet());
        methods.sort((e1, e2) -> -Integer.compare((Integer)e1.getValue(), (Integer)e2.getValue()));
        StringBuilder msg = new StringBuilder("Too deep inlining, probably caused by recursive inlining.").append(System.lineSeparator()).append("== Inlined methods ordered by inlining frequency:");
        for (Map.Entry entry : methods) {
            msg.append(System.lineSeparator()).append(((ResolvedJavaMethod)entry.getKey()).format("%H.%n(%p) [")).append(entry.getValue()).append("]");
        }
        msg.append(System.lineSeparator()).append("== Complete stack trace of inlined methods:");
        int lastBci = 0;
        PEMethodScope pEMethodScope = methodScope;
        while (var5_8 != null) {
            msg.append(System.lineSeparator()).append(var5_8.method.asStackTraceElement(lastBci));
            lastBci = var5_8.invokeData != null ? ((Invoke)var5_8.invokeData.invoke).bci() : 0;
            PEMethodScope pEMethodScope2 = var5_8.caller;
        }
        throw new PermanentBailoutException(msg.toString());
    }

    protected FixedNode nodeAfterInvoke(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, BeginNode prevBegin) {
        assert (prevBegin == null || prevBegin.isAlive());
        if (invokeData.invoke instanceof InvokeWithExceptionNode && prevBegin != null && this.getNodeClass(methodScope, loopScope, invokeData.nextOrderId) == prevBegin.getNodeClass()) {
            loopScope.nodesToProcess.set(invokeData.nextOrderId);
            this.registerNode(loopScope, invokeData.nextOrderId, prevBegin, false, false);
            return prevBegin;
        }
        return this.makeStubNode(methodScope, loopScope, invokeData.nextOrderId);
    }

    private static void deleteInvoke(Invoke invoke) {
        FrameState frameState = invoke.stateAfter();
        invoke.asNode().safeDelete();
        assert (invoke.callTarget() == null) : "must not have been added to the graph yet";
        if (frameState != null && frameState.hasNoUsages()) {
            frameState.safeDelete();
        }
    }

    protected abstract EncodedGraph lookupEncodedGraph(ResolvedJavaMethod var1, BytecodeProvider var2);

    @Override
    protected Node canonicalizeFixedNode(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, Node originalNode) {
        PENonAppendGraphBuilderContext graphBuilderContext;
        Node node;
        PEMethodScope methodScope = (PEMethodScope)s;
        Node replacedNode = node = originalNode;
        if (this.nodePlugins != null && this.nodePlugins.length > 0) {
            if (node instanceof LoadFieldNode) {
                LoadFieldNode loadFieldNode = (LoadFieldNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, loadFieldNode);
                field = loadFieldNode.field();
                if (loadFieldNode.isStatic()) {
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleLoadStaticField(graphBuilderContext, field)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                } else {
                    ValueNode object = loadFieldNode.object();
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleLoadField(graphBuilderContext, object, field)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                }
            } else if (node instanceof StoreFieldNode) {
                StoreFieldNode storeFieldNode = (StoreFieldNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, storeFieldNode);
                field = storeFieldNode.field();
                if (storeFieldNode.isStatic()) {
                    ValueNode value = storeFieldNode.value();
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleStoreStaticField(graphBuilderContext, field, value)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                } else {
                    ValueNode object = storeFieldNode.object();
                    ValueNode value = storeFieldNode.value();
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleStoreField(graphBuilderContext, object, field, value)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                }
            } else if (node instanceof LoadIndexedNode) {
                LoadIndexedNode loadIndexedNode = (LoadIndexedNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, loadIndexedNode);
                array = loadIndexedNode.array();
                ValueNode index = loadIndexedNode.index();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleLoadIndexed(graphBuilderContext, array, index, loadIndexedNode.getBoundsCheck(), loadIndexedNode.elementKind())) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof StoreIndexedNode) {
                StoreIndexedNode storeIndexedNode = (StoreIndexedNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, storeIndexedNode);
                array = storeIndexedNode.array();
                ValueNode index = storeIndexedNode.index();
                ValueNode value = storeIndexedNode.value();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleStoreIndexed(graphBuilderContext, array, index, storeIndexedNode.getBoundsCheck(), storeIndexedNode.getStoreCheck(), storeIndexedNode.elementKind(), value)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof NewInstanceNode) {
                NewInstanceNode newInstanceNode = (NewInstanceNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, newInstanceNode);
                ResolvedJavaType type = newInstanceNode.instanceClass();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleNewInstance(graphBuilderContext, type)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof NewArrayNode) {
                newArrayNode = (NewArrayNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, newArrayNode);
                elementType = ((NewArrayNode)newArrayNode).elementType();
                ValueNode length = ((AbstractNewArrayNode)newArrayNode).length();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleNewArray(graphBuilderContext, elementType, length)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof NewMultiArrayNode) {
                newArrayNode = (NewMultiArrayNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, newArrayNode);
                elementType = ((NewMultiArrayNode)newArrayNode).type();
                ValueNode[] dimensions = ((NewMultiArrayNode)newArrayNode).dimensions().toArray((A[])ValueNode.EMPTY_ARRAY);
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleNewMultiArray(graphBuilderContext, elementType, dimensions)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            }
        }
        if (node instanceof PluginReplacementInterface) {
            PluginReplacementInterface pluginReplacementNode = (PluginReplacementInterface)((Object)node);
            graphBuilderContext = new PEPluginGraphBuilderContext(methodScope, pluginReplacementNode.asFixedNode());
            boolean success = pluginReplacementNode.replace(graphBuilderContext, this.providers.getReplacements());
            if (success) {
                replacedNode = graphBuilderContext.pushedNode;
            } else if (this.pluginReplacementMustSucceed()) {
                throw new GraalError("Plugin failed:" + node);
            }
        }
        return super.canonicalizeFixedNode(methodScope, loopScope, replacedNode);
    }

    protected boolean pluginReplacementMustSucceed() {
        return false;
    }

    @Override
    protected Node handleFloatingNodeBeforeAdd(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, Node n) {
        PEMethodScope methodScope = (PEMethodScope)s;
        Node node = n;
        if (node instanceof ParameterNode) {
            ParameterNode param = (ParameterNode)node;
            if (methodScope.isInlinedMethod()) {
                throw GraalError.shouldNotReachHere("Parameter nodes are already registered when the inlined scope is created");
            }
            if (this.parameterPlugin != null) {
                assert (!methodScope.isInlinedMethod());
                PENonAppendGraphBuilderContext graphBuilderContext = new PENonAppendGraphBuilderContext(methodScope, null);
                FloatingNode result = this.parameterPlugin.interceptParameter(graphBuilderContext, param.index(), StampPair.create(param.stamp(NodeView.DEFAULT), param.uncheckedStamp()));
                if (result != null) {
                    return result;
                }
            }
            node = param.copyWithInputs();
        }
        return super.handleFloatingNodeBeforeAdd(methodScope, loopScope, node);
    }

    protected void ensureOuterStateDecoded(PEMethodScope methodScope) {
        if (methodScope.outerState == null && methodScope.caller != null) {
            FrameState stateAtReturn = ((Invoke)methodScope.invokeData.invoke).stateAfter();
            if (stateAtReturn == null) {
                stateAtReturn = (FrameState)this.decodeFloatingNode(methodScope.caller, methodScope.callerLoopScope, methodScope.invokeData.stateAfterOrderId);
            }
            JavaKind invokeReturnKind = ((Invoke)methodScope.invokeData.invoke).asNode().getStackKind();
            FrameState outerState = stateAtReturn.duplicateModified(this.graph, ((Invoke)methodScope.invokeData.invoke).bci(), stateAtReturn.rethrowException(), true, invokeReturnKind, null, null, null);
            if (outerState.outerFrameState() == null && methodScope.caller != null) {
                this.ensureOuterStateDecoded(methodScope.caller);
                outerState.setOuterFrameState(methodScope.caller.outerState);
            }
            if (outerState.outerFrameState() != null && this.shouldOmitIntermediateMethodInStates(outerState.getMethod())) {
                outerState = outerState.outerFrameState();
            }
            methodScope.outerState = outerState;
        }
    }

    protected boolean shouldOmitIntermediateMethodInStates(ResolvedJavaMethod method) {
        return false;
    }

    protected void ensureStateAfterDecoded(PEMethodScope methodScope) {
        if (((Invoke)methodScope.invokeData.invoke).stateAfter() == null) {
            ((Invoke)methodScope.invokeData.invoke).setStateAfter((FrameState)this.ensureNodeCreated(methodScope.caller, methodScope.callerLoopScope, methodScope.invokeData.stateAfterOrderId));
        }
    }

    protected void ensureExceptionStateDecoded(PEMethodScope methodScope) {
        if (methodScope.exceptionState == null && methodScope.caller != null && methodScope.invokeData.invoke instanceof InvokeWithExceptionNode) {
            this.ensureStateAfterDecoded(methodScope);
            assert (methodScope.exceptionPlaceholderNode == null);
            methodScope.exceptionPlaceholderNode = this.graph.add(new ExceptionPlaceholderNode());
            this.registerNode(methodScope.callerLoopScope, methodScope.invokeData.exceptionOrderId, methodScope.exceptionPlaceholderNode, false, false);
            FrameState exceptionState = (FrameState)this.ensureNodeCreated(methodScope.caller, methodScope.callerLoopScope, methodScope.invokeData.exceptionStateOrderId);
            if (exceptionState.outerFrameState() == null && methodScope.caller != null) {
                this.ensureOuterStateDecoded(methodScope.caller);
                exceptionState.setOuterFrameState(methodScope.caller.outerState);
            }
            methodScope.exceptionState = exceptionState;
        }
    }

    @Override
    protected Node handleFloatingNodeAfterAdd(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, Node node) {
        PEMethodScope methodScope = (PEMethodScope)s;
        if (methodScope.isInlinedMethod()) {
            if (node instanceof FrameState) {
                FrameState frameState = (FrameState)node;
                this.ensureOuterStateDecoded(methodScope);
                if (frameState.bci < 0) {
                    this.ensureExceptionStateDecoded(methodScope);
                }
                List<ValueNode> invokeArgsList = null;
                if (frameState.bci == -2) {
                    invokeArgsList = Arrays.asList(methodScope.arguments);
                }
                return InliningUtil.processFrameState(frameState, (Invoke)methodScope.invokeData.invoke, null, methodScope.method, methodScope.exceptionState, methodScope.outerState, true, methodScope.method, invokeArgsList);
            }
            if (node instanceof MonitorIdNode) {
                this.ensureOuterStateDecoded(methodScope);
                InliningUtil.processMonitorId(methodScope.outerState, (MonitorIdNode)node);
                return node;
            }
        }
        return node;
    }

    protected class PEMethodScope
    extends GraphDecoder.MethodScope {
        public final PEMethodScope caller;
        public final ResolvedJavaMethod method;
        public final GraphDecoder.InvokeData invokeData;
        public final int inliningDepth;
        protected final ValueNode[] arguments;
        private SourceLanguagePosition sourceLanguagePosition;
        protected FrameState outerState;
        protected FrameState exceptionState;
        public ExceptionPlaceholderNode exceptionPlaceholderNode;
        protected NodeSourcePosition callerBytecodePosition;

        protected PEMethodScope(StructuredGraph targetGraph, PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
            super(callerLoopScope, targetGraph, encodedGraph, PEGraphDecoder.loopExplosionKind(method, PEGraphDecoder.this.loopExplosionPlugin));
            this.caller = caller;
            this.method = method;
            this.invokeData = invokeData;
            this.inliningDepth = inliningDepth;
            this.arguments = arguments;
            if (PEGraphDecoder.this.sourceLanguagePositionProvider != null) {
                this.sourceLanguagePosition = UnresolvedSourceLanguagePosition.INSTANCE;
            }
        }

        @Override
        public boolean isInlinedMethod() {
            return this.caller != null;
        }

        public ValueNode[] getArguments() {
            return this.arguments;
        }

        public StackTraceElement[] getCallStack() {
            StackTraceElement[] stack = new StackTraceElement[this.inliningDepth + 1];
            PEMethodScope frame = this;
            int index = 0;
            int bci = -1;
            while (frame != null) {
                stack[index++] = frame.method.asStackTraceElement(bci);
                bci = frame.invokeData == null ? 0 : ((Invoke)frame.invokeData.invoke).bci();
                frame = frame.caller;
            }
            assert (index == stack.length) : index + " != " + stack.length;
            return stack;
        }

        @Override
        public NodeSourcePosition getCallerNodeSourcePosition() {
            NodeSourcePosition callerPosition = this.resolveCallerBytecodePosition();
            if (callerPosition == null) {
                return null;
            }
            SourceLanguagePosition pos = this.resolveSourceLanguagePosition();
            if (pos != null) {
                return new NodeSourcePosition(pos, callerPosition.getCaller(), callerPosition.getMethod(), callerPosition.getBCI());
            }
            return this.callerBytecodePosition;
        }

        @Override
        public NodeSourcePosition getNodeSourcePosition(NodeSourcePosition original) {
            assert (original != null) : "Unexpected null value";
            NodeSourcePosition callerPosition = this.resolveCallerBytecodePosition();
            if (callerPosition == null) {
                return original;
            }
            return original.addCaller(this.resolveSourceLanguagePosition(), this.callerBytecodePosition);
        }

        private NodeSourcePosition resolveCallerBytecodePosition() {
            if (this.caller == null) {
                return null;
            }
            if (this.callerBytecodePosition == null) {
                NodeSourcePosition invokePosition = ((Invoke)this.invokeData.invoke).asNode().getNodeSourcePosition();
                if (invokePosition == null) {
                    return null;
                }
                if (invokePosition.getCaller() != null && PEGraphDecoder.this.shouldOmitIntermediateMethodInStates(invokePosition.getMethod())) {
                    invokePosition = invokePosition.getCaller();
                }
                this.callerBytecodePosition = invokePosition;
            }
            return this.callerBytecodePosition;
        }

        private SourceLanguagePosition resolveSourceLanguagePosition() {
            SourceLanguagePosition res = this.sourceLanguagePosition;
            if (res == UnresolvedSourceLanguagePosition.INSTANCE) {
                res = null;
                if (this.arguments != null && this.method.hasReceiver() && this.arguments.length > 0 && this.arguments[0].isJavaConstant()) {
                    JavaConstant constantArgument = this.arguments[0].asJavaConstant();
                    res = PEGraphDecoder.this.sourceLanguagePositionProvider.getPosition(constantArgument);
                }
                this.sourceLanguagePosition = res;
            }
            return res;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.method.format("%H.%n(%p)") + "]";
        }
    }

    @NodeInfo(allowedUsageTypes={InputType.Anchor, InputType.Guard, InputType.Value}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    static final class FixedAnchorNode
    extends FixedWithNextNode
    implements AnchoringNode,
    GuardingNode,
    IterableNodeType {
        public static final NodeClass<FixedAnchorNode> TYPE = NodeClass.create(FixedAnchorNode.class);
        @Node.Input
        ValueNode value;

        protected FixedAnchorNode(ValueNode value) {
            super((NodeClass<? extends FixedWithNextNode>)TYPE, value.stamp(NodeView.DEFAULT));
            this.value = value;
        }
    }

    public static class Options {
        public static final OptionKey<Integer> InliningDepthError = new OptionKey<Integer>(1000);
        public static final OptionKey<Integer> MaximumLoopExplosionCount = new OptionKey<Integer>(10000);
        public static final OptionKey<Boolean> FailedLoopExplosionIsFatal = new OptionKey<Boolean>(false);
    }

    protected class PENonAppendGraphBuilderContext
    extends CoreProvidersDelegate
    implements GraphBuilderContext {
        public final PEMethodScope methodScope;
        protected final Invoke invoke;

        @Override
        public GraphBuilderContext.ExternalInliningContext getExternalInliningContext() {
            return new GraphBuilderContext.ExternalInliningContext(){

                @Override
                public int getInlinedDepth() {
                    int count = 0;
                    PEMethodScope scope = PENonAppendGraphBuilderContext.this.methodScope;
                    while (scope != null) {
                        if (scope.method.equals(PEGraphDecoder.this.peRootForInlining)) {
                            ++count;
                        }
                        scope = scope.caller;
                    }
                    return count;
                }
            };
        }

        public PENonAppendGraphBuilderContext(PEMethodScope methodScope, Invoke invoke) {
            super(PEGraphDecoder.this.providers);
            this.methodScope = methodScope;
            this.invoke = invoke;
        }

        @Override
        public boolean needsExplicitException() {
            return PEGraphDecoder.this.needsExplicitException;
        }

        @Override
        public boolean isParsingInvocationPlugin() {
            return false;
        }

        @Override
        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.isGeneratedFromFoldOrNodeIntrinsic();
        }

        @Override
        public BailoutException bailout(String string) {
            PermanentBailoutException bailout = new PermanentBailoutException(string);
            throw GraphUtil.createBailoutException(string, (Throwable)((Object)bailout), this.methodScope.getCallStack());
        }

        @Override
        public StructuredGraph getGraph() {
            return PEGraphDecoder.this.graph;
        }

        @Override
        public int getDepth() {
            return this.methodScope.inliningDepth;
        }

        @Override
        public int recursiveInliningDepth(ResolvedJavaMethod method) {
            int result = 0;
            PEMethodScope cur = this.methodScope;
            while (cur != null) {
                if (method.equals(cur.method)) {
                    ++result;
                }
                cur = cur.caller;
            }
            return result;
        }

        @Override
        public IntrinsicContext getIntrinsic() {
            return PEGraphDecoder.this.getIntrinsic();
        }

        @Override
        public <T extends Node> T append(T value) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public void push(JavaKind kind, ValueNode value) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public Invokable handleReplacedInvoke(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, boolean inlineEverything) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public void handleReplacedInvoke(CallTargetNode callTarget, JavaKind resultType) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public void setStateAfter(StateSplit stateSplit) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public GraphBuilderContext getParent() {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public Bytecode getCode() {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public ResolvedJavaMethod getMethod() {
            if (this.isParsingInvocationPlugin()) {
                return this.methodScope.caller.method;
            }
            return this.methodScope.method;
        }

        @Override
        public int bci() {
            return this.invoke.bci();
        }

        @Override
        public CallTargetNode.InvokeKind getInvokeKind() {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public JavaType getInvokeReturnType() {
            throw GraalError.unimplementedOverride();
        }

        public String toString() {
            Formatter fmt = new Formatter();
            fmt.format("Decoding %s", this.methodScope.method.format("%H.%n(%p)"));
            for (StackTraceElement e : this.methodScope.getCallStack()) {
                fmt.format("%n\tat %s", e);
            }
            return fmt.toString();
        }
    }

    public static class SpecialCallTargetCacheKey {
        private final CallTargetNode.InvokeKind invokeKind;
        private final ResolvedJavaMethod targetMethod;
        private final ResolvedJavaType contextType;
        private final Stamp receiverStamp;

        public SpecialCallTargetCacheKey(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ResolvedJavaType contextType, Stamp receiverStamp) {
            this.invokeKind = invokeKind;
            this.targetMethod = targetMethod;
            this.contextType = contextType;
            this.receiverStamp = receiverStamp;
        }

        public int hashCode() {
            return this.invokeKind.hashCode() ^ this.targetMethod.hashCode() ^ this.contextType.hashCode() ^ this.receiverStamp.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SpecialCallTargetCacheKey) {
                SpecialCallTargetCacheKey key = (SpecialCallTargetCacheKey)obj;
                return key.invokeKind.equals((Object)this.invokeKind) && key.targetMethod.equals(this.targetMethod) && key.contextType.equals(this.contextType) && key.receiverStamp.equals(this.receiverStamp);
            }
            return false;
        }
    }

    protected class PEAppendGraphBuilderContext
    extends PENonAppendGraphBuilderContext {
        protected FixedWithNextNode lastInstr;
        protected ValueNode pushedNode;
        protected boolean invokeConsumed;
        protected boolean exceptionEdgeConsumed;
        protected final CallTargetNode.InvokeKind invokeKind;
        protected final JavaType invokeReturnType;
        protected final boolean parsingInvocationPlugin;
        protected final boolean unwindExceptions;

        public PEAppendGraphBuilderContext(PEMethodScope inlineScope, FixedWithNextNode lastInstr, boolean unwindExceptions) {
            this(inlineScope, lastInstr, null, null, false, unwindExceptions);
        }

        public PEAppendGraphBuilderContext(PEMethodScope inlineScope, FixedWithNextNode lastInstr) {
            this(inlineScope, lastInstr, null, null, false, false);
        }

        public PEAppendGraphBuilderContext(PEMethodScope inlineScope, FixedWithNextNode lastInstr, CallTargetNode.InvokeKind invokeKind, JavaType invokeReturnType, boolean parsingInvocationPlugin, boolean unwindExceptions) {
            super(inlineScope, inlineScope.invokeData != null ? (Invoke)inlineScope.invokeData.invoke : null);
            this.lastInstr = lastInstr;
            this.invokeKind = invokeKind;
            this.invokeReturnType = invokeReturnType;
            this.parsingInvocationPlugin = parsingInvocationPlugin;
            this.unwindExceptions = unwindExceptions;
        }

        @Override
        public boolean isParsingInvocationPlugin() {
            return this.parsingInvocationPlugin;
        }

        @Override
        public void push(JavaKind kind, ValueNode value) {
            if (this.pushedNode != null) {
                throw GraalError.unimplemented("Only one push is supported");
            }
            this.pushedNode = value;
        }

        @Override
        public void setStateAfter(StateSplit stateSplit) {
            Node stateAfter = PEGraphDecoder.this.decodeFloatingNode(this.methodScope.caller, this.methodScope.callerLoopScope, this.methodScope.invokeData.stateAfterOrderId);
            this.getGraph().add(stateAfter);
            FrameState fs = (FrameState)PEGraphDecoder.this.handleFloatingNodeAfterAdd(this.methodScope.caller, this.methodScope.callerLoopScope, stateAfter);
            stateSplit.setStateAfter(fs);
        }

        @Override
        public <T extends Node> T append(T v) {
            if (v.graph() != null) {
                return v;
            }
            try (DebugCloseable position = this.withNodeSourcePosition();){
                T added = this.getGraph().addOrUniqueWithInputs(v);
                if (added == v) {
                    this.updateLastInstruction(v);
                }
                T t = added;
                return t;
            }
        }

        @Override
        public Node canonicalizeAndAdd(Node node) {
            Node canonicalized = node;
            if (canonicalized instanceof FixedNode) {
                FixedNode fixedNode = (FixedNode)canonicalized;
                canonicalized = PEGraphDecoder.this.canonicalizeFixedNode(this.methodScope, null, fixedNode);
            } else if (canonicalized instanceof FloatingNode) {
                FloatingNode floatingNode = (FloatingNode)canonicalized;
                canonicalized = PEGraphDecoder.this.handleFloatingNodeBeforeAdd(this.methodScope, null, floatingNode);
            }
            if (canonicalized == null) {
                return null;
            }
            return super.canonicalizeAndAdd(canonicalized);
        }

        private DebugCloseable withNodeSourcePosition() {
            NodeSourcePosition callerBytecodePosition;
            if (this.getGraph().trackNodeSourcePosition() && (callerBytecodePosition = this.methodScope.getCallerNodeSourcePosition()) != null) {
                return this.getGraph().withNodeSourcePosition(callerBytecodePosition);
            }
            return null;
        }

        private <T extends Node> void updateLastInstruction(T v) {
            if (v instanceof FixedNode) {
                FixedNode fixedNode = (FixedNode)v;
                if (this.lastInstr != null) {
                    FixedNode oldNext = this.lastInstr.next();
                    this.lastInstr.setNext(fixedNode);
                    if (oldNext != null) {
                        GraalError.guarantee(fixedNode instanceof ControlSinkNode, "deleting the old next instruction is only implemented when the new instruction ends the control flow.");
                        oldNext.safeDelete();
                    }
                }
                if (fixedNode instanceof FixedWithNextNode) {
                    FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)fixedNode;
                    this.lastInstr = fixedWithNextNode.next() == null ? fixedWithNextNode : null;
                } else if (fixedNode instanceof WithExceptionNode) {
                    if (this.exceptionEdgeConsumed) {
                        throw GraalError.unimplemented("Only one node can consume the exception edge");
                    }
                    this.exceptionEdgeConsumed = true;
                    WithExceptionNode withExceptionNode = (WithExceptionNode)fixedNode;
                    if (withExceptionNode.exceptionEdge() == null) {
                        ExceptionObjectNode exceptionEdge = (ExceptionObjectNode)PEGraphDecoder.this.makeStubNode(this.methodScope.caller, this.methodScope.callerLoopScope, this.methodScope.invokeData.exceptionOrderId);
                        withExceptionNode.setExceptionEdge(exceptionEdge);
                    }
                    if (withExceptionNode.next() == null) {
                        AbstractBeginNode nextBegin = PEGraphDecoder.this.graph.add(new BeginNode());
                        withExceptionNode.setNext(nextBegin);
                        this.lastInstr = nextBegin;
                    } else {
                        this.lastInstr = null;
                    }
                } else {
                    assert (fixedNode instanceof AbstractEndNode || fixedNode instanceof ControlSinkNode || fixedNode instanceof ControlSplitNode) : fixedNode;
                    this.lastInstr = null;
                }
            }
        }

        @Override
        public CallTargetNode.InvokeKind getInvokeKind() {
            if (this.invokeKind != null) {
                return this.invokeKind;
            }
            return super.getInvokeKind();
        }

        @Override
        public JavaType getInvokeReturnType() {
            if (this.invokeReturnType != null) {
                return this.invokeReturnType;
            }
            return super.getInvokeReturnType();
        }

        @Override
        public void handleReplacedInvoke(CallTargetNode callTarget, JavaKind resultType) {
            if (this.invokeConsumed || this.exceptionEdgeConsumed) {
                throw GraalError.unimplemented("handleReplacedInvoke can be called only once, and also consumes the exception edge");
            }
            this.invokeConsumed = true;
            this.exceptionEdgeConsumed = true;
            PEGraphDecoder.this.appendInvoke(this.methodScope.caller, this.methodScope.callerLoopScope, this.methodScope.invokeData, callTarget);
            this.lastInstr.setNext(this.invoke.asFixedNode());
            this.lastInstr = this.invoke instanceof InvokeWithExceptionNode ? ((InvokeWithExceptionNode)this.invoke).next() : (InvokeNode)this.invoke;
        }

        @Override
        public AbstractBeginNode genExplicitExceptionEdge(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... exceptionArguments) {
            BytecodeExceptionNode exceptionNode = PEGraphDecoder.this.graph.add(new BytecodeExceptionNode(this.getMetaAccess(), exceptionKind, exceptionArguments));
            PEGraphDecoder.this.ensureExceptionStateDecoded(this.methodScope);
            exceptionNode.setNodeSourcePosition(this.methodScope.callerBytecodePosition);
            if (this.unwindExceptions) {
                FrameState exceptionState = this.methodScope.exceptionState.duplicateModified(JavaKind.Object, JavaKind.Object, exceptionNode, null);
                exceptionNode.setStateAfter(exceptionState);
                UnwindNode unwind = PEGraphDecoder.this.graph.add(new UnwindNode(exceptionNode));
                exceptionNode.setNext(unwind);
                this.methodScope.returnAndUnwindNodes.add(unwind);
            } else {
                exceptionNode.setStateAfter(this.methodScope.exceptionState);
                if (this.exceptionEdgeConsumed) {
                    throw GraalError.unimplemented("Only one node can consume the exception edge");
                }
                this.exceptionEdgeConsumed = true;
                this.methodScope.exceptionPlaceholderNode.replaceAtUsagesAndDelete(exceptionNode);
                PEGraphDecoder.this.registerNode(this.methodScope.callerLoopScope, this.methodScope.invokeData.exceptionOrderId, exceptionNode, true, false);
                exceptionNode.setNext(PEGraphDecoder.this.makeStubNode(this.methodScope.caller, this.methodScope.callerLoopScope, this.methodScope.invokeData.exceptionNextOrderId));
            }
            return BeginNode.begin(exceptionNode);
        }

        @Override
        public GraphBuilderContext getNonIntrinsicAncestor() {
            return null;
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, allowedUsageTypes={InputType.Value, InputType.Guard, InputType.Anchor})
    public static class ExceptionPlaceholderNode
    extends ValueNode {
        public static final NodeClass<ExceptionPlaceholderNode> TYPE = NodeClass.create(ExceptionPlaceholderNode.class);

        protected ExceptionPlaceholderNode() {
            super(TYPE, StampFactory.object());
        }
    }

    protected class PEPluginGraphBuilderContext
    extends PENonAppendGraphBuilderContext {
        protected final FixedNode insertBefore;
        protected ValueNode pushedNode;

        public PEPluginGraphBuilderContext(PEMethodScope inlineScope, FixedNode insertBefore) {
            super(inlineScope, inlineScope.invokeData != null ? (Invoke)inlineScope.invokeData.invoke : null);
            this.insertBefore = insertBefore;
        }

        @Override
        public void push(JavaKind kind, ValueNode value) {
            if (this.pushedNode != null) {
                throw GraalError.unimplemented("Only one push is supported");
            }
            this.pushedNode = value;
        }

        @Override
        public void setStateAfter(StateSplit sideEffect) {
            assert (sideEffect.hasSideEffect());
            FrameState stateAfter = this.getGraph().add(new FrameState(-2));
            sideEffect.setStateAfter(stateAfter);
        }

        @Override
        public <T extends Node> T append(T v) {
            if (v.graph() != null) {
                return v;
            }
            try (DebugCloseable position = this.withNodeSourcePosition();){
                T added = this.getGraph().addOrUniqueWithInputs(v);
                if (added == v) {
                    this.updateLastInstruction(v);
                }
                T t = added;
                return t;
            }
        }

        private DebugCloseable withNodeSourcePosition() {
            NodeSourcePosition callerNodeSourcePosition;
            if (this.getGraph().trackNodeSourcePosition() && (callerNodeSourcePosition = this.methodScope.getCallerNodeSourcePosition()) != null) {
                return this.getGraph().withNodeSourcePosition(callerNodeSourcePosition);
            }
            return null;
        }

        private <T extends Node> void updateLastInstruction(T value) {
            if (value instanceof FixedWithNextNode) {
                FixedWithNextNode fixed = (FixedWithNextNode)value;
                PEGraphDecoder.this.graph.addBeforeFixed(this.insertBefore, fixed);
            } else if (value instanceof WithExceptionNode) {
                WithExceptionNode withExceptionNode = (WithExceptionNode)value;
                GraalError.guarantee(this.insertBefore instanceof WithExceptionNode, "Cannot replace %s with %s which is a %s", (Object)this.insertBefore, value, (Object)WithExceptionNode.class.getSimpleName());
                WithExceptionNode replacee = (WithExceptionNode)this.insertBefore;
                PEGraphDecoder.this.graph.replaceWithExceptionSplit(replacee, withExceptionNode);
                AbstractBeginNode next = withExceptionNode.next();
                if (MemoryKill.isMemoryKill(withExceptionNode)) {
                    GraalError.guarantee(next instanceof BeginNode, "Not a BeginNode %s", (Object)next);
                    AbstractBeginNode beginNode = PEGraphDecoder.this.graph.add(new BeginNode());
                    withExceptionNode.setNext(beginNode);
                    beginNode.setNext(next);
                }
            } else if (value instanceof FixedNode) {
                throw GraalError.shouldNotReachHere(String.format("value: %s, insertBefore: %s", value, this.insertBefore));
            }
        }
    }

    private static final class UnresolvedSourceLanguagePosition
    implements SourceLanguagePosition {
        static final SourceLanguagePosition INSTANCE = new UnresolvedSourceLanguagePosition();

        private UnresolvedSourceLanguagePosition() {
        }

        @Override
        public String toShortString() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public int getOffsetEnd() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public int getOffsetStart() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public int getLineNumber() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public URI getURI() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public String getLanguage() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public int getNodeId() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public String getNodeClassName() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }
    }
}

