/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.BitScanReverseNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class BitScanForwardNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<BitScanForwardNode> TYPE = NodeClass.create(BitScanForwardNode.class);

    public BitScanForwardNode(ValueNode value) {
        super(TYPE, StampFactory.forInteger(JavaKind.Int, 0L, ((PrimitiveStamp)value.stamp(NodeView.DEFAULT)).getBits()), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        int max;
        int min;
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        long mask = CodeUtil.mask((int)valueStamp.getBits());
        int firstAlwaysSetBit = BitScanForwardNode.scan(valueStamp.mustBeSet() & mask);
        int firstMaybeSetBit = BitScanForwardNode.scan(valueStamp.mayBeSet() & mask);
        if (firstAlwaysSetBit == -1) {
            int lastMaybeSetBit = BitScanReverseNode.scan(valueStamp.mayBeSet() & mask);
            min = firstMaybeSetBit;
            max = lastMaybeSetBit;
        } else {
            min = firstMaybeSetBit;
            max = firstAlwaysSetBit;
        }
        return StampFactory.forInteger(JavaKind.Int, min, max);
    }

    public static ValueNode tryFold(ValueNode value) {
        JavaConstant c;
        if (value.isConstant() && (c = value.asJavaConstant()).asLong() != 0L) {
            return ConstantNode.forInt(value.getStackKind() == JavaKind.Int ? BitScanForwardNode.scan(c.asInt()) : BitScanForwardNode.scan(c.asLong()));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = BitScanForwardNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    public static int scan(long v) {
        if (v == 0L) {
            return -1;
        }
        return Long.numberOfTrailingZeros(v);
    }

    public static int scan(int v) {
        return BitScanForwardNode.scan(0xFFFFFFFFL & (long)v);
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitBitScanForward(builder.operand(this.getValue())));
    }
}

