/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.nodes.CalcStringAttributesNode;
import org.graalvm.compiler.replacements.nodes.ForeignCalls;

public final class CalcStringAttributesForeignCalls {
    private static final ForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_LATIN1 = CalcStringAttributesForeignCalls.foreignCallDescriptor("calcStringAttributesLatin1", Integer.TYPE);
    private static final ForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_BMP = CalcStringAttributesForeignCalls.foreignCallDescriptor("calcStringAttributesBMP", Integer.TYPE);
    private static final ForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF8_VALID = CalcStringAttributesForeignCalls.foreignCallDescriptor("calcStringAttributesUTF8Valid", Long.TYPE);
    private static final ForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF8_UNKNOWN = CalcStringAttributesForeignCalls.foreignCallDescriptor("calcStringAttributesUTF8Unknown", Long.TYPE);
    private static final ForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF16_VALID = CalcStringAttributesForeignCalls.foreignCallDescriptor("calcStringAttributesUTF16Valid", Long.TYPE);
    private static final ForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF16_UNKNOWN = CalcStringAttributesForeignCalls.foreignCallDescriptor("calcStringAttributesUTF16Unknown", Long.TYPE);
    private static final ForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF32 = CalcStringAttributesForeignCalls.foreignCallDescriptor("calcStringAttributesUTF32", Integer.TYPE);
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{STUB_CALC_STRING_ATTRIBUTES_LATIN1, STUB_CALC_STRING_ATTRIBUTES_BMP, STUB_CALC_STRING_ATTRIBUTES_UTF8_VALID, STUB_CALC_STRING_ATTRIBUTES_UTF8_UNKNOWN, STUB_CALC_STRING_ATTRIBUTES_UTF16_VALID, STUB_CALC_STRING_ATTRIBUTES_UTF16_UNKNOWN, STUB_CALC_STRING_ATTRIBUTES_UTF32};

    private static ForeignCallDescriptor foreignCallDescriptor(String name, Class<?> resultType) {
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, resultType, Object.class, Long.TYPE, Integer.TYPE);
    }

    public static ForeignCallDescriptor getStub(CalcStringAttributesNode node) {
        switch (node.getOp()) {
            case LATIN1: {
                return STUB_CALC_STRING_ATTRIBUTES_LATIN1;
            }
            case BMP: {
                return STUB_CALC_STRING_ATTRIBUTES_BMP;
            }
            case UTF_8: {
                if (node.isAssumeValid()) {
                    return STUB_CALC_STRING_ATTRIBUTES_UTF8_VALID;
                }
                return STUB_CALC_STRING_ATTRIBUTES_UTF8_UNKNOWN;
            }
            case UTF_16: {
                if (node.isAssumeValid()) {
                    return STUB_CALC_STRING_ATTRIBUTES_UTF16_VALID;
                }
                return STUB_CALC_STRING_ATTRIBUTES_UTF16_UNKNOWN;
            }
            case UTF_32: {
                return STUB_CALC_STRING_ATTRIBUTES_UTF32;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)node.getOp());
    }
}

