/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.replacements.nodes.CalcStringAttributesNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.MacroWithExceptionNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class CalcStringAttributesMacroNode
extends MacroWithExceptionNode
implements Canonicalizable {
    public static final NodeClass<CalcStringAttributesMacroNode> TYPE = NodeClass.create(CalcStringAttributesMacroNode.class);
    private final LIRGeneratorTool.CalcStringAttributesEncoding encoding;
    private final boolean assumeValid;
    private final LocationIdentity locationIdentity;

    public CalcStringAttributesMacroNode(MacroNode.MacroParams p, LIRGeneratorTool.CalcStringAttributesEncoding encoding, boolean assumeValid, LocationIdentity locationIdentity) {
        this(TYPE, p, encoding, assumeValid, locationIdentity);
    }

    public CalcStringAttributesMacroNode(NodeClass<? extends MacroWithExceptionNode> c, MacroNode.MacroParams p, LIRGeneratorTool.CalcStringAttributesEncoding encoding, boolean assumeValid, LocationIdentity locationIdentity) {
        super(c, p);
        this.encoding = encoding;
        this.assumeValid = assumeValid;
        this.locationIdentity = locationIdentity;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        boolean intrinsifiable;
        Architecture arch = tool.getLowerer().getTarget().arch;
        boolean bl = intrinsifiable = arch instanceof AMD64 && ((AMD64)arch).getFeatures().containsAll(CalcStringAttributesNode.minFeaturesAMD64()) || arch instanceof AArch64 && ((AArch64)arch).getFeatures().containsAll(CalcStringAttributesNode.minFeaturesAARCH64());
        if (intrinsifiable) {
            return new CalcStringAttributesNode(this.getArgument(1), this.getArgument(2), this.getArgument(3), this.encoding, this.assumeValid, this.locationIdentity);
        }
        return this;
    }
}

