/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNodeInterface;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.GuardLoweringPhase;
import org.graalvm.compiler.phases.common.HighTierLoweringPhase;
import org.graalvm.compiler.phases.common.LowTierLoweringPhase;
import org.graalvm.compiler.phases.common.MidTierLoweringPhase;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import org.graalvm.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;

public interface MacroInvokable
extends Invokable,
Lowerable,
StateSplit,
SingleMemoryKill,
FixedNodeInterface {
    public CallTargetNode.InvokeKind getInvokeKind();

    public StampPair getReturnStamp();

    public NodeInputList<ValueNode> getOriginalArguments();

    public ResolvedJavaMethod getOriginalTargetMethod();

    public StampPair getOriginalReturnStamp();

    public NodeInputList<ValueNode> getArguments();

    default public ValueNode getArgument(int index) {
        return (ValueNode)this.getArguments().get(index);
    }

    default public int getArgumentCount() {
        return this.getArguments().size();
    }

    public static boolean assertArgumentCount(MacroInvokable macro) {
        ResolvedJavaMethod method = macro.getTargetMethod();
        if (!1.$assertionsDisabled && method.getSignature().getParameterCount(!method.isStatic()) != macro.getArgumentCount()) {
            throw new AssertionError();
        }
        return true;
    }

    @Override
    default public void setBci(int bci) {
        GraalError.shouldNotReachHere("macro nodes get bci during construction");
    }

    public Invoke replaceWithInvoke();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StructuredGraph lowerReplacement(StructuredGraph graph, StructuredGraph replacementGraph, LoweringTool tool) {
        GraphState.GuardsStage guardsStage;
        if (graph.isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            new RemoveValueProxyPhase(CanonicalizerPhase.create()).apply(replacementGraph, null);
        }
        if (!(guardsStage = graph.getGuardsStage()).allowsFloatingGuards()) {
            new GuardLoweringPhase().apply(replacementGraph, null);
            if (guardsStage.areFrameStatesAtDeopts()) {
                new FrameStateAssignmentPhase().apply(replacementGraph);
            }
        }
        DebugContext debug = replacementGraph.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"LoweringSnippetTemplate", replacementGraph);){
            switch ((LoweringTool.StandardLoweringStage)tool.getLoweringStage()) {
                case HIGH_TIER: {
                    new HighTierLoweringPhase(CanonicalizerPhase.create()).apply(replacementGraph, tool);
                    return replacementGraph;
                }
                case MID_TIER: {
                    new MidTierLoweringPhase(CanonicalizerPhase.create()).apply(replacementGraph, tool);
                    return replacementGraph;
                }
                case LOW_TIER: {
                    new LowTierLoweringPhase(CanonicalizerPhase.create()).apply(replacementGraph, tool);
                    return replacementGraph;
                }
                default: {
                    GraalError.shouldNotReachHere("Unexpected lowering stage.");
                    return replacementGraph;
                }
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    @Override
    default public void lower(LoweringTool tool) {
        Invoke invoke = this.replaceWithInvoke();
        if (!1.$assertionsDisabled && !invoke.asNode().verify()) {
            throw new AssertionError();
        }
        if (BytecodeFrame.isPlaceholderBci((int)invoke.bci())) {
            throw new GraalError("%s: cannot lower to invoke with placeholder BCI: %s", this.asNode().graph(), this);
        }
        if (invoke.stateAfter() == null) {
            throw new GraalError("%s: cannot lower to invoke without state: %s", this.asNode().graph(), this);
        }
        invoke.lower(tool);
    }

    default public MethodCallTargetNode createCallTarget() {
        ValueNode[] arguments = this.getArguments().toArray((A[])new ValueNode[this.getArguments().size()]);
        if (this.getOriginalTargetMethod() != null) {
            ValueNode[] originalArguments = this.getOriginalArguments().toArray((A[])new ValueNode[this.getOriginalArguments().size()]);
            return this.asNode().graph().add(ResolvedMethodHandleCallTargetNode.create(this.getInvokeKind(), this.getTargetMethod(), arguments, this.getReturnStamp(), this.getOriginalTargetMethod(), originalArguments, this.getOriginalReturnStamp()));
        }
        return this.asNode().graph().add(new MethodCallTargetNode(this.getInvokeKind(), this.getTargetMethod(), arguments, this.getReturnStamp(), null));
    }

    public void addMethodHandleInfo(ResolvedMethodHandleCallTargetNode var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

