/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.MethodHandleAccessProvider;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.MacroWithExceptionNode;
import org.graalvm.compiler.replacements.nodes.MethodHandleNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="see MacroNode", size=NodeSize.SIZE_UNKNOWN, sizeRationale="see MacroNode")
public final class MethodHandleWithExceptionNode
extends MacroWithExceptionNode
implements Simplifiable {
    public static final NodeClass<MethodHandleWithExceptionNode> TYPE = NodeClass.create(MethodHandleWithExceptionNode.class);
    protected final MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod;

    public MethodHandleWithExceptionNode(MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, MacroNode.MacroParams p) {
        super(TYPE, p);
        this.intrinsicMethod = intrinsicMethod;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        MethodHandleAccessProvider methodHandleAccess = tool.getConstantReflection().getMethodHandleAccess();
        this.trySimplify(methodHandleAccess);
    }

    public WithExceptionNode trySimplify(MethodHandleAccessProvider methodHandleAccess) {
        MethodHandleNode.InvokeFactory<InvokeWithExceptionNode> invokeFactory;
        ValueNode[] argumentsArray = this.arguments.toArray((A[])new ValueNode[this.arguments.size()]);
        MethodHandleNode.GraphAdder adder = MethodHandleNode.getGraphAdderBeforeNode(this);
        InvokeWithExceptionNode invoke = MethodHandleNode.tryResolveTargetInvoke(adder, invokeFactory = (callTarget, bi, stmp) -> {
            InvokeWithExceptionNode invoke = new InvokeWithExceptionNode(callTarget, null, bi);
            invoke.setStamp(stmp);
            return invoke;
        }, methodHandleAccess, this.intrinsicMethod, this.targetMethod, this.bci, this.returnStamp, argumentsArray);
        if (invoke == null) {
            return this;
        }
        assert (invoke.graph() == null);
        invoke.setNodeSourcePosition(this.getNodeSourcePosition());
        invoke = this.graph().addOrUniqueWithInputs(invoke);
        invoke.setStateAfter(this.stateAfter());
        this.graph().replaceWithExceptionSplit(this, invoke);
        return invoke;
    }
}

