/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;

public final class PEAgnosticInlineInvokePlugin
implements InlineInvokePlugin {
    private final EconomicSet<Invoke> directInvokes = EconomicSet.create();
    private final List<Invoke> indirectInvokes = new ArrayList<Invoke>();
    private final PartialEvaluator partialEvaluator;

    public PEAgnosticInlineInvokePlugin(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (method.equals(this.partialEvaluator.types.OptimizedCallTarget_callDirect)) {
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        return this.partialEvaluator.asInlineInfo(method);
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod original, Invoke invoke) {
        if (original.equals(this.partialEvaluator.types.OptimizedCallTarget_callDirect)) {
            this.directInvokes.add((Object)invoke);
        } else if (original.equals(this.partialEvaluator.types.OptimizedCallTarget_callBoundary)) {
            this.indirectInvokes.add(invoke);
        }
    }

    public EconomicSet<Invoke> getDirectInvokes() {
        return this.directInvokes;
    }

    public List<Invoke> getIndirectInvokes() {
        return this.indirectInvokes;
    }
}

