/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import com.oracle.truffle.compiler.ConstantFieldInfo;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;

final class TruffleConstantFieldProvider
implements ConstantFieldProvider {
    private final PartialEvaluator partialEvaluator;
    private final ConstantFieldProvider delegate;

    TruffleConstantFieldProvider(PartialEvaluator partialEvaluator, ConstantFieldProvider delegate) {
        this.partialEvaluator = partialEvaluator;
        this.delegate = delegate;
    }

    @Override
    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        T ret;
        boolean isStaticField = field.isStatic();
        if (!isStaticField && tool.getReceiver().isNull()) {
            return null;
        }
        boolean isArrayField = field.getType().isArray();
        if (!isArrayField && (ret = this.readConstantFieldFast(field, tool)) != null) {
            return ret;
        }
        boolean hasObjectKind = field.getType().getJavaKind() == JavaKind.Object;
        ConstantFieldInfo info = this.partialEvaluator.getConstantFieldInfo(field);
        if (info != null) {
            if (info.isChildren()) {
                int stableDimensions = isArrayField ? 1 : 0;
                return tool.foldStableArray(this.verifyFieldValue(field, tool.readValue(), info), stableDimensions, true);
            }
            if (!isStaticField && hasObjectKind && info.isChild()) {
                return tool.foldConstant(this.verifyFieldValue(field, tool.readValue(), info));
            }
            if (isArrayField) {
                int dimensions = info.getDimensions();
                assert (dimensions >= 0);
                return tool.foldStableArray(tool.readValue(), dimensions, true);
            }
            return tool.foldConstant(tool.readValue());
        }
        if (isArrayField) {
            return this.readConstantFieldFast(field, tool);
        }
        return null;
    }

    private <T> T readConstantFieldFast(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        T ret = this.delegate.readConstantField(field, tool);
        if (ret == null && field.isFinal()) {
            ret = tool.foldConstant(tool.readValue());
        }
        return ret;
    }

    @Override
    public boolean maybeFinal(ResolvedJavaField field) {
        return this.delegate.maybeFinal(field);
    }

    private JavaConstant verifyFieldValue(ResolvedJavaField field, JavaConstant constant, ConstantFieldInfo info) {
        assert (!info.isChild() || constant.isNull() || this.partialEvaluator.types.Node.isAssignableFrom(this.partialEvaluator.getProviders().getMetaAccess().lookupJavaType(constant))) : String.format("@Child field value must be a Node: %s, but was: %s", field, constant);
        assert (!info.isChildren() || constant.isNull() || this.partialEvaluator.getProviders().getMetaAccess().lookupJavaType(constant).isArray()) : String.format("@Children field value must be an array: %s, but was: %s", field, constant);
        return constant;
    }
}

