/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpHandler;
import org.graalvm.compiler.debug.DebugHandler;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.truffle.compiler.TruffleAST;
import org.graalvm.graphio.GraphOutput;

@ServiceProvider(value=DebugHandlersFactory.class)
public class TruffleDebugHandlersFactory
implements DebugHandlersFactory {
    @Override
    public List<DebugHandler> createHandlers(OptionValues options) {
        return List.of(new TruffleASTDumpHandler());
    }

    private final class TruffleASTDumpHandler
    implements DebugDumpHandler {
        TruffleASTDumpHandler() {
        }

        @Override
        public void dump(Object object, DebugContext debug, boolean forced, String format, Object ... arguments) {
            if (object instanceof TruffleAST) {
                TruffleAST ast = (TruffleAST)object;
                if (DebugOptions.PrintGraph.getValue(debug.getOptions()) != DebugOptions.PrintGraphTarget.Disable) {
                    try {
                        GraphOutput<TruffleAST, ?> output = debug.buildOutput(GraphOutput.newBuilder(TruffleAST.AST_DUMP_STRUCTURE).blocks(TruffleAST.AST_DUMP_STRUCTURE));
                        HashMap properties = new HashMap();
                        output.beginGroup(ast, "AST", "AST", null, 0, null);
                        output.print((TruffleAST)object, properties, 0, format, arguments);
                        output.endGroup();
                        output.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to dump block mapping", e);
                    }
                }
            }
        }
    }
}

