/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.KnownTruffleTypes;

public class TruffleStringConstantFieldProvider
implements ConstantFieldProvider {
    private static final int FLAG_IMPRECISE = 16;
    protected final ConstantFieldProvider graalConstantFieldProvider;
    protected final MetaAccessProvider metaAccess;
    protected final KnownTruffleTypes types;
    private final ResolvedJavaType byteArrayType;

    public TruffleStringConstantFieldProvider(Providers providers, KnownTruffleTypes types) {
        this.graalConstantFieldProvider = providers.getConstantFieldProvider();
        assert (!(this.graalConstantFieldProvider instanceof TruffleStringConstantFieldProvider)) : "recursive truffle string constant field provider";
        this.metaAccess = providers.getMetaAccess();
        this.types = types;
        this.byteArrayType = this.metaAccess.lookupJavaType(byte[].class);
    }

    @Override
    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        boolean isStaticField = field.isStatic();
        if (!isStaticField && tool.getReceiver().isNull()) {
            return null;
        }
        T wellKnownField = this.readWellKnownConstantTruffleField(field, tool);
        if (wellKnownField != null) {
            return wellKnownField;
        }
        return this.graalConstantFieldProvider.readConstantField(field, tool);
    }

    protected final <T> T readWellKnownConstantTruffleField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        JavaConstant value;
        if ((this.types.AbstractTruffleString_data.equals(field) || this.types.AbstractTruffleString_hashCode.equals(field) || this.types.AbstractTruffleString_codeRange.equals(field) || this.types.AbstractTruffleString_codePointLength.equals(field)) && this.types.TruffleString.isAssignableFrom(this.metaAccess.lookupJavaType(tool.getReceiver())) && (value = tool.readValue()) != null) {
            if (this.types.AbstractTruffleString_data.equals(field)) {
                if (this.byteArrayType.isAssignableFrom(this.metaAccess.lookupJavaType(value))) {
                    return tool.foldStableArray(value, 1, true);
                }
            } else if (this.types.AbstractTruffleString_hashCode.equals(field)) {
                if (!value.isDefaultForKind()) {
                    return tool.foldConstant(value);
                }
            } else if (this.types.AbstractTruffleString_codeRange.equals(field)) {
                if ((value.asInt() & 0x10) == 0) {
                    return tool.foldConstant(value);
                }
            } else {
                assert (this.types.AbstractTruffleString_codePointLength.equals(field));
                if (value.asInt() >= 0) {
                    return tool.foldConstant(value);
                }
            }
        }
        return null;
    }

    @Override
    public final boolean maybeFinal(ResolvedJavaField field) {
        return this.types.AbstractTruffleString_data.equals(field) || this.types.AbstractTruffleString_hashCode.equals(field) || this.types.AbstractTruffleString_codeRange.equals(field) || this.types.AbstractTruffleString_codePointLength.equals(field) || this.graalConstantFieldProvider.maybeFinal(field);
    }
}

