/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.host;

import com.oracle.truffle.compiler.HostMethodInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.AbstractInliningPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.contract.NodeCostUtil;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.truffle.compiler.host.TruffleHostEnvironment;
import org.graalvm.compiler.truffle.compiler.host.TruffleKnownHostTypes;

public class HostInliningPhase
extends AbstractInliningPhase {
    private static final double DEFAULT_MIN_FREQUENCY = 0.001;
    static final String INDENT = "  ";
    private static final int TRIVIAL_SIZE = 30;
    private static final int TRIVIAL_INVOKES = 0;
    private static final int MAX_PEEK_PROPAGATE_DEOPT = 3;
    protected final CanonicalizerPhase canonicalizer;
    private final double defaultMinProfiledFrequency;

    public HostInliningPhase(CanonicalizerPhase canonicalizer) {
        this(canonicalizer, 0.001);
    }

    public HostInliningPhase(CanonicalizerPhase canonicalizer, double defaultMinProfiledFrequency) {
        this.canonicalizer = canonicalizer;
        this.defaultMinProfiledFrequency = defaultMinProfiledFrequency;
    }

    protected boolean isEnabledFor(TruffleHostEnvironment env, ResolvedJavaMethod method) {
        return this.isBytecodeInterpreterSwitch(env, method);
    }

    protected String isTruffleBoundary(TruffleHostEnvironment env, ResolvedJavaMethod targetMethod) {
        if (env.getHostMethodInfo(this.translateMethod(targetMethod)).isTruffleBoundary()) {
            return "truffle boundary";
        }
        return null;
    }

    private boolean isBytecodeInterpreterSwitch(TruffleHostEnvironment env, ResolvedJavaMethod targetMethod) {
        return env.getHostMethodInfo(this.translateMethod(targetMethod)).isBytecodeInterpreterSwitch();
    }

    private boolean isInliningCutoff(TruffleHostEnvironment env, ResolvedJavaMethod targetMethod) {
        return env.getHostMethodInfo(this.translateMethod(targetMethod)).isInliningCutoff();
    }

    protected ResolvedJavaMethod translateMethod(ResolvedJavaMethod method) {
        return method;
    }

    private boolean isInInterpreter(InliningPhaseContext context, ResolvedJavaMethod method) {
        return context.types().isInInterpreter(this.translateMethod(method));
    }

    private boolean isInInterpreterFastPath(InliningPhaseContext context, ResolvedJavaMethod method) {
        return context.types().isInInterpreterFastPath(this.translateMethod(method));
    }

    private boolean isTransferToInterpreterMethod(InliningPhaseContext context, ResolvedJavaMethod method) {
        return context.types().isTransferToInterpreterMethod(this.translateMethod(method));
    }

    @Override
    protected final void run(StructuredGraph graph, HighTierContext highTierContext) {
        ResolvedJavaMethod method = graph.method();
        TruffleHostEnvironment env = TruffleHostEnvironment.get(method);
        if (env == null) {
            return;
        }
        if (graph.isOSR()) {
            return;
        }
        if (!this.isEnabledFor(env, method)) {
            return;
        }
        this.runImpl(new InliningPhaseContext(highTierContext, graph, env, this.isBytecodeInterpreterSwitch(env, method), this.defaultMinProfiledFrequency));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl(InliningPhaseContext context) {
        int exploreLimit;
        int sizeLimit;
        ResolvedJavaMethod rootMethod = context.graph.method();
        if (context.isBytecodeSwitch) {
            sizeLimit = Options.TruffleHostInliningByteCodeInterpreterBudget.getValue(context.graph.getOptions());
            exploreLimit = Options.TruffleHostInliningBaseBudget.getValue(context.graph.getOptions());
        } else {
            exploreLimit = sizeLimit = Options.TruffleHostInliningBaseBudget.getValue(context.graph.getOptions()).intValue();
        }
        if (sizeLimit < 0) {
            return;
        }
        DebugContext debug = context.graph.getDebug();
        debug.dump(3, context.graph, "Before Truffle host inlining");
        CallTree root = new CallTree(rootMethod);
        int round = 0;
        int inlineIndex = 0;
        int previousInlineIndex = -1;
        boolean budgetLimitReached = false;
        ArrayList toProcess = new ArrayList();
        EconomicSet canonicalizableNodes = EconomicSet.create();
        int graphSize = 0;
        int beforeGraphSize = -1;
        try {
            while (previousInlineIndex < inlineIndex) {
                previousInlineIndex = inlineIndex;
                if (!canonicalizableNodes.isEmpty()) {
                    this.canonicalizer.applyIncremental(context.graph, (CoreProviders)context.highTierContext, (Iterable<? extends Node>)canonicalizableNodes);
                    canonicalizableNodes.clear();
                }
                graphSize = NodeCostUtil.computeNodesSize(context.graph.getNodes());
                if (round == 0) {
                    beforeGraphSize = graphSize;
                    root.cost = graphSize;
                    root.children = this.exploreGraph(context, root, context.graph, round);
                    ArrayList<CallTree> targets = new ArrayList<CallTree>(root.children);
                    do {
                        targets.clear();
                        HostInliningPhase.traverseShell(context, root, call -> {
                            if (call.forceShallowInline && this.shouldInline(context, (CallTree)call)) {
                                targets.add((CallTree)call);
                            }
                        });
                        for (CallTree call2 : targets) {
                            assert (call2.forceShallowInline) : "not force inlined";
                            if (!this.shouldInline(context, call2)) continue;
                            assert (call2.children == null && call2.exploredIndex == -1) : "force shallow inline already explored";
                            call2.children = this.exploreInlinableCall(context, call2, round, sizeLimit);
                            assert (call2.cost >= 0) : "cost not yet set";
                            if (call2.children == null) {
                                call2.explorationIncomplete = true;
                                continue;
                            }
                            graphSize += call2.cost;
                            this.inlineCall(context, (EconomicSet<Node>)canonicalizableNodes, context.graph, call2, inlineIndex++);
                        }
                    } while (!targets.isEmpty());
                }
                toProcess.clear();
                int finalRound = round;
                HostInliningPhase.traverseShell(context, root, call -> {
                    if (this.shouldInline(context, (CallTree)call)) {
                        if (!call.isExplored()) {
                            call.subtreeGraph = this.exploreAndPrepareGraph(context, (CallTree)call, finalRound, exploreLimit);
                        }
                        if (this.shouldInline(context, (CallTree)call)) {
                            toProcess.add(call);
                        }
                    }
                });
                Collections.sort(toProcess);
                for (CallTree call2 : toProcess) {
                    if (!this.shouldInline(context, call2) || !HostInliningPhase.isInBudget(call2, graphSize, sizeLimit)) continue;
                    assert (!call2.forceShallowInline) : "should already be inlined";
                    graphSize += call2.subTreeCost;
                    this.inlineSubtree(context, (EconomicSet<Node>)canonicalizableNodes, call2, ++inlineIndex);
                    if (!debug.isDumpEnabled(5)) continue;
                    debug.dump(5, (Object)context.graph, "After Truffle host inlining %s", call2.getTargetMethod().format("%H.%n(%P)"));
                }
                debug.dump(4, (Object)context.graph, "After Truffle host inlining round %s", round);
                ++round;
            }
        }
        finally {
            if (debug.isLogEnabled()) {
                if (budgetLimitReached) {
                    debug.log("Warning method host inlining limit exceeded limit %s with graph size %s.", sizeLimit, graphSize);
                }
                debug.log("Truffle host inlining completed after %s rounds. Graph cost changed from %s to %s after inlining: %n%s", round, (Object)beforeGraphSize, (Object)graphSize, (Object)this.printCallTree(context, root));
            }
        }
    }

    private static boolean isInBudget(CallTree call, int graphSize, int sizeLimit) {
        boolean trivial;
        if (call.forceShallowInline) {
            return true;
        }
        int newSize = graphSize + call.subTreeCost;
        if (newSize <= sizeLimit) {
            call.reason = "within budget";
            return true;
        }
        boolean bl = trivial = call.subTreeFastPathInvokes == 0 && call.subTreeCost < 30;
        if (trivial) {
            call.reason = "out of budget but simple enough";
            return true;
        }
        call.reason = "Out of budget";
        return false;
    }

    private List<CallTree> exploreGraph(InliningPhaseContext context, CallTree caller, StructuredGraph graph, int exploreRound) {
        caller.exploredIndex = exploreRound;
        ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, false, true, false);
        EconomicSet deoptimizedBlocks = EconomicSet.create();
        EconomicSet inInterpreterBlocks = EconomicSet.create();
        ArrayList<CallTree> children = new ArrayList<CallTree>();
        HIRBlock[] reversePostOrder = cfg.reversePostOrder();
        EconomicSet unwindBlocks = EconomicSet.create();
        HostInliningPhase.computeUnwindBlocks((EconomicSet<AbstractBeginNode>)unwindBlocks, reversePostOrder);
        for (HIRBlock block : reversePostOrder) {
            if (block.getEndNode() instanceof IfNode) {
                IfNode ifNode = (IfNode)block.getEndNode();
                LogicNode condition = ifNode.condition();
                for (Node input : condition.inputs()) {
                    ResolvedJavaMethod targetMethod;
                    if (!(input instanceof Invoke) || (targetMethod = ((Invoke)((Object)input)).getTargetMethod()) == null || !this.isInInterpreter(context, targetMethod)) continue;
                    inInterpreterBlocks.add((Object)ifNode.falseSuccessor());
                    break;
                }
            }
            boolean guardedByInInterpreter = false;
            for (FixedNode node : block.getNodes()) {
                boolean deoptimized;
                Invoke invoke;
                ResolvedJavaMethod newTargetMethod;
                FixedGuardNode guard;
                if (node instanceof FixedGuardNode && (guard = (FixedGuardNode)node).isNegated()) {
                    LogicNode condition = guard.condition();
                    for (Node input : condition.inputs()) {
                        ResolvedJavaMethod targetMethod;
                        if (!(input instanceof Invoke) || (targetMethod = ((Invoke)((Object)input)).getTargetMethod()) == null || !this.isInInterpreter(context, targetMethod)) continue;
                        for (HIRBlock dominatedSilbling = (HIRBlock)block.getFirstDominated(); dominatedSilbling != null; dominatedSilbling = (HIRBlock)dominatedSilbling.getDominatedSibling()) {
                            inInterpreterBlocks.add((Object)dominatedSilbling.getBeginNode());
                        }
                        guardedByInInterpreter = true;
                        break;
                    }
                }
                if (!(node instanceof Invoke) || (newTargetMethod = (invoke = (Invoke)((Object)node)).getTargetMethod()) == null) continue;
                boolean bl = deoptimized = caller.deoptimized || HostInliningPhase.isBlockOrDominatorContainedIn(block, (EconomicSet<AbstractBeginNode>)deoptimizedBlocks);
                if (this.isTransferToInterpreterMethod(context, newTargetMethod)) {
                    deoptimizedBlocks.add((Object)block.getBeginNode());
                    if (block.getBeginNode() == graph.start()) {
                        caller.propagates = BackPropagation.DEOPT;
                    }
                }
                boolean unwind = caller.unwind || unwindBlocks.contains((Object)block.getBeginNode());
                boolean inInterpreter = guardedByInInterpreter || caller.inInterpreter || HostInliningPhase.isBlockOrDominatorContainedIn(block, (EconomicSet<AbstractBeginNode>)inInterpreterBlocks);
                boolean forceShallowInline = context.isBytecodeSwitch && (caller.forceShallowInline || caller.parent == null) && this.isBytecodeInterpreterSwitch(context.env, invoke.getTargetMethod());
                double frequency = context.isFrequencyCutoffEnabled() ? block.getRelativeFrequency() : 1.0;
                CallTree callee = new CallTree(caller, invoke, deoptimized, unwind, inInterpreter, forceShallowInline, frequency);
                children.add(callee);
                if (forceShallowInline || !this.shouldInline(context, callee)) continue;
                if (callee.propagates == BackPropagation.NOTHING) {
                    callee.propagates = this.peekPropagatesDeoptOrUnwind(context, callee.invoke, this.getTargetMethod(context, callee), 0);
                }
                if (callee.propagates == BackPropagation.NOTHING) continue;
                switch (callee.propagates) {
                    case DEOPT: {
                        deoptimizedBlocks.add((Object)block.getBeginNode());
                        break;
                    }
                    case UNWIND: {
                        if (!unwindBlocks.add((Object)block.getBeginNode())) break;
                        HostInliningPhase.computeUnwindBlocks((EconomicSet<AbstractBeginNode>)unwindBlocks, reversePostOrder);
                    }
                }
                if (block.getBeginNode() != graph.start()) continue;
                caller.propagates = callee.propagates;
            }
        }
        return children;
    }

    private static void computeUnwindBlocks(EconomicSet<AbstractBeginNode> unwindBlocks, HIRBlock[] reversePostOrder) {
        block0: for (int blockIndex = reversePostOrder.length - 1; blockIndex >= 0; --blockIndex) {
            HIRBlock block = reversePostOrder[blockIndex];
            int successorCount = block.getSuccessorCount();
            if (block.getEndNode() instanceof UnwindNode) {
                unwindBlocks.add((Object)block.getBeginNode());
                continue;
            }
            if (successorCount == 0 || block.getEndNode() instanceof LoopEndNode || unwindBlocks.isEmpty()) continue;
            for (int i = 0; i < successorCount; ++i) {
                if (!unwindBlocks.contains((Object)((HIRBlock)block.getSuccessorAt(i)).getBeginNode())) continue block0;
            }
            unwindBlocks.add((Object)block.getBeginNode());
        }
    }

    private BackPropagation peekPropagatesDeoptOrUnwind(InliningPhaseContext context, Invoke callerInvoke, ResolvedJavaMethod method, int depth) {
        if (depth > 3) {
            return BackPropagation.NOTHING;
        }
        StructuredGraph graph = this.lookupGraph(context, callerInvoke, method);
        FixedNode current = graph.start();
        while (current instanceof FixedWithNextNode) {
            if ((current = ((FixedWithNextNode)current).next()) instanceof UnwindNode) {
                return BackPropagation.UNWIND;
            }
            if (current instanceof Invoke) {
                Invoke invoke = (Invoke)((Object)current);
                ResolvedJavaMethod targetMethod = invoke.getTargetMethod();
                if (targetMethod == null) continue;
                if (this.isTransferToInterpreterMethod(context, targetMethod)) {
                    return BackPropagation.DEOPT;
                }
                if (invoke.getInvokeKind().isDirect()) {
                    if (!targetMethod.canBeInlined()) continue;
                    BackPropagation recursivePeek = this.peekPropagatesDeoptOrUnwind(context, invoke, targetMethod, depth + 1);
                    if (recursivePeek != BackPropagation.NOTHING) {
                        return recursivePeek;
                    }
                }
            }
            if (!(current instanceof AbstractEndNode)) continue;
            break;
        }
        return BackPropagation.NOTHING;
    }

    private static boolean isBlockOrDominatorContainedIn(HIRBlock currentBlock, EconomicSet<AbstractBeginNode> blocks) {
        if (blocks.isEmpty()) {
            return false;
        }
        for (HIRBlock dominator = currentBlock; dominator != null; dominator = (HIRBlock)dominator.getDominator()) {
            if (!blocks.contains((Object)dominator.getBeginNode())) continue;
            return true;
        }
        return false;
    }

    private List<CallTree> exploreInlinableCall(InliningPhaseContext context, CallTree callee, int exploreRound, int exploreBudget) {
        ResolvedJavaMethod targetMethod;
        if (callee.invoke.getInvokeKind().isDirect()) {
            targetMethod = callee.getTargetMethod();
        } else {
            assert (callee.monomorphicTargetMethod != null);
            targetMethod = callee.monomorphicTargetMethod;
        }
        StructuredGraph calleeGraph = this.lookupGraph(context, callee.invoke, targetMethod);
        assert (calleeGraph != null) : "There must be a graph available for an inlinable call.";
        callee.cost = NodeCostUtil.computeNodesSize(calleeGraph.getNodes());
        int depth = callee.getDepth();
        if (HostInliningPhase.shouldContinueExploring(context, exploreBudget, callee.cost, depth)) {
            return this.exploreGraph(context, callee, calleeGraph, exploreRound);
        }
        return null;
    }

    private static void traverseInlined(InliningPhaseContext context, CallTree call, Consumer<CallTree> consumer) {
        if (call.isInlined()) {
            assert (call.children != null) : "not yet explored";
            for (CallTree callee : call.children) {
                HostInliningPhase.traverseInlined(context, callee, consumer);
            }
            consumer.accept(call);
        }
    }

    private static void traverseShell(InliningPhaseContext context, CallTree call, Consumer<CallTree> consumer) {
        assert (call.children != null) : "not yet explored";
        for (CallTree callee : call.children) {
            HostInliningPhase.traverseShellRec(context, callee, consumer);
        }
    }

    private static void traverseShellRec(InliningPhaseContext context, CallTree call, Consumer<CallTree> consumer) {
        if (call.isInlined()) {
            for (CallTree callee : call.children) {
                HostInliningPhase.traverseShellRec(context, callee, consumer);
            }
        } else {
            consumer.accept(call);
        }
    }

    private StructuredGraph exploreAndPrepareGraph(InliningPhaseContext context, CallTree root, int exploreRound, int exploreBudget) {
        assert (!root.isExplored());
        root.children = this.exploreInlinableCall(context, root, exploreRound, exploreBudget);
        if (root.children == null) {
            root.explorationIncomplete = true;
            return null;
        }
        if (!this.shouldInline(context, root)) {
            return null;
        }
        StructuredGraph graph = this.lookupGraph(context, root.invoke, this.getTargetMethod(context, root));
        StructuredGraph mutableGraph = (StructuredGraph)graph.copy(map -> {
            for (CallTree callee : root.children) {
                callee.invoke = (Invoke)map.get((Object)callee.invoke.asFixedNode());
            }
        }, context.graph.getDebug());
        EconomicSet canonicalizableNodes = EconomicSet.create();
        HostInliningPhase.enhanceParameters((EconomicSet<Node>)canonicalizableNodes, mutableGraph, root);
        int inlineIndex = 0;
        int prevInlineIndex = -1;
        boolean incomplete = false;
        while (inlineIndex > prevInlineIndex) {
            int currentGraphSize;
            prevInlineIndex = inlineIndex;
            if (!canonicalizableNodes.isEmpty()) {
                this.canonicalizer.applyIncremental(mutableGraph, (CoreProviders)context.highTierContext, (Iterable<? extends Node>)canonicalizableNodes);
                canonicalizableNodes.clear();
                currentGraphSize = NodeCostUtil.computeNodesSize(mutableGraph.getNodes());
            } else {
                currentGraphSize = root.cost;
            }
            incomplete = false;
            ArrayList toProcess = new ArrayList();
            HostInliningPhase.traverseShell(context, root, toProcess::add);
            int fastPathInvokes = 0;
            for (CallTree callee : toProcess) {
                if (fastPathInvokes > context.maxSubtreeInvokes) {
                    incomplete = true;
                    break;
                }
                if (this.shouldInline(context, callee)) {
                    callee.children = this.exploreInlinableCall(context, callee, exploreRound, exploreBudget - currentGraphSize);
                    if (callee.children == null) {
                        incomplete = true;
                        break;
                    }
                    if (this.shouldInline(context, callee)) {
                        this.inlineCall(context, (EconomicSet<Node>)canonicalizableNodes, mutableGraph, callee, inlineIndex++);
                        assert (callee.cost >= 0) : "Cost not yet set.";
                        currentGraphSize += callee.cost;
                        continue;
                    }
                }
                if (!HostInliningPhase.isFastPathInvoke(callee)) continue;
                ++fastPathInvokes;
            }
            root.subTreeFastPathInvokes = fastPathInvokes;
            root.subTreeCost = currentGraphSize;
        }
        if (incomplete) {
            root.explorationIncomplete = true;
            return null;
        }
        return mutableGraph;
    }

    private static void enhanceParameters(EconomicSet<Node> canonicalizableNodes, StructuredGraph graph, CallTree root) {
        for (ParameterNode formalParameter : graph.getNodes(ParameterNode.TYPE).snapshot()) {
            int index = formalParameter.index();
            ValueNode actualParameter = (ValueNode)root.invoke.callTarget().arguments().get(index);
            if (actualParameter.isConstant()) {
                ConstantNode constant = (ConstantNode)actualParameter.copyWithInputs(false);
                ConstantNode uniqueConstant = graph.unique(constant);
                uniqueConstant.clearNodeSourcePosition();
                formalParameter.replaceAndDelete(uniqueConstant);
                HostInliningPhase.enqueueUsages(canonicalizableNodes, uniqueConstant);
                continue;
            }
            Stamp originalStamp = formalParameter.stamp(NodeView.DEFAULT);
            Stamp improvedStamp = originalStamp.tryImproveWith(actualParameter.stamp(NodeView.DEFAULT));
            if (improvedStamp == null) continue;
            assert (!originalStamp.equals(improvedStamp));
            assert (originalStamp.tryImproveWith(improvedStamp) != null);
            formalParameter.setStamp(improvedStamp);
            HostInliningPhase.enqueueUsages(canonicalizableNodes, formalParameter);
        }
    }

    private static void enqueueUsages(EconomicSet<Node> canonicalizableNodes, Node node) {
        if (!canonicalizableNodes.add((Object)node)) {
            return;
        }
        for (Node usage : node.usages()) {
            HostInliningPhase.enqueueUsages(canonicalizableNodes, usage);
        }
    }

    private static boolean shouldContinueExploring(InliningPhaseContext context, int exploreBudget, int graphSize, int depth) {
        int useBudget = Math.max(30, exploreBudget);
        return graphSize <= useBudget && depth <= Options.TruffleHostInliningMaxExplorationDepth.getValue(context.options);
    }

    private static boolean isFastPathInvoke(CallTree call) {
        if (call.deoptimized) {
            return false;
        }
        if (call.unwind) {
            return false;
        }
        if (call.inInterpreter) {
            return false;
        }
        if (call.propagates != BackPropagation.NOTHING) {
            return false;
        }
        String failureMessage = InliningUtil.checkInvokeConditions(call.invoke);
        return failureMessage == null;
    }

    private boolean shouldInline(InliningPhaseContext context, CallTree call) {
        ResolvedJavaMethod targetMethod;
        if (call.parent == null) {
            return true;
        }
        Invoke invoke = call.invoke;
        if (call.isInlined()) {
            return false;
        }
        if (!(invoke.callTarget() instanceof MethodCallTargetNode)) {
            call.reason = "not a method call target";
            return false;
        }
        ResolvedJavaMethod resolvedJavaMethod = targetMethod = invoke.getTargetMethod() == null ? call.getTargetMethod() : invoke.getTargetMethod();
        if (!HostInliningPhase.shouldInlineTarget(context, call, targetMethod)) {
            return false;
        }
        String failureMessage = InliningUtil.checkInvokeConditions(call.invoke);
        if (failureMessage != null) {
            call.reason = failureMessage;
            return false;
        }
        if (!invoke.getInvokeKind().isDirect() && !HostInliningPhase.shouldInlineMonomorphic(context, call, targetMethod)) {
            return false;
        }
        if (this.isTransferToInterpreterMethod(context, targetMethod)) {
            return true;
        }
        if (this.isInInterpreter(context, targetMethod) || this.isInInterpreterFastPath(context, targetMethod)) {
            return true;
        }
        if (call.forceShallowInline && !call.explorationIncomplete) {
            if (call.frequency <= context.minimumFrequency) {
                call.reason = "frequency < minimumFrequency";
                return false;
            }
            return true;
        }
        if (call.deoptimized) {
            call.reason = "dominated by transferToInterpreter()";
            return false;
        }
        if (call.unwind) {
            call.reason = "leads to unwind";
            return false;
        }
        if (call.inInterpreter) {
            call.reason = "protected by inInterpreter()";
            return false;
        }
        switch (call.propagates) {
            case DEOPT: {
                call.reason = "propagates transferToInterpreter";
                return false;
            }
            case UNWIND: {
                call.reason = "propagates unwind";
                return false;
            }
        }
        if (this.isInliningCutoff(context.env, targetMethod)) {
            call.reason = "method annotated with @InliningCutoff";
            return false;
        }
        if (call.subTreeFastPathInvokes >= context.maxSubtreeInvokes) {
            call.reason = "call has too many fast-path invokes - too complex, please optimize, see truffle/docs/HostOptimization.md";
            return false;
        }
        if (call.explorationIncomplete) {
            call.reason = "too big to explore";
            return false;
        }
        if (call.parent.isRecursive(targetMethod)) {
            call.reason = "recursive";
            return false;
        }
        String boundary = this.isTruffleBoundary(context.env, targetMethod);
        if (boundary != null) {
            call.reason = boundary;
            return false;
        }
        double frequency = call.frequency;
        if (frequency <= context.minimumFrequency) {
            call.reason = "frequency < minimumFrequency";
            return false;
        }
        if (this.isBytecodeInterpreterSwitch(context.env, targetMethod)) {
            call.reason = "bytecode interpreter switch must not be inlined";
            return false;
        }
        ProfilingInfo info = context.graph.getProfilingInfo(targetMethod);
        if (info != null && new OptimisticOptimizations(context.graph.getProfilingInfo(targetMethod), context.options).lessOptimisticThan(context.highTierContext.getOptimisticOptimizations())) {
            call.reason = "the callee uses less optimistic optimizations than caller";
            return false;
        }
        return true;
    }

    private static boolean shouldInlineTarget(InliningPhaseContext context, CallTree call, ResolvedJavaMethod targetMethod) {
        if (targetMethod == null) {
            call.reason = "target method is not resolved";
            return false;
        }
        if (!targetMethod.canBeInlined()) {
            call.reason = "target method not inlinable";
            return false;
        }
        if (targetMethod.isNative() && (!GraalOptions.Intrinsify.getValue(context.options).booleanValue() || context.highTierContext.getReplacements().getInlineSubstitution(targetMethod, call.invoke.bci(), call.invoke.getInlineControl(), context.graph.trackNodeSourcePosition(), null, context.graph.allowAssumptions(), context.options) == null)) {
            call.reason = "target method is a non-intrinsic native method";
            return false;
        }
        if (!targetMethod.getDeclaringClass().isInitialized()) {
            call.reason = "target method's class is not initialized";
            return false;
        }
        return true;
    }

    private static boolean shouldInlineMonomorphic(InliningPhaseContext context, CallTree call, ResolvedJavaMethod targetMethod) {
        Invoke invoke = call.invoke;
        JavaTypeProfile typeProfile = ((MethodCallTargetNode)invoke.callTarget()).getTypeProfile();
        if (typeProfile == null) {
            call.reason = "not direct call: no type profile";
            return false;
        }
        if (typeProfile.getNotRecordedProbability() != 0.0) {
            call.reason = "not direct call: type might be imprecise";
            return false;
        }
        JavaTypeProfile.ProfiledType[] ptypes = typeProfile.getTypes();
        if (ptypes == null || ptypes.length <= 0) {
            call.reason = "not direct call: no parameter types in profile";
            return false;
        }
        if (ptypes.length != 1) {
            call.reason = "not direct call: polymorphic inlining not supported";
            return false;
        }
        SpeculationLog speculationLog = context.graph.getSpeculationLog();
        if (speculationLog == null) {
            call.reason = "not direct call: no speculation log";
            return false;
        }
        OptimisticOptimizations optimisticOpts = context.highTierContext.getOptimisticOptimizations();
        if (!optimisticOpts.inlineMonomorphicCalls(context.options)) {
            call.reason = "not direct call: inlining monomorphic calls is disabled";
            return false;
        }
        SpeculationLog.SpeculationReason speculationReason = InliningUtil.createSpeculation(invoke, typeProfile);
        if (!speculationLog.maySpeculate(speculationReason)) {
            call.reason = "not direct call: speculation disabled";
            return false;
        }
        ResolvedJavaType type = ptypes[0].getType();
        ResolvedJavaMethod concrete = type.resolveConcreteMethod(targetMethod, invoke.getContextType());
        if (!HostInliningPhase.shouldInlineTarget(context, call, concrete)) {
            return false;
        }
        call.monomorphicTargetMethod = concrete;
        return true;
    }

    private void inlineSubtree(InliningPhaseContext context, EconomicSet<Node> canonicalizableNodes, CallTree call, int inlineIndex) {
        assert (call.subtreeGraph != null);
        UnmodifiableEconomicMap<Node, Node> oldToNew = this.inlineGraph(context, canonicalizableNodes, context.graph, call, call.subtreeGraph);
        call.subtreeGraph = null;
        HostInliningPhase.traverseShell(context, call, c -> {
            if (c.invoke.isAlive()) {
                c.invoke = (Invoke)oldToNew.get((Object)c.invoke.asFixedNode());
            }
        });
        call.inlinedIndex = inlineIndex;
        HostInliningPhase.traverseInlined(context, call, c -> {
            c.inlinedIndex = inlineIndex;
        });
    }

    private void inlineCall(InliningPhaseContext context, EconomicSet<Node> canonicalizableNodes, StructuredGraph targetGraph, CallTree call, int inlineIndex) {
        assert (call.invoke.asFixedNode().graph() == targetGraph) : "invalid graph";
        assert (call.children != null) : "Call not yet explored or marked incomplete.";
        assert (this.shouldInline(context, call)) : "Call should be inlined.";
        StructuredGraph graph = this.lookupGraph(context, call.invoke, this.getTargetMethod(context, call));
        UnmodifiableEconomicMap<Node, Node> oldToNew = this.inlineGraph(context, canonicalizableNodes, targetGraph, call, graph);
        call.reason = null;
        call.inlinedIndex = inlineIndex;
        for (CallTree child : call.children) {
            child.invoke = (Invoke)oldToNew.get((Object)child.invoke.asFixedNode());
            assert (child.invoke != null) : "new invoke not found";
        }
    }

    private UnmodifiableEconomicMap<Node, Node> inlineGraph(InliningPhaseContext context, EconomicSet<Node> canonicalizableNodes, StructuredGraph targetGraph, CallTree call, StructuredGraph inlineGraph) {
        Invoke invoke = call.invoke;
        ResolvedJavaMethod targetMethod = this.getTargetMethod(context, call);
        if (!invoke.getInvokeKind().isDirect()) {
            assert (targetMethod != null);
            JavaTypeProfile typeProfile = ((MethodCallTargetNode)invoke.callTarget()).getTypeProfile();
            SpeculationLog.SpeculationReason speculationReason = InliningUtil.createSpeculation(invoke, typeProfile);
            SpeculationLog speculationLog = targetGraph.getSpeculationLog();
            ResolvedJavaType resolvedType = typeProfile.getTypes()[0].getType();
            InliningUtil.insertTypeGuard(context.highTierContext, invoke, resolvedType, speculationLog.speculate(speculationReason));
            InliningUtil.replaceInvokeCallTarget(invoke, targetGraph, CallTargetNode.InvokeKind.Special, targetMethod);
        }
        assert (call.invoke.asFixedNode().graph() == targetGraph);
        assert (inlineGraph.method().equals(targetMethod));
        return HostInliningPhase.inlineForCanonicalization(canonicalizableNodes, invoke, targetMethod, inlineGraph);
    }

    private static UnmodifiableEconomicMap<Node, Node> inlineForCanonicalization(EconomicSet<Node> canonicalizableNodes, Invoke invoke, ResolvedJavaMethod inlineMethod, StructuredGraph inlineGraph) {
        AtomicReference duplicates = new AtomicReference();
        canonicalizableNodes.addAll(InliningUtil.inlineForCanonicalization(invoke, inlineGraph, true, inlineMethod, d -> duplicates.set(d), "Truffle Host Inlining", "Truffle Host Inlining"));
        return (UnmodifiableEconomicMap)duplicates.get();
    }

    private ResolvedJavaMethod getTargetMethod(InliningPhaseContext context, CallTree call) {
        ResolvedJavaMethod targetMethod;
        assert (this.shouldInline(context, call));
        if (call.invoke.getInvokeKind().isDirect()) {
            targetMethod = call.invoke.getTargetMethod();
        } else {
            targetMethod = call.monomorphicTargetMethod;
            assert (targetMethod != null);
        }
        return targetMethod;
    }

    private StructuredGraph lookupGraph(InliningPhaseContext context, Invoke invoke, ResolvedJavaMethod method) {
        StructuredGraph graph = context.highTierContext.getReplacements().getInlineSubstitution(method, invoke.bci(), invoke.getInlineControl(), context.graph.trackNodeSourcePosition(), null, invoke.asNode().graph().allowAssumptions(), invoke.asNode().getOptions());
        if (graph == null && (graph = (StructuredGraph)context.graphCache.get((Object)method)) == null) {
            graph = this.parseGraph(context.highTierContext, context.graph, method);
            context.graphCache.put((Object)method, (Object)graph);
        }
        return graph;
    }

    protected StructuredGraph parseGraph(HighTierContext context, StructuredGraph graph, ResolvedJavaMethod method) {
        DebugContext debug = graph.getDebug();
        StructuredGraph newGraph = new StructuredGraph.Builder(graph.getOptions(), debug, graph.allowAssumptions()).method(method).trackNodeSourcePosition(graph.trackNodeSourcePosition()).profileProvider(graph.getProfileProvider()).speculationLog(graph.getSpeculationLog()).build();
        DebugContext.Scope s = debug.scope((Object)"InlineGraph", newGraph);
        try {
            if (!graph.isUnsafeAccessTrackingEnabled()) {
                newGraph.disableUnsafeAccessTracking();
            }
            if (context.getGraphBuilderSuite() != null) {
                context.getGraphBuilderSuite().apply(newGraph, context);
            }
            assert (newGraph.start().next() != null) : "graph needs to be populated by the GraphBuilderSuite " + method + ", " + method.canBeInlined();
            new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(newGraph);
            this.canonicalizer.apply(newGraph, context);
            StructuredGraph structuredGraph = newGraph;
            if (s != null) {
                s.close();
            }
            return structuredGraph;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    private String printCallTree(InliningPhaseContext context, CallTree root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(out, true);
        this.printTree(context, writer, INDENT, root, this.maxLabelWidth(context, root, 0, 1));
        return new String(out.toByteArray());
    }

    private int maxLabelWidth(InliningPhaseContext context, CallTree tree, int maxLabelWidth, int depth) {
        int maxLabel = 0;
        maxLabel = tree.parent == null ? 0 : Math.max(tree.buildLabel().length() + depth * INDENT.length(), maxLabelWidth);
        if (tree.children != null && (Options.TruffleHostInliningPrintExplored.getValue(context.options).booleanValue() || tree.inlinedIndex != -1 || tree.parent == null)) {
            for (CallTree child : tree.children) {
                maxLabel = this.maxLabelWidth(context, child, maxLabel, depth + 1);
            }
        }
        return maxLabel;
    }

    private void printTree(InliningPhaseContext context, PrintStream out, String indent, CallTree tree, int maxLabelWidth) {
        out.printf("%s%n", tree.toString(indent, maxLabelWidth));
        if (tree.children != null && (Options.TruffleHostInliningPrintExplored.getValue(context.options).booleanValue() || tree.inlinedIndex != -1 || tree.parent == null)) {
            for (CallTree child : tree.children) {
                this.printTree(context, out, indent + INDENT, child, maxLabelWidth);
            }
        }
    }

    public static void install(HighTier highTier, OptionValues options) {
        if (!Options.TruffleHostInlining.getValue(options).booleanValue()) {
            return;
        }
        HostInliningPhase phase = new HostInliningPhase(CanonicalizerPhase.create());
        ListIterator insertionPoint = highTier.findPhase(AbstractInliningPhase.class);
        if (insertionPoint == null) {
            highTier.prependPhase(phase);
            return;
        }
        insertionPoint.previous();
        insertionPoint.add(phase);
    }

    public static void installInlineInvokePlugin(GraphBuilderConfiguration.Plugins plugins, OptionValues options) {
        if (Options.TruffleHostInlining.getValue(options).booleanValue()) {
            plugins.prependInlineInvokePlugin(new BytecodeParserInlineInvokePlugin());
        }
    }

    public static boolean shouldDenyTrivialInliningInAllMethods(TruffleHostEnvironment env, ResolvedJavaMethod callee) {
        return env.getHostMethodInfo(callee).isInliningCutoff();
    }

    public static boolean shouldDenyTrivialInlining(TruffleHostEnvironment env, ResolvedJavaMethod callee) {
        TruffleKnownHostTypes types = env.types();
        HostMethodInfo info = env.getHostMethodInfo(callee);
        return info.isBytecodeInterpreterSwitch() || info.isInliningCutoff() || info.isTruffleBoundary() || types.isInInterpreter(callee) || types.isInInterpreterFastPath(callee) || types.isTransferToInterpreterMethod(callee);
    }

    static final class InliningPhaseContext {
        final HighTierContext highTierContext;
        final StructuredGraph graph;
        final OptionValues options;
        final TruffleHostEnvironment env;
        final boolean isBytecodeSwitch;
        final int maxSubtreeInvokes;
        final boolean printExplored;
        final double minimumFrequency;
        final EconomicMap<ResolvedJavaMethod, StructuredGraph> graphCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);

        InliningPhaseContext(HighTierContext context, StructuredGraph graph, TruffleHostEnvironment env, boolean isBytecodeSwitch, double defaultMinimumFrequency) {
            this.highTierContext = context;
            this.graph = graph;
            this.options = graph.getOptions();
            this.env = env;
            this.isBytecodeSwitch = isBytecodeSwitch;
            this.maxSubtreeInvokes = Options.TruffleHostInliningMaxSubtreeInvokes.getValue(this.options);
            this.printExplored = Options.TruffleHostInliningPrintExplored.getValue(this.options);
            this.minimumFrequency = Options.TruffleHostInliningMinFrequency.hasBeenSet(this.options) ? Options.TruffleHostInliningMinFrequency.getValue(this.options) : defaultMinimumFrequency;
        }

        TruffleKnownHostTypes types() {
            return this.env.types();
        }

        boolean isFrequencyCutoffEnabled() {
            return this.minimumFrequency > 0.0;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> TruffleHostInlining = new OptionKey<Boolean>(true);
        public static final OptionKey<Integer> TruffleHostInliningBaseBudget = new OptionKey<Integer>(5000);
        public static final OptionKey<Integer> TruffleHostInliningByteCodeInterpreterBudget = new OptionKey<Integer>(100000);
        public static final OptionKey<Boolean> TruffleHostInliningPrintExplored = new OptionKey<Boolean>(false);
        public static final OptionKey<Integer> TruffleHostInliningMaxExplorationDepth = new OptionKey<Integer>(1000);
        public static final OptionKey<Integer> TruffleHostInliningMaxSubtreeInvokes = new OptionKey<Integer>(20);
        public static final OptionKey<Double> TruffleHostInliningMinFrequency = new OptionKey<Double>(0.001);
    }

    static final class CallTree
    implements Comparable<CallTree> {
        public StructuredGraph subtreeGraph;
        Invoke invoke;
        final CallTree parent;
        List<CallTree> children;
        final boolean deoptimized;
        final boolean unwind;
        final boolean inInterpreter;
        final boolean forceShallowInline;
        BackPropagation propagates = BackPropagation.NOTHING;
        String reason;
        int inlinedIndex = -1;
        ResolvedJavaMethod cachedTargetMethod;
        ResolvedJavaMethod monomorphicTargetMethod;
        int subTreeFastPathInvokes = -1;
        int subTreeCost = -1;
        int cost = -1;
        boolean explorationIncomplete;
        int exploredIndex = -1;
        final double frequency;
        final int depth;

        CallTree(CallTree parent, Invoke invoke, boolean deoptimized, boolean unwind, boolean inInterpreter, boolean forceShallowInline, double relativeFrequency) {
            this.invoke = invoke;
            this.deoptimized = deoptimized;
            this.unwind = unwind;
            this.inInterpreter = inInterpreter;
            this.parent = parent;
            this.cachedTargetMethod = invoke.getTargetMethod();
            this.forceShallowInline = forceShallowInline;
            this.depth = parent.depth + 1;
            Objects.requireNonNull(this.cachedTargetMethod);
            this.frequency = relativeFrequency * parent.frequency;
        }

        CallTree(ResolvedJavaMethod root) {
            this.invoke = null;
            this.deoptimized = false;
            this.unwind = false;
            this.inInterpreter = false;
            this.forceShallowInline = false;
            this.cachedTargetMethod = root;
            this.parent = null;
            this.frequency = 1.0;
            this.depth = 0;
        }

        int getDepth() {
            return this.depth;
        }

        boolean isExplored() {
            return this.exploredIndex > -1;
        }

        ResolvedJavaMethod getTargetMethod() {
            if (this.invoke == null) {
                return this.cachedTargetMethod;
            }
            ResolvedJavaMethod targetMethod = this.invoke.getTargetMethod();
            if (targetMethod != null) {
                this.cachedTargetMethod = targetMethod;
            } else {
                targetMethod = this.cachedTargetMethod;
            }
            return targetMethod;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        boolean isInlined() {
            return this.inlinedIndex != -1 || this.isRoot();
        }

        @Override
        public int compareTo(CallTree o) {
            assert (this.subTreeFastPathInvokes != -1 && this.subTreeCost != -1) : "unexpected comparison";
            int compare = Double.compare(this.frequency, o.frequency);
            if (compare == 0) {
                compare = Integer.compare(this.subTreeFastPathInvokes, o.subTreeFastPathInvokes);
            }
            if (compare == 0) {
                return Integer.compare(this.subTreeCost, o.subTreeCost);
            }
            return compare;
        }

        private boolean isRecursive(ResolvedJavaMethod other) {
            if (this.getTargetMethod().equals(other)) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.isRecursive(other);
            }
            return false;
        }

        public String toString(String indent, int maxIndent) {
            ResolvedJavaMethod targetMethod = this.getTargetMethod();
            if (this.invoke == null) {
                return "Root[" + targetMethod.format("%H.%n") + "]";
            }
            boolean fastPathInvoke = HostInliningPhase.isFastPathInvoke(this);
            return String.format("%-" + maxIndent + "s [inlined %4s, explored %4s, monomorphic %5s, deopt %5s, unwind %5s, inInterpreter %5s, propagates %7s, invoke %5s, frequency %s, cost %4s, subTreeCost %4s, treeInvokes %4s,  incomplete %5s, reason %s]", new Object[]{indent + this.buildLabel(), CallTree.formatOptionalInt(this.hasCutoffParent() ? -1 : this.inlinedIndex), CallTree.formatOptionalInt(this.exploredIndex), this.monomorphicTargetMethod != null, this.deoptimized, this.unwind, this.inInterpreter, this.propagates, fastPathInvoke, CallTree.formatFrequency(this.frequency), CallTree.formatOptionalInt(this.cost), CallTree.formatOptionalInt(this.subTreeCost), CallTree.formatOptionalInt(this.subTreeFastPathInvokes), this.explorationIncomplete, this.reason});
        }

        private static String formatFrequency(double frequency) {
            return String.format("%.5f", frequency);
        }

        private String buildLabel() {
            String label = this.reason == null && this.inlinedIndex == -1 ? "NEW     " : (this.inlinedIndex != -1 ? (this.hasCutoffParent() ? "EXPLORED" : "INLINE  ") : (this.invoke.isAlive() ? "CUTOFF  " : "DEAD    "));
            StringBuilder b = new StringBuilder(label);
            b.append(" ");
            String name = this.getTargetMethod().format("%H.%n(%p)");
            if (name.length() > 140) {
                name = this.getTargetMethod().format("%H.%n(...)");
            }
            b.append(name);
            return b.toString();
        }

        static String formatOptionalInt(int value) {
            if (value < 0) {
                return "-";
            }
            return String.valueOf(value);
        }

        private boolean hasCutoffParent() {
            CallTree current = this.parent;
            while (current != null) {
                if (!current.isInlined() && !current.isRoot()) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }

        public String toString() {
            return this.toString("", 1);
        }
    }

    private static enum BackPropagation {
        NOTHING,
        DEOPT,
        UNWIND;

    }

    static final class BytecodeParserInlineInvokePlugin
    implements InlineInvokePlugin {
        BytecodeParserInlineInvokePlugin() {
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode[] args) {
            TruffleHostEnvironment env = TruffleHostEnvironment.get(b.getMethod());
            if (env != null && HostInliningPhase.shouldDenyTrivialInlining(env, targetMethod)) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            return null;
        }
    }
}

