/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotKnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleSafepointNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public final class HotSpotTruffleSafepointLoweringSnippet
implements Snippets {
    static final HotSpotForeignCallDescriptor THREAD_LOCAL_HANDSHAKE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "HotSpotThreadLocalHandshake.doHandshake", Void.TYPE, Object.class);
    static final LocationIdentity PENDING_HANDSHAKE_LOCATION = NamedLocationIdentity.mutable("JavaThread::_jvmci_reserved0");

    @Snippet
    private static void pollSnippet(Object node, @Snippet.ConstantParameter int pendingHandshakeOffset) {
        Word thread = CurrentJavaThreadNode.get();
        if (BranchProbabilityNode.probability(0.0010000000000000009, thread.readInt(pendingHandshakeOffset, PENDING_HANDSHAKE_LOCATION) != 0)) {
            HotSpotTruffleSafepointLoweringSnippet.foreignPoll(THREAD_LOCAL_HANDSHAKE, node);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void foreignPoll(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    static class TruffleHotSpotSafepointLoweringExtension
    implements DefaultHotSpotLoweringProvider.Extension {
        @NativeImageReinitialize
        private Templates templates;
        private final HotSpotKnownTruffleTypes types;
        @NativeImageReinitialize
        private volatile Runnable deferredInit;

        TruffleHotSpotSafepointLoweringExtension(HotSpotKnownTruffleTypes types) {
            this.types = types;
        }

        public Class<TruffleSafepointNode> getNodeType() {
            return TruffleSafepointNode.class;
        }

        @Override
        public void lower(Node n, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                this.doDeferredInit();
                if (this.templates != null) {
                    this.templates.lower((TruffleSafepointNode)n, tool);
                } else {
                    GraphUtil.unlinkFixedNode((TruffleSafepointNode)n);
                    n.safeDelete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDeferredInit() {
            if (this.deferredInit != null) {
                TruffleHotSpotSafepointLoweringExtension truffleHotSpotSafepointLoweringExtension = this;
                synchronized (truffleHotSpotSafepointLoweringExtension) {
                    if (this.deferredInit != null) {
                        this.deferredInit.run();
                        this.deferredInit = null;
                    }
                }
            }
        }

        @Override
        public void initialize(HotSpotProviders providers, OptionValues options, GraalHotSpotVMConfig config, HotSpotHostForeignCallsProvider foreignCalls, Iterable<DebugHandlersFactory> factories) {
            GraalError.guarantee(this.templates == null, "cannot re-initialize %s", (Object)this);
            if (config.invokeJavaMethodAddress != 0L && config.jvmciReserved0Offset != -1) {
                this.templates = new Templates(options, providers, config.jvmciReserved0Offset);
                foreignCalls.register(THREAD_LOCAL_HANDSHAKE.getSignature());
                this.deferredInit = () -> {
                    long address = config.invokeJavaMethodAddress;
                    GraalError.guarantee(address != 0L, "Cannot lower %s as JVMCIRuntime::invoke_static_method_one_arg is missing", (Object)address);
                    ResolvedJavaMethod staticMethod = this.types.HotSpotThreadLocalHandshake_doHandshake;
                    foreignCalls.invokeJavaMethodStub(options, providers, THREAD_LOCAL_HANDSHAKE, address, staticMethod);
                };
            }
        }
    }

    static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo pollSnippet;
        private final int pendingHandshakeOffset;

        Templates(OptionValues options, HotSpotProviders providers, int pendingHandshakeOffset) {
            super(options, providers);
            this.pendingHandshakeOffset = pendingHandshakeOffset;
            this.pollSnippet = this.snippet((Providers)providers, HotSpotTruffleSafepointLoweringSnippet.class, "pollSnippet", PENDING_HANDSHAKE_LOCATION);
        }

        public void lower(TruffleSafepointNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.pollSnippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("node", node.location());
            args.addConst("pendingHandshakeOffset", this.pendingHandshakeOffset);
            SnippetTemplate template = this.template(tool, node, args);
            template.instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

