/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotBackend;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotZBarrierSetLIRGenerator;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.EntryPointDecorator;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleEntryPointDecorator;

@ServiceProvider(value=TruffleCallBoundaryInstrumentationFactory.class)
public class AMD64TruffleCallBoundaryInstrumentationFactory
extends TruffleCallBoundaryInstrumentationFactory {
    @Override
    public EntryPointDecorator create(TruffleCompilerConfiguration compilerConfig, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        return new TruffleEntryPointDecorator(compilerConfig, config, registers){

            @Override
            public void emitEntryPoint(CompilationResultBuilder crb) {
                AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
                Register thisRegister = crb.codeCache.getRegisterConfig().getCallingConventionRegisters((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, JavaKind.Object).get(0);
                Register spillRegister = AMD64.r10;
                Label doProlog = new Label();
                int pos = masm.position();
                AMD64Address address = new AMD64Address(thisRegister, this.installedCodeOffset);
                if (this.config.useCompressedOops) {
                    masm.movl(spillRegister, address, true);
                    assert (masm.position() - pos >= 5);
                    CompressEncoding encoding = this.config.getOopEncoding();
                    Register heapBaseRegister = AMD64Move.UncompressPointerOp.hasBase(encoding) ? this.registers.getHeapBaseRegister() : Register.None;
                    AMD64Move.UncompressPointerOp.emitUncompressCode(masm, spillRegister, encoding.getShift(), heapBaseRegister, true);
                } else {
                    masm.movq(spillRegister, address, true);
                    assert (masm.position() - pos >= 5);
                    if (this.config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
                        ForeignCallLinkage callTarget = crb.providers.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
                        AMD64HotSpotZBarrierSetLIRGenerator.emitBarrier(crb, masm, null, spillRegister, this.config, callTarget, address, null, (AMD64HotSpotBackend.HotSpotFrameContext)crb.frameContext);
                    }
                }
                masm.movq(spillRegister, new AMD64Address(spillRegister, this.entryPointOffset));
                masm.testqAndJcc(spillRegister, spillRegister, AMD64Assembler.ConditionFlag.Equal, doProlog, true);
                masm.jmp(spillRegister);
                masm.bind(doProlog);
            }
        };
    }

    @Override
    public String getArchitecture() {
        return "AMD64";
    }
}

