/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.truffle.compiler.nodes.frame.NewFrameNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessFlags;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessVerificationNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public abstract class VirtualFrameAccessorNode
extends FixedWithNextNode
implements ControlFlowAnchored,
VirtualFrameAccessVerificationNode {
    public static final NodeClass<VirtualFrameAccessorNode> TYPE = NodeClass.create(VirtualFrameAccessorNode.class);
    @Node.Input
    protected NewFrameNode frame;
    protected final int frameSlotIndex;
    protected final int accessTag;
    protected final VirtualFrameAccessType type;
    protected final VirtualFrameAccessFlags accessFlags;

    protected VirtualFrameAccessorNode(NodeClass<? extends VirtualFrameAccessorNode> c, Stamp stamp, InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        this(c, stamp, (NewFrameNode)frame.get(), frameSlotIndex, accessTag, type, accessFlags);
    }

    protected VirtualFrameAccessorNode(NodeClass<? extends VirtualFrameAccessorNode> c, Stamp stamp, NewFrameNode frame, int frameSlotIndex, int accessTag, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
        this.type = type;
        this.frame = frame;
        this.frameSlotIndex = frameSlotIndex;
        this.accessTag = accessTag;
        this.accessFlags = accessFlags;
    }

    protected final ValueNode getConstant(int n) {
        return (ValueNode)this.frame.smallIntConstants.get(n);
    }

    protected final ValueNode getConstantWithStaticModifier(int n) {
        return (ValueNode)this.frame.smallIntConstants.get(n | 8);
    }

    @Override
    public final NewFrameNode getFrame() {
        return this.frame;
    }

    @Override
    public final int getFrameSlotIndex() {
        return this.frameSlotIndex;
    }

    @Override
    public final VirtualFrameAccessType getType() {
        return this.type;
    }

    public final int getAccessTag() {
        return this.accessTag;
    }

    protected final void insertDeoptimization(VirtualizerTool tool) {
        LogicConstantNode condition = LogicConstantNode.contradiction();
        tool.addNode(condition);
        SpeculationLog.Speculation speculation = this.graph().getSpeculationLog().speculate(this.frame.getIntrinsifyAccessorsSpeculation());
        tool.addNode(new FixedGuardNode((LogicNode)condition, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.InvalidateReprofile, speculation, false));
        if (this.getStackKind() == JavaKind.Void) {
            tool.delete();
        } else {
            ConstantNode unusedValue = ConstantNode.forConstant(JavaConstant.defaultForKind((JavaKind)this.getStackKind()), tool.getMetaAccess());
            tool.addNode(unusedValue);
            tool.replaceWith(unusedValue);
        }
    }

    @Override
    public <State> void updateVerificationState(VirtualFrameAccessVerificationNode.VirtualFrameVerificationStateUpdater<State> updater, State state) {
        assert (!this.accessFlags.updatesFrame()) : "This node modifies the frame and must override `updateVerificationState`.";
    }
}

