/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import com.oracle.truffle.compiler.TruffleCompilable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.compiler.truffle.compiler.PerformanceInformationHandler;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.nodes.frame.NewFrameNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessFlags;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessVerificationNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameSetNode;

public final class FrameAccessVerificationPhase
extends BasePhase<TruffleTierContext> {
    private static final VirtualFrameAccessVerificationNode.VirtualFrameVerificationStateUpdater<byte[]> STATE_UPDATER = new VirtualFrameAccessVerificationNode.VirtualFrameVerificationStateUpdater<byte[]>(){

        @Override
        public void set(byte[] entries, int slot, byte tag) {
            entries[slot] = tag == 0 ? FrameAccessVerificationPhase.cleared((byte)1) : FrameAccessVerificationPhase.withValue(NewFrameNode.asStackTag(tag));
        }

        @Override
        public void clear(byte[] entries, int slot) {
            entries[slot] = FrameAccessVerificationPhase.cleared((byte)1);
        }

        @Override
        public void copy(byte[] entries, int src, int dst) {
            if (FrameAccessVerificationPhase.inRange(entries, src)) {
                entries[dst] = entries[src];
            }
        }

        @Override
        public void swap(byte[] entries, int src, int dst) {
            if (FrameAccessVerificationPhase.inRange(entries, src)) {
                byte temp = entries[dst];
                entries[dst] = entries[src];
                entries[src] = temp;
            }
        }
    };
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final byte NONE = -1;
    private static final int TYPE_MASK = 15;
    private static final int MODE_MASK = 48;
    private static final int MODE_CLEARED = 0;
    private static final int MODE_VALUE = 16;

    private static byte cleared(byte tag) {
        assert (tag <= 15);
        return (byte)(tag & 0xF | 0);
    }

    private static byte withValue(byte tag) {
        assert (tag <= 15);
        return (byte)(tag & 0xF | 0x10);
    }

    private static byte type(byte tag) {
        return (byte)(tag & 0xF);
    }

    private static byte mode(byte tag) {
        return (byte)(tag & 0x30);
    }

    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        if (graph.getNodes(NewFrameNode.TYPE).isNotEmpty()) {
            ArrayList<Effect> effects = new ArrayList<Effect>();
            ReentrantNodeIterator.apply(new ReentrantIterator(context.compilable, effects), graph.start(), new State(effects));
            for (Effect effect : effects) {
                effect.apply();
            }
        }
    }

    private static boolean inRange(byte[] array, int index) {
        return index >= 0 && index < array.length;
    }

    private final class ReentrantIterator
    extends ReentrantNodeIterator.NodeIteratorClosure<State> {
        private final TruffleCompilable compilable;
        private final ArrayList<Effect> effects;

        ReentrantIterator(TruffleCompilable compilable, ArrayList<Effect> effects) {
            this.compilable = compilable;
            this.effects = effects;
        }

        @Override
        protected State processNode(FixedNode node, State currentState) {
            byte[] entries;
            VirtualFrameAccessVerificationNode accessor;
            VirtualFrameAccessType type;
            if (node instanceof NewFrameNode) {
                currentState.add((NewFrameNode)node);
            } else if (node instanceof VirtualFrameAccessVerificationNode && (type = (accessor = (VirtualFrameAccessVerificationNode)((Object)node)).getType()) != VirtualFrameAccessType.Auxiliary && FrameAccessVerificationPhase.inRange(entries = currentState.get(accessor), accessor.getFrameSlotIndex())) {
                accessor.updateVerificationState(STATE_UPDATER, entries);
            }
            return currentState;
        }

        @Override
        protected State merge(AbstractMergeNode merge, List<State> states) {
            return this.merge(merge, states, this.effects);
        }

        private State merge(AbstractMergeNode merge, List<State> states, ArrayList<Effect> firstEndEffects) {
            State result = states.get(0).clone();
            HashSet<NewFrameNode> frames = new HashSet<NewFrameNode>(result.indexedStates.keySet());
            for (int i = 1; i < states.size(); ++i) {
                frames.retainAll(states.get((int)i).indexedStates.keySet());
            }
            byte[] entries = new byte[states.size()];
            byte[][] entryArrays = new byte[states.size()][];
            for (NewFrameNode frame : frames) {
                for (int i = 0; i < states.size(); ++i) {
                    entryArrays[i] = states.get((int)i).indexedStates.get(frame);
                }
                byte[] resultEntries = result.indexedStates.get(frame);
                for (int entryIndex = 0; entryIndex < resultEntries.length; ++entryIndex) {
                    for (int i = 0; i < states.size(); ++i) {
                        entries[i] = entryArrays[i][entryIndex];
                    }
                    this.mergeEntries(merge, frame, resultEntries, entries, entryIndex, VirtualFrameAccessType.Indexed, firstEndEffects);
                }
            }
            result.indexedStates.keySet().retainAll(frames);
            return result;
        }

        private void mergeEntries(AbstractMergeNode merge, NewFrameNode frame, byte[] resultEntries, byte[] entries, int entryIndex, VirtualFrameAccessType accessType, ArrayList<Effect> firstEndEffects) {
            byte result = entries[0];
            boolean allMatch = true;
            for (int i = 1; i < entries.length; ++i) {
                if (entries[i] == result) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) {
                int i;
                byte definitiveType = -1;
                for (i = 0; i < entries.length; ++i) {
                    byte entry = entries[i];
                    assert (entry != 121) : "no set/clear nodes with this index should be generated by TruffleGraphBuilderPlugin";
                    if (FrameAccessVerificationPhase.mode(entry) != 16) continue;
                    if (definitiveType == -1) {
                        definitiveType = FrameAccessVerificationPhase.type(entry);
                        continue;
                    }
                    if (definitiveType == FrameAccessVerificationPhase.type(entry)) continue;
                    (i == 0 ? firstEndEffects : this.effects).add(new DeoptEffect(frame, merge.phiPredecessorAt(i), entryIndex, this.compilable));
                    entries[i] = FrameAccessVerificationPhase.withValue(definitiveType);
                }
                result = definitiveType == -1 ? (byte)1 : definitiveType;
                for (i = 0; i < entries.length; ++i) {
                    if (FrameAccessVerificationPhase.type(entries[i]) == result) continue;
                    (i == 0 ? firstEndEffects : this.effects).add(new ClearPrimitiveEffect(frame, merge.phiPredecessorAt(i), entryIndex, result, accessType));
                }
                result = definitiveType == -1 ? FrameAccessVerificationPhase.cleared(result) : FrameAccessVerificationPhase.withValue(result);
            }
            resultEntries[entryIndex] = result;
        }

        @Override
        protected State afterSplit(AbstractBeginNode node, State oldState) {
            return oldState.clone();
        }

        @Override
        protected EconomicMap<LoopExitNode, State> processLoop(LoopBeginNode loop, State initial) {
            ArrayList<Effect> preLoopEffects;
            ReentrantNodeIterator.LoopInfo<State> info;
            State initialState = initial;
            while (true) {
                int sizeBeforeLoop = this.effects.size();
                info = ReentrantNodeIterator.processLoop(this, loop, initialState.clone());
                ArrayList<State> states = new ArrayList<State>();
                states.add(initialState);
                assert (loop.forwardEndCount() == 1);
                for (int i = 1; i < loop.phiPredecessorCount(); ++i) {
                    states.add((State)info.endStates.get((Object)((LoopEndNode)loop.phiPredecessorAt(i))));
                }
                preLoopEffects = new ArrayList<Effect>();
                State mergeResult = this.merge(loop, states, preLoopEffects);
                if (mergeResult.equalsState(initialState)) break;
                initialState = mergeResult;
                while (this.effects.size() > sizeBeforeLoop) {
                    this.effects.remove(this.effects.size() - 1);
                }
                this.effects.addAll(preLoopEffects);
            }
            this.effects.addAll(preLoopEffects);
            return info.exitStates;
        }
    }

    private static final class State
    implements Cloneable {
        private final HashMap<NewFrameNode, byte[]> indexedStates = new HashMap();
        private final ArrayList<Effect> effects;

        State(ArrayList<Effect> effects) {
            this.effects = effects;
        }

        public State clone() {
            State newState = new State(this.effects);
            State.copy(this.indexedStates, newState.indexedStates);
            return newState;
        }

        private static void copy(HashMap<NewFrameNode, byte[]> from, HashMap<NewFrameNode, byte[]> to) {
            for (Map.Entry<NewFrameNode, byte[]> entry : from.entrySet()) {
                to.put(entry.getKey(), (byte[])entry.getValue().clone());
            }
        }

        public void add(NewFrameNode frame) {
            assert (!this.indexedStates.containsKey(frame));
            byte[] indexedEntries = frame.getIndexedFrameSize() == 0 ? EMPTY_BYTE_ARRAY : (byte[])frame.getIndexedFrameSlotKinds().clone();
            this.indexedStates.put(frame, indexedEntries);
        }

        public byte[] get(VirtualFrameAccessVerificationNode accessor) {
            return this.indexedStates.get(accessor.getFrame());
        }

        public boolean equalsState(State other) {
            assert (this.indexedStates.keySet().equals(other.indexedStates.keySet()));
            for (Map.Entry<NewFrameNode, byte[]> entry : this.indexedStates.entrySet()) {
                byte[] otherEntries;
                byte[] entries = entry.getValue();
                if (Arrays.equals(entries, otherEntries = other.indexedStates.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class Effect {
        final NewFrameNode frame;
        final AbstractEndNode insertBefore;
        final int index;

        Effect(NewFrameNode frame, AbstractEndNode insertBefore, int index) {
            this.frame = frame;
            this.insertBefore = insertBefore;
            this.index = index;
        }

        abstract void apply();
    }

    private static final class ClearPrimitiveEffect
    extends Effect {
        final byte accessTag;
        final VirtualFrameAccessType type;

        ClearPrimitiveEffect(NewFrameNode frame, AbstractEndNode insertBefore, int index, byte accessTag, VirtualFrameAccessType type) {
            super(frame, insertBefore, index);
            this.accessTag = accessTag;
            this.type = type;
        }

        @Override
        void apply() {
            if (this.insertBefore.isAlive()) {
                StructuredGraph graph = this.insertBefore.graph();
                ConstantNode defaultForKind = ConstantNode.defaultForKind(NewFrameNode.asJavaKind(this.accessTag), graph);
                graph.addBeforeFixed(this.insertBefore, graph.add(new VirtualFrameSetNode(this.frame, this.index, (int)this.accessTag, (ValueNode)defaultForKind, this.type, VirtualFrameAccessFlags.NON_STATIC_NO_SET_TAG_UPDATE)));
            }
        }
    }

    private final class DeoptEffect
    extends Effect {
        private final TruffleCompilable compilable;

        DeoptEffect(NewFrameNode frame, AbstractEndNode insertBefore, int index, TruffleCompilable compilable) {
            super(frame, insertBefore, index);
            this.compilable = compilable;
        }

        private void logPerformanceWarningClearIntroducedPhi(Node location) {
            if (PerformanceInformationHandler.isWarningEnabled(TruffleCompilerOptions.PerformanceWarningKind.FRAME_INCOMPATIBLE_MERGE)) {
                Graph graph = location.graph();
                DebugContext debug = location.getDebug();
                try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                    LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                    properties.put("location", location);
                    properties.put("method", this.compilable.getName());
                    properties.put("index", this.index);
                    PerformanceInformationHandler.logPerformanceWarning(TruffleCompilerOptions.PerformanceWarningKind.FRAME_INCOMPATIBLE_MERGE, this.compilable, Collections.emptyList(), "Incompatible frame slot types at merge: this disables the frame intrinsics optimization and potentially causes frames to be materialized. Ensure that frame slots are cleared before a control flow merge if they don't contain the same type of value.", properties);
                    debug.dump(3, graph, "perf warn: Incompatible frame slot types for slot %d at %s", this.index, location);
                }
                catch (Throwable t) {
                    debug.handle(t);
                }
            }
        }

        @Override
        void apply() {
            if (this.insertBefore.isAlive()) {
                StructuredGraph graph = this.insertBefore.graph();
                FixedWithNextNode predecessor = (FixedWithNextNode)this.insertBefore.predecessor();
                this.logPerformanceWarningClearIntroducedPhi(predecessor);
                predecessor.setNext(null);
                GraphUtil.killCFG(this.insertBefore);
                if (predecessor.isAlive()) {
                    SpeculationLog.Speculation speculation = graph.getSpeculationLog().speculate(this.frame.getIntrinsifyAccessorsSpeculation());
                    DeoptimizeNode deopt = new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.RuntimeConstraint, speculation);
                    predecessor.setNext(graph.add(deopt));
                }
            }
        }
    }
}

