/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc.logging;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.logging.BaseLogProxy;
import com.ibatis.common.jdbc.logging.PreparedStatementLogProxy;
import com.ibatis.common.jdbc.logging.StatementLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class ConnectionLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(Connection.class);
    private Connection connection;

    private ConnectionLogProxy(Connection conn) {
        this.connection = conn;
        if (log.isDebugEnabled()) {
            log.debug("{conn-" + this.id + "} Connection");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if ("prepareStatement".equals(method.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("{conn-" + this.id + "} Preparing Statement: " + this.removeBreakingWhitespace((String)params[0]));
                }
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogProxy.newInstance(stmt, (String)params[0]);
                return stmt;
            }
            if ("prepareCall".equals(method.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("{conn-" + this.id + "} Preparing Call: " + this.removeBreakingWhitespace((String)params[0]));
                }
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogProxy.newInstance(stmt, (String)params[0]);
                return stmt;
            }
            if ("createStatement".equals(method.getName())) {
                Statement stmt = (Statement)method.invoke((Object)this.connection, params);
                stmt = StatementLogProxy.newInstance(stmt);
                return stmt;
            }
            return method.invoke((Object)this.connection, params);
        }
        catch (Throwable t) {
            Throwable t1 = ClassInfo.unwrapThrowable(t);
            log.error("Error calling Connection." + method.getName() + ":", t1);
            throw t1;
        }
    }

    public static Connection newInstance(Connection conn) {
        ConnectionLogProxy handler = new ConnectionLogProxy(conn);
        ClassLoader cl = Connection.class.getClassLoader();
        return (Connection)Proxy.newProxyInstance(cl, new Class[]{Connection.class}, (InvocationHandler)handler);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

