/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.SimpleDateFormatter;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;

public class SqlTimeTypeHandler
extends BaseTypeHandler
implements TypeHandler {
    private static final String DATE_FORMAT = "hh:mm:ss";

    @Override
    public void setParameter(PreparedStatement ps, int i, Object parameter, String jdbcType) throws SQLException {
        ps.setTime(i, (Time)parameter);
    }

    @Override
    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        Time sqlTime = rs.getTime(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return sqlTime;
    }

    @Override
    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        Time sqlTime = rs.getTime(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return sqlTime;
    }

    @Override
    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Time sqlTime = cs.getTime(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return sqlTime;
    }

    @Override
    public Object valueOf(String s) {
        return SimpleDateFormatter.format(DATE_FORMAT, s);
    }
}

