/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.xadisk.filesystem.Lock;
import org.xadisk.filesystem.TransactionInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLock
implements Lock {
    private static final long serialVersionUID = 1L;
    private final File resource;
    private boolean exclusive = false;
    private boolean upgraded = false;
    private int numHolders = 0;
    private final HashSet<TransactionInformation> holders = new HashSet(10);
    private final ReentrantLock synchLock = new ReentrantLock(false);
    private final Condition mayBeReadable = this.synchLock.newCondition();
    private final Condition mayBeWritable = this.synchLock.newCondition();

    NativeLock(boolean exclusive, File resource) {
        this.exclusive = exclusive;
        this.resource = resource;
    }

    int getNumHolders() {
        return this.numHolders;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    void addHolder(TransactionInformation xid) {
        ++this.numHolders;
        this.holders.add(xid);
    }

    void removeHolder(TransactionInformation xid) {
        --this.numHolders;
        this.holders.remove(xid);
    }

    public HashSet<TransactionInformation> getHolders() {
        assert (this.synchLock.isHeldByCurrentThread());
        return this.holders;
    }

    boolean isAHolder(TransactionInformation xid) {
        return this.holders.contains(xid);
    }

    void reset() {
        this.exclusive = false;
        this.upgraded = false;
        this.numHolders = 0;
        this.holders.clear();
    }

    void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    @Override
    public File getResource() {
        return this.resource;
    }

    void markUpgraded() {
        this.upgraded = true;
    }

    boolean isUpgraded() {
        return this.upgraded;
    }

    public void startSynchBlock() {
        this.synchLock.lock();
    }

    public void endSynchBlock() {
        this.synchLock.unlock();
    }

    void waitTillReadable(long time) throws InterruptedException {
        if (time > 0L) {
            this.mayBeReadable.await(time, TimeUnit.MILLISECONDS);
        } else {
            this.mayBeReadable.await();
        }
    }

    void waitTillWritable(long time) throws InterruptedException {
        if (time > 0L) {
            this.mayBeWritable.await(time, TimeUnit.MILLISECONDS);
        } else {
            this.mayBeWritable.await();
        }
    }

    void notifyWritable() {
        this.mayBeWritable.signal();
    }

    void notifyReadWritable() {
        this.mayBeReadable.signalAll();
        this.mayBeWritable.signal();
    }
}

