/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.exceptions.TransactionTimeoutException;
import org.xadisk.filesystem.workers.TimedWorker;

public class TransactionTimeoutDetector
extends TimedWorker {
    private final NativeXAFileSystem xaFileSystem;

    public TransactionTimeoutDetector(int frequency, NativeXAFileSystem xaFileSystem) {
        super(frequency);
        this.xaFileSystem = xaFileSystem;
    }

    void doWorkOnce() {
        try {
            NativeSession[] sessions = this.xaFileSystem.getAllSessions();
            for (int i = 0; i < sessions.length; ++i) {
                NativeSession session = sessions[i];
                long timeoutValue = session.getTransactionTimeout() * 1000;
                long birthTime = session.getTimeOfEntryToTransaction();
                long timeNow = System.currentTimeMillis();
                if (timeoutValue <= 0L || timeNow - birthTime <= timeoutValue) continue;
                this.xaFileSystem.getConcurrencyControl().interruptTransactionIfWaitingForResourceLock(session.getXid(), (byte)2);
                session.rollbackAsynchronously(new TransactionTimeoutException());
            }
        }
        catch (Throwable t) {
            this.xaFileSystem.notifySystemFailure(t);
        }
    }

    public void release() {
        super.release();
    }

    public void run() {
        super.run();
    }
}

