/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.Encoder;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Uid;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLogRecord {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogRecord.class);
    private static final AtomicInteger sequenceGenerator = new AtomicInteger();
    private final int status;
    private final int recordLength;
    private final int headerLength;
    private final long time;
    private final int sequenceNumber;
    private final int crc32;
    private final Uid gtrid;
    private final SortedSet<String> uniqueNames;
    private final int endRecord;

    public TransactionLogRecord(int status, int recordLength, int headerLength, long time, int sequenceNumber, int crc32, Uid gtrid, Set<String> uniqueNames, int endRecord) {
        this.status = status;
        this.recordLength = recordLength;
        this.headerLength = headerLength;
        this.time = time;
        this.sequenceNumber = sequenceNumber;
        this.crc32 = crc32;
        this.gtrid = gtrid;
        this.uniqueNames = new TreeSet<String>(uniqueNames);
        this.endRecord = endRecord;
    }

    public TransactionLogRecord(int status, Uid gtrid, Set<String> uniqueNames) {
        this.status = status;
        this.time = MonotonicClock.currentTimeMillis();
        this.sequenceNumber = sequenceGenerator.incrementAndGet();
        this.gtrid = gtrid;
        this.uniqueNames = new TreeSet<String>(uniqueNames);
        this.endRecord = 2020504642;
        this.recordLength = this.calculateRecordLength(this.uniqueNames);
        this.headerLength = this.getRecordHeaderLength();
        this.crc32 = this.calculateCrc32();
    }

    public int getStatus() {
        return this.status;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public long getTime() {
        return this.time;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public Uid getGtrid() {
        return this.gtrid;
    }

    public Set<String> getUniqueNames() {
        return Collections.unmodifiableSortedSet(this.uniqueNames);
    }

    public int getEndRecord() {
        return this.endRecord;
    }

    public boolean isCrc32Correct() {
        return this.calculateCrc32() == this.getCrc32();
    }

    public int calculateCrc32() {
        CRC32 crc32 = new CRC32();
        crc32.update(Encoder.intToBytes(this.status));
        crc32.update(Encoder.intToBytes(this.recordLength));
        crc32.update(Encoder.intToBytes(this.headerLength));
        crc32.update(Encoder.longToBytes(this.time));
        crc32.update(Encoder.intToBytes(this.sequenceNumber));
        crc32.update(this.gtrid.getArray());
        crc32.update(Encoder.intToBytes(this.uniqueNames.size()));
        for (String name : this.uniqueNames) {
            crc32.update(Encoder.shortToBytes((short)name.length()));
            try {
                crc32.update(name.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException ex) {
                log.error("unable to convert unique name bytes to US-ASCII", (Throwable)ex);
            }
        }
        crc32.update(Encoder.intToBytes(this.endRecord));
        return (int)crc32.getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("a Bitronix TransactionLogRecord with ");
        sb.append("status=");
        sb.append(Decoder.decodeStatus(this.status));
        sb.append(", ");
        sb.append("recordLength=");
        sb.append(this.recordLength);
        sb.append(", ");
        sb.append("headerLength=");
        sb.append(this.headerLength);
        sb.append(", ");
        sb.append("time=");
        sb.append(this.time);
        sb.append(", ");
        sb.append("sequenceNumber=");
        sb.append(this.sequenceNumber);
        sb.append(", ");
        sb.append("crc32=");
        sb.append(this.crc32);
        sb.append(", ");
        sb.append("gtrid=");
        sb.append(this.gtrid.toString());
        sb.append(", ");
        sb.append("uniqueNames=");
        Iterator it = this.uniqueNames.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    int calculateTotalRecordSize() {
        return this.calculateRecordLength(this.uniqueNames) + 4 + 4;
    }

    private int calculateRecordLength(Set<String> uniqueNames) {
        int totalSize = 0;
        for (String uniqueName : uniqueNames) {
            totalSize += 2 + uniqueName.length();
        }
        return totalSize += this.getFixedRecordLength();
    }

    private int getFixedRecordLength() {
        return 21 + this.gtrid.getArray().length + 4 + 4;
    }

    private int getRecordHeaderLength() {
        return 28;
    }
}

