/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.Scanner;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;
import org.lsc.beans.syncoptions.ISyncOptions;
import org.lsc.utils.output.LdifLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Hooks {
    static final Logger LOGGER = LoggerFactory.getLogger(Hooks.class);
    private static final ObjectMapper Mapper = new ObjectMapper();

    public final void postSyncHook(Optional<String> hook, ISyncOptions.OutputFormat outputFormat, LscModifications lm) {
        hook.ifPresent(h -> Hooks.callHook(lm.getOperation(), h, lm.getMainIdentifier(), outputFormat, lm));
    }

    public static final void callHook(LscModificationType operationType, String hook, String identifier, ISyncOptions.OutputFormat outputFormat, LscModifications lm) {
        LOGGER.info("Calling {} posthook {} with format {} for {}", new Object[]{operationType.getDescription(), hook, outputFormat.toString(), identifier});
        String modifications = null;
        if (operationType != LscModificationType.DELETE_OBJECT) {
            modifications = outputFormat == ISyncOptions.OutputFormat.JSON ? Hooks.getJsonModifications(lm) : LdifLayout.format(lm);
        }
        try {
            Process p;
            if (modifications != null) {
                p = new ProcessBuilder(hook, identifier, operationType.getDescription()).start();
                OutputStream stdin = p.getOutputStream();
                stdin.write(modifications.getBytes());
                stdin.write("\n".getBytes());
                stdin.flush();
                stdin.close();
            } else {
                p = new ProcessBuilder(hook, identifier, operationType.getDescription()).start();
            }
            Hooks.printHookOutput(p.getInputStream(), "stdout", operationType.getDescription(), hook, outputFormat.toString(), identifier, Level.INFO);
            Hooks.printHookOutput(p.getErrorStream(), "stderr", operationType.getDescription(), hook, outputFormat.toString(), identifier, Level.ERROR);
        }
        catch (IOException e) {
            LOGGER.error("Error while calling {} posthook {} with format {} for {}", new Object[]{operationType.getDescription(), hook, outputFormat.toString(), identifier, e});
        }
    }

    public static final String getJsonModifications(LscModifications lm) {
        ObjectWriter ow = Mapper.writer().withDefaultPrettyPrinter();
        String json = "";
        try {
            json = ow.writeValueAsString(lm.getLscAttributeModifications());
        }
        catch (Exception e) {
            LOGGER.error("Error while encoding LSC modifications to json", (Throwable)e);
        }
        return json;
    }

    private static void printHookOutput(final InputStream src, final String output, final String operation, final String hook, final String outputFormat, final String identifier, final Level level) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    LOGGER.atLevel(level).log("Hook {} with format {} for identifier {} and operation {} returned on {}: {}", new Object[]{hook, outputFormat, identifier, operation, output, sc.nextLine()});
                }
            }
        }).start();
    }
}

