/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsc.Configuration;
import org.lsc.SimpleSynchronize;
import org.lsc.configuration.LscConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Launcher.class);
    private List<String> syncType = new ArrayList<String>();
    private List<String> asyncType = new ArrayList<String>();
    private List<String> cleanType = new ArrayList<String>();
    private String configurationLocation;
    private SimpleSynchronize sync;
    private int threads;
    private int timeLimit;
    private static Options options = SimpleSynchronize.getOptions();
    private boolean convertConfiguration;
    private boolean validateConfiguration;
    private CommandLine cmdLine;

    public static void main(String[] args) {
        int status = Launcher.launch(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public static int launch(String[] args) {
        try {
            Launcher obj = new Launcher();
            int retCode = obj.parseOptions(args);
            if (retCode != 0) {
                return retCode;
            }
            return obj.run();
        }
        catch (Exception e) {
            if (!Configuration.isLoggingSetup()) {
                System.err.println("Error: " + e.getMessage());
                e.printStackTrace();
            } else {
                LOGGER.error(e.toString());
                LOGGER.debug(e.toString(), (Throwable)e);
            }
            return 1;
        }
    }

    public int run() {
        try {
            if (this.validateConfiguration) {
                if (this.configurationLocation == null) {
                    Launcher.printHelp();
                    return 1;
                }
                Configuration.setUp(this.configurationLocation, true);
                if (LscConfiguration.isInitialized()) {
                    LOGGER.info("Configuration and environment successfully checked !");
                    return 0;
                }
                LOGGER.info("Configuration validation failed !");
                return 255;
            }
            Configuration.setUp(this.configurationLocation);
            if (!LscConfiguration.isInitialized()) {
                return 255;
            }
            this.sync = new SimpleSynchronize();
            if (!this.sync.parseOptions(this.cmdLine)) {
                Launcher.printHelp();
                return 1;
            }
            if (this.threads > 0) {
                this.sync.setThreads(this.threads);
            }
            if (this.timeLimit > 0) {
                this.sync.setTimeLimit(this.timeLimit);
            }
            this.sync.launch(this.asyncType, this.syncType, this.cleanType);
        }
        catch (Exception e) {
            if (!Configuration.isLoggingSetup()) {
                System.err.println("Error: " + e.toString());
                e.printStackTrace();
            } else {
                LOGGER.error(e.toString());
                LOGGER.debug(e.toString(), (Throwable)e);
            }
            return 1;
        }
        return 0;
    }

    private int parseOptions(String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            this.cmdLine = parser.parse(options, args);
            if (this.cmdLine.hasOption("a")) {
                this.asyncType = this.parseSyncType(this.cmdLine.getOptionValue("a"));
            }
            if (this.cmdLine.hasOption("s")) {
                this.syncType = this.parseSyncType(this.cmdLine.getOptionValue("s"));
            }
            if (this.cmdLine.hasOption("f")) {
                this.configurationLocation = new File(this.cmdLine.getOptionValue("f")).getAbsolutePath();
            }
            if (this.cmdLine.hasOption("t")) {
                this.threads = Integer.parseInt(this.cmdLine.getOptionValue("t"));
            }
            if (this.cmdLine.hasOption("i")) {
                this.timeLimit = Integer.parseInt(this.cmdLine.getOptionValue("i"));
            }
            if (this.cmdLine.hasOption("c")) {
                this.cleanType = this.parseSyncType(this.cmdLine.getOptionValue("c"));
            }
            if (this.cmdLine.hasOption("v")) {
                this.validateConfiguration = true;
            }
            if (this.cmdLine.hasOption("V")) {
                Package p = this.getClass().getPackage();
                String version = p.getImplementationVersion();
                System.out.println("Version: " + version);
                return 1;
            }
            if (this.cmdLine.getOptions().length == 0 || this.cmdLine.hasOption("h") || this.asyncType.size() == 0 && this.syncType.size() == 0 && this.cleanType.size() == 0 && !this.convertConfiguration && !this.validateConfiguration) {
                Launcher.printHelp();
                return 1;
            }
            if (!(this.asyncType.isEmpty() || this.syncType.isEmpty() && this.cleanType.isEmpty())) {
                System.err.println("Asynchronous synchronization is mutually exclusive with synchronous synchronizing and cleaning !");
                Launcher.printHelp();
                return 1;
            }
        }
        catch (MissingArgumentException e) {
            LOGGER.error("Missing arguments ({})", (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
            return 1;
        }
        catch (ParseException e) {
            LOGGER.error("Unable to parse the options ({})", (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
            return 1;
        }
        return 0;
    }

    private List<String> parseSyncType(String syncValue) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(syncValue, ",");
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    private static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("lsc", options);
    }

    static {
        options.addOption("a", "asynchronous-synchronize", true, "Asynchronous synchronization task (one of the available tasks or 'all')");
        options.addOption("s", "synchronize", true, "Synchronization task (one of the available tasks or 'all')");
        options.addOption("c", "clean", true, "Cleaning type (one of the available tasks or 'all')");
        options.addOption("v", "validate", false, "Validate configuration (check connections ...)");
        options.addOption("f", "config", true, "Specify the configuration directory or file");
        options.addOption("t", "threads", true, "Number of parallel threads to synchronize a task (default: 5)");
        options.addOption("i", "time-limit", true, "Time limit in parallel server mode in seconds (default: 3600)");
        options.addOption("h", "help", false, "Get this text");
        options.addOption("V", "version", false, "Get project version");
    }
}

