/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.FilterEncoder;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.lsc.utils.CaseIgnoreStringHashMap;

public class LscDatasets
implements Serializable {
    private static final long serialVersionUID = 746918525778409642L;
    protected Map<String, Object> values;

    public LscDatasets() {
        this.values = new CaseIgnoreStringHashMap<Object>();
    }

    public LscDatasets(Map<String, ?> values) {
        this.values = new CaseIgnoreStringHashMap<Object>(values);
    }

    public String getStringValueAttribute(String attribute) {
        Object value = this.values.get(attribute);
        if (value instanceof Set && ((Set)value).size() > 0) {
            return ((Set)value).iterator().next().toString();
        }
        if (value instanceof List && ((List)value).size() > 0) {
            return ((List)value).get(0).toString();
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value != null ? value.toString() : null;
    }

    public String getValueForFilter(String attribute) {
        Object value = this.values.get(attribute);
        if (value instanceof byte[]) {
            Value binValue = new Value((byte[])value);
            EqualityNode filter = new EqualityNode(new AttributeType(attribute), binValue);
            return filter.getEscapedValue();
        }
        String stringValue = this.getStringValueAttribute(attribute);
        if (stringValue != null) {
            return FilterEncoder.encodeFilterValue((String)stringValue);
        }
        return null;
    }

    public Integer getIntegerValueAttribute(String attribute) {
        return (Integer)this.values.get(attribute);
    }

    public Boolean getBooleanValueAttribute(String attribute) {
        return (Boolean)this.values.get(attribute);
    }

    public List<Object> getListValueAttribute(String attribute) {
        return (List)this.values.get(attribute);
    }

    public List<String> getListStringValueAttribute(String attribute) {
        return (List)this.values.get(attribute);
    }

    public List<Integer> getListIntegerValueAttribute(String attribute) {
        return (List)this.values.get(attribute);
    }

    public List<String> getAttributesNames() {
        return new ArrayList<String>(this.values.keySet());
    }

    public Map<String, Object> getDatasets() {
        return this.values;
    }

    public void setDatasets(Map<String, Object> values) {
        this.values = values;
    }

    public void put(String key, Object value) {
        this.values.put(key, value);
    }

    public String toString() {
        return this.values.toString();
    }
}

