/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.lsc.AbstractSynchronize;
import org.lsc.LscDatasets;
import org.lsc.Task;
import org.lsc.beans.IBean;
import org.lsc.beans.InfoCounter;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscConfigurationException;
import org.lsc.jmx.LscServerImpl;
import org.lsc.runnable.SynchronizeEntryRunner;
import org.lsc.service.IAsynchronousService;
import org.lsc.utils.LSCStructuralLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSynchronize
extends AbstractSynchronize {
    public static final String ALL_TASKS_KEYWORD = "all";
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSynchronize.class);
    public static final List<String> EMPTY_LIST = new ArrayList<String>();
    Map<String, Task> cache;

    public SimpleSynchronize() {
        this.setThreads(5);
        this.cache = new TreeMap<String, Task>();
    }

    public void init(String taskName) throws LscConfigurationException {
        Collection<TaskType> tasks = LscConfiguration.getTasks();
        for (TaskType taskType : tasks) {
            if (!taskType.getName().equalsIgnoreCase(taskName)) continue;
            this.cache.put(taskName, new Task(taskType));
        }
    }

    public void initAllTasks() throws LscConfigurationException {
        Collection<TaskType> tasks = LscConfiguration.getTasks();
        for (TaskType taskType : tasks) {
            String taskName = taskType.getName();
            if (this.cache.containsKey(taskName)) continue;
            this.cache.put(taskName, new Task(taskType));
        }
    }

    private void close() {
        for (Task task : this.cache.values()) {
            if (task.getSourceService() instanceof Closeable) {
                try {
                    ((Closeable)((Object)task.getSourceService())).close();
                }
                catch (IOException e) {
                    LOGGER.error("Error while closing service.");
                }
            }
            if (!(task.getDestinationService() instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)task.getDestinationService())).close();
            }
            catch (IOException e) {
                LOGGER.error("Error while closing service.");
            }
        }
    }

    private boolean processTask(Task task, Task.Mode mode) throws Exception {
        boolean launchResult = this.launchTask(task, mode);
        if (launchResult) {
            switch (mode) {
                case sync: {
                    String syncHook = task.getSyncHook();
                    if (syncHook == null || syncHook.length() == 0) break;
                    this.runPostHook(task.getName(), syncHook, task.getTaskType());
                    break;
                }
                case async: {
                    break;
                }
                case clean: {
                    String cleanHook = task.getCleanHook();
                    if (cleanHook == null || cleanHook.length() == 0) break;
                    this.runPostHook(task.getName(), cleanHook, task.getTaskType());
                }
            }
        }
        return launchResult;
    }

    private int processTasks(List<String> tasks, Task.Mode mode) throws Exception {
        int nbLaunchedTasks = 0;
        boolean launchTask = false;
        if (tasks == null || tasks.size() == 0) {
            return 0;
        }
        if (tasks.contains(ALL_TASKS_KEYWORD)) {
            this.initAllTasks();
            for (TaskType taskType : LscConfiguration.getTasks()) {
                Task task = this.cache.get(taskType.getName());
                launchTask |= this.processTask(task, mode);
                ++nbLaunchedTasks;
            }
        } else {
            for (String taskName : tasks) {
                boolean canLaunch = true;
                Task task = this.cache.get(taskName);
                if (task == null) {
                    TaskType taskType = LscConfiguration.getTask(taskName);
                    if (taskType != null) {
                        task = new Task(taskType);
                        this.cache.put(taskName, task);
                    } else {
                        LOGGER.error("Task '{}' cannot be found in configuration. Check the spelling", (Object)taskName);
                        canLaunch = false;
                    }
                }
                if (!canLaunch) continue;
                launchTask |= this.processTask(task, mode);
                ++nbLaunchedTasks;
            }
        }
        if (!launchTask) {
            return -nbLaunchedTasks;
        }
        return nbLaunchedTasks;
    }

    public final boolean launch(List<String> asyncTasks, List<String> syncTasks, List<String> cleanTasks) throws Exception {
        boolean launchResult = true;
        if (this.getTasksName() == null) {
            return false;
        }
        if (asyncTasks != null && !asyncTasks.isEmpty()) {
            LscServerImpl.startJmx(this);
        }
        int nbLaunchedSyncTasks = this.processTasks(syncTasks, Task.Mode.sync);
        int nbLaunchedCleanTasks = this.processTasks(cleanTasks, Task.Mode.clean);
        int nbLaunchedAsyncTasks = this.processTasks(asyncTasks, Task.Mode.async);
        int nbLaunchedTasks = Math.abs(nbLaunchedSyncTasks) + Math.abs(nbLaunchedCleanTasks) + Math.abs(nbLaunchedAsyncTasks);
        if (nbLaunchedAsyncTasks == 0) {
            this.close();
        }
        if (nbLaunchedTasks == 0) {
            LOGGER.error("No specified tasks could be launched! Check spelling and that they exist in the configuration file.");
            return false;
        }
        return launchResult;
    }

    private boolean launchTask(Task task, Task.Mode taskMode) throws Exception {
        boolean status = true;
        this.addScriptingContext(task);
        try {
            LSCStructuralLogger.DESTINATION.info("Starting {} for {}", (Object)taskMode.name(), (Object)task.getName());
            switch (taskMode) {
                case clean: {
                    status = this.clean2Ldap(task);
                    break;
                }
                case sync: {
                    status = this.synchronize2Ldap(task);
                    break;
                }
                case async: {
                    if (task.getSourceService() instanceof IAsynchronousService || task.getDestinationService() instanceof IAsynchronousService) {
                        this.startAsynchronousSynchronize2Ldap(task);
                        break;
                    }
                    LOGGER.error("Requested asynchronous source service does not implement IAsynchronousService ! (" + task.getSourceService().getClass().getName() + ")");
                    break;
                }
                default: {
                    LOGGER.error("Unknown task mode type {}", (Object)taskMode.toString());
                    throw new InvalidParameterException("Unknown task mode type " + taskMode.toString());
                }
            }
        }
        catch (Exception e) {
            Object[] exceptionsCaught = new Class[]{InstantiationException.class, IllegalAccessException.class, ClassNotFoundException.class, SecurityException.class, NoSuchMethodException.class, IllegalArgumentException.class, InvocationTargetException.class};
            if (ArrayUtils.contains((Object[])exceptionsCaught, e.getClass())) {
                String errorDetail = e instanceof InvocationTargetException && e.getCause() != null ? e.getCause().toString() : e.toString();
                LOGGER.error("Error while launching task \"{}\". Please check your configuration! ({})", (Object)task.getName(), (Object)errorDetail);
                LOGGER.debug(e.toString(), (Throwable)e);
                return false;
            }
            throw e;
        }
        return status;
    }

    private void addScriptingContext(Task task) {
        task.addScriptingVar("nocreate", this.nocreate);
        task.addScriptingVar("noupdate", this.noupdate);
        task.addScriptingVar("nodelete", this.nodelete);
        task.addScriptingVar("nomodrdn", this.nomodrdn);
    }

    private void runPostHook(String taskName, String servicePostHook, TaskType taskType) {
        if (servicePostHook != null && servicePostHook.length() > 0) {
            LOGGER.debug("Service Post Hook found: " + servicePostHook);
            String hookClass = servicePostHook.substring(0, servicePostHook.lastIndexOf(46));
            String hookMethod = servicePostHook.substring(servicePostHook.lastIndexOf(46) + 1);
            LOGGER.debug("Hook Class: " + hookClass);
            LOGGER.debug("Hook Method: " + hookMethod);
            if (hookClass.length() > 0 && hookMethod.length() > 0) {
                try {
                    Class<?> clazz = Class.forName(hookClass);
                    try {
                        Method hook = clazz.getMethod(hookMethod, TaskType.class);
                        hook.invoke(null, taskType);
                    }
                    catch (NoSuchMethodException e) {
                        Method hook = clazz.getMethod(hookMethod, new Class[0]);
                        hook.invoke(null, new Object[0]);
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Invalid Hook Class specified " + hookClass + " for task " + taskName);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("Invalid hook method " + hookMethod + " specified for task " + taskName);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid argument exception for hook method " + hookClass + "." + hookMethod);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Illegal access exception for hook method " + hookClass + "." + hookMethod);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("Invocation target exception for hook method " + hookClass + "." + hookMethod);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
            }
        }
    }

    public Set<Map.Entry<String, Task>> getTasksName() {
        return this.cache.entrySet();
    }

    @Override
    public boolean isAsynchronousTask(String taskName) {
        return this.cache.get(taskName).getSourceService() instanceof IAsynchronousService;
    }

    @Override
    public Task getTask(String taskName) {
        return this.cache.get(taskName);
    }

    @Override
    public Task[] getTasks() {
        return this.cache.values().toArray(new Task[this.cache.values().size()]);
    }

    public final boolean launchById(String taskName, Map<String, LscDatasets> entries) {
        Task task = this.cache.get(taskName);
        InfoCounter counter = new InfoCounter();
        for (Map.Entry<String, LscDatasets> entry : entries.entrySet()) {
            new SynchronizeEntryRunner(task, counter, this, entry, true).run();
        }
        return counter.getCountError() == 0;
    }

    public final boolean launch(String taskName, IBean bean) {
        Task task = this.cache.get(taskName);
        InfoCounter counter = new InfoCounter();
        return new SynchronizeEntryRunner(task, counter, this, null, true).run(bean);
    }
}

